/*
 * Decompiled with CFR 0.152.
 */
package net2.sf.saxon.expr;

import java.io.Serializable;
import java.util.Iterator;
import javax.xml.transform.SourceLocator;
import net2.sf.saxon.expr.AtomicMappingExpression;
import net2.sf.saxon.expr.ContextMappingFunction;
import net2.sf.saxon.expr.ContextMappingIterator;
import net2.sf.saxon.expr.ContextSwitchingExpression;
import net2.sf.saxon.expr.Expression;
import net2.sf.saxon.expr.ExpressionTool;
import net2.sf.saxon.expr.ExpressionVisitor;
import net2.sf.saxon.expr.ItemMappingFunction;
import net2.sf.saxon.expr.ItemMappingIterator;
import net2.sf.saxon.expr.Literal;
import net2.sf.saxon.expr.MonoIterator;
import net2.sf.saxon.expr.Optimizer;
import net2.sf.saxon.expr.PairIterator;
import net2.sf.saxon.expr.ParentNodeExpression;
import net2.sf.saxon.expr.PathExpression;
import net2.sf.saxon.expr.PromotionOffer;
import net2.sf.saxon.expr.RoleLocator;
import net2.sf.saxon.expr.RootExpression;
import net2.sf.saxon.expr.TypeChecker;
import net2.sf.saxon.expr.XPathContext;
import net2.sf.saxon.expr.XPathContextMinor;
import net2.sf.saxon.functions.SystemFunction;
import net2.sf.saxon.om.EmptyIterator;
import net2.sf.saxon.om.FunctionItem;
import net2.sf.saxon.om.Item;
import net2.sf.saxon.om.NodeInfo;
import net2.sf.saxon.om.SequenceIterator;
import net2.sf.saxon.pattern.AnyNodeTest;
import net2.sf.saxon.sort.DocumentOrderIterator;
import net2.sf.saxon.sort.DocumentSorter;
import net2.sf.saxon.sort.GlobalOrderComparer;
import net2.sf.saxon.trace.ExpressionPresenter;
import net2.sf.saxon.trans.XPathException;
import net2.sf.saxon.type.BuiltInAtomicType;
import net2.sf.saxon.type.ItemType;
import net2.sf.saxon.type.Type;
import net2.sf.saxon.type.TypeHierarchy;
import net2.sf.saxon.value.AtomicValue;
import net2.sf.saxon.value.Cardinality;
import net2.sf.saxon.value.EmptySequence;
import net2.sf.saxon.value.SequenceType;

public class SlashExpression
extends Expression
implements ContextMappingFunction,
ContextSwitchingExpression {
    Expression start;
    Expression step;

    public SlashExpression(Expression start, Expression step) {
        this.start = start;
        this.step = step;
        this.adoptChildExpression(start);
        this.adoptChildExpression(step);
    }

    protected void setStartExpression(Expression start2) {
        if (this.start != start2) {
            this.start = start2;
            this.adoptChildExpression(this.start);
        }
    }

    protected void setStepExpression(Expression step2) {
        if (this.step != step2) {
            this.step = step2;
            this.adoptChildExpression(this.step);
        }
    }

    public static SlashExpression makeSlashExpression(Expression start, Expression step, TypeHierarchy th) {
        ItemType itemType = step.getItemType(th);
        if (th.isSubType(itemType, AnyNodeTest.getInstance())) {
            return new PathExpression(start, step);
        }
        if (th.isSubType(itemType, BuiltInAtomicType.ANY_ATOMIC)) {
            return new AtomicMappingExpression(start, step);
        }
        return new SlashExpression(start, step);
    }

    @Override
    public Expression getControllingExpression() {
        return this.start;
    }

    @Override
    public Expression getControlledExpression() {
        return this.step;
    }

    public boolean isHybrid() {
        return true;
    }

    @Override
    public Expression simplify(ExpressionVisitor visitor) throws XPathException {
        this.setStartExpression(visitor.simplify(this.start));
        this.setStepExpression(visitor.simplify(this.step));
        if (Literal.isEmptySequence(this.start)) {
            return this.start;
        }
        if (Literal.isEmptySequence(this.step)) {
            return this.step;
        }
        if (this.start instanceof RootExpression && this.step instanceof ParentNodeExpression) {
            return Literal.makeEmptySequence();
        }
        return this;
    }

    @Override
    public final ItemType getItemType(TypeHierarchy th) {
        return this.step.getItemType(th);
    }

    @Override
    public Expression typeCheck(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        TypeHierarchy th = visitor.getConfiguration().getTypeHierarchy();
        Expression start2 = visitor.typeCheck(this.start, contextItemType);
        RoleLocator role0 = new RoleLocator(1, (Serializable)((Object)"/"), 0);
        role0.setErrorCode("XPTY0019");
        this.setStartExpression(TypeChecker.staticTypeCheck(start2, SequenceType.NODE_SEQUENCE, false, role0, visitor));
        this.setStepExpression(visitor.typeCheck(this.step, this.start.getItemType(th)));
        ItemType stepType = this.step.getItemType(th);
        if (th.isSubType(stepType, Type.NODE_TYPE)) {
            if ((this.step.getSpecialProperties() & 0x400000) != 0) {
                Optimizer opt = visitor.getConfiguration().getOptimizer();
                start2 = ExpressionTool.unsorted(opt, this.start, false);
                Expression step2 = ExpressionTool.unsorted(opt, this.step, false);
                PathExpression path = new PathExpression(start2, step2);
                ExpressionTool.copyLocationInfo(this, path);
                Expression sortedPath = path.addDocumentSorter();
                ExpressionTool.copyLocationInfo(this, sortedPath);
                sortedPath = sortedPath.simplify(visitor);
                return sortedPath.typeCheck(visitor, contextItemType);
            }
            int props = this.getSpecialProperties();
            if ((props & 0x20000) != 0) {
                return this;
            }
            if ((props & 0x40000) != 0) {
                return SystemFunction.makeSystemFunction("reverse", new Expression[]{this});
            }
            return new DocumentSorter(this);
        }
        if (stepType.isAtomicType()) {
            AtomicMappingExpression ame = new AtomicMappingExpression(this.start, this.step);
            ExpressionTool.copyLocationInfo(this, ame);
            return visitor.typeCheck(visitor.simplify(ame), contextItemType);
        }
        return this;
    }

    @Override
    public Expression optimize(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        TypeHierarchy th = visitor.getConfiguration().getTypeHierarchy();
        this.setStartExpression(visitor.optimize(this.start, contextItemType));
        this.setStepExpression(this.step.optimize(visitor, this.start.getItemType(th)));
        if (Literal.isEmptySequence(this.start) || Literal.isEmptySequence(this.step)) {
            return new Literal(EmptySequence.getInstance());
        }
        return this.promoteFocusIndependentSubexpressions(visitor, contextItemType);
    }

    protected Expression promoteFocusIndependentSubexpressions(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        Optimizer opt = visitor.getConfiguration().getOptimizer();
        PromotionOffer offer = new PromotionOffer(opt);
        offer.action = 10;
        offer.promoteDocumentDependent = (this.start.getSpecialProperties() & 0x10000) != 0;
        offer.containingExpression = this;
        this.setStepExpression(this.doPromotion(this, this.step, offer));
        visitor.resetStaticProperties();
        if (offer.containingExpression != this) {
            offer.containingExpression = visitor.optimize(visitor.typeCheck(offer.containingExpression, contextItemType), contextItemType);
            return offer.containingExpression;
        }
        return this;
    }

    @Override
    public Expression promote(PromotionOffer offer, Expression parent) throws XPathException {
        Expression exp = offer.accept(parent, this);
        if (exp != null) {
            return exp;
        }
        this.setStartExpression(this.doPromotion(this, this.start, offer));
        if (offer.action == 12 || offer.action == 14) {
            this.setStepExpression(this.doPromotion(this, this.step, offer));
        }
        return this;
    }

    @Override
    public Iterator<Expression> iterateSubExpressions() {
        return new PairIterator(this.start, this.step);
    }

    @Override
    public Iterator<Expression> iterateSameFocusSubExpressions() {
        return new MonoIterator(this.start);
    }

    @Override
    public boolean hasLoopingSubexpression(Expression child) {
        return child == this.step;
    }

    @Override
    public boolean replaceSubExpression(Expression original, Expression replacement) {
        boolean found = false;
        if (this.start == original) {
            this.setStartExpression(replacement);
            found = true;
        }
        if (this.step == original) {
            this.setStepExpression(replacement);
            found = true;
        }
        return found;
    }

    @Override
    public int computeDependencies() {
        return this.start.getDependencies() | this.step.getDependencies() & 0x3E1;
    }

    @Override
    public Expression copy() {
        return new SlashExpression(this.start.copy(), this.step.copy());
    }

    @Override
    public int computeSpecialProperties() {
        int p = super.computeSpecialProperties();
        if ((this.start.getSpecialProperties() & this.step.getSpecialProperties() & 0x400000) != 0) {
            p |= 0x400000;
        }
        return p;
    }

    @Override
    public int computeCardinality() {
        int c1 = this.start.getCardinality();
        int c2 = this.step.getCardinality();
        return Cardinality.multiply(c1, c2);
    }

    public boolean equals(Object other) {
        if (!(other instanceof SlashExpression)) {
            return false;
        }
        SlashExpression p = (SlashExpression)other;
        return this.start.equals(p.start) && this.step.equals(p.step);
    }

    public int hashCode() {
        return "SlashExpression".hashCode() + this.start.hashCode() + this.step.hashCode();
    }

    @Override
    public SequenceIterator iterate(final XPathContext context) throws XPathException {
        SequenceIterator result = this.start.iterate(context);
        XPathContextMinor context2 = context.newMinorContext();
        context2.setCurrentIterator(result);
        context2.setOrigin(this);
        context2.setOriginatingConstructType(2025);
        result = new ContextMappingIterator(this, context2);
        final SlashExpression loc = this;
        Item first = result.next();
        if (first == null) {
            return EmptyIterator.getInstance();
        }
        if (first instanceof AtomicValue || first instanceof FunctionItem) {
            ItemMappingFunction atomicValueChecker = new ItemMappingFunction(){

                @Override
                public Item map(Item item) throws XPathException {
                    if (item instanceof AtomicValue || item instanceof FunctionItem) {
                        return item;
                    }
                    throw SlashExpression.this.reportMixedItems(loc, context);
                }
            };
            return new ItemMappingIterator(result.getAnother(), atomicValueChecker, true);
        }
        ItemMappingFunction nodeChecker = new ItemMappingFunction(){

            @Override
            public Item map(Item item) throws XPathException {
                if (item instanceof NodeInfo) {
                    return item;
                }
                throw SlashExpression.this.reportMixedItems(loc, context);
            }
        };
        return new DocumentOrderIterator(new ItemMappingIterator(result.getAnother(), nodeChecker, true), GlobalOrderComparer.getInstance());
    }

    private XPathException reportMixedItems(SourceLocator loc, XPathContext context) {
        XPathException err = new XPathException("Cannot mix nodes and atomic values in the result of a path expression");
        err.setErrorCode("XPTY0018");
        err.setLocator(loc);
        err.setXPathContext(context);
        return err;
    }

    @Override
    public final SequenceIterator map(XPathContext context) throws XPathException {
        return this.step.iterate(context);
    }

    @Override
    public void explain(ExpressionPresenter destination) {
        destination.startElement("slash");
        this.start.explain(destination);
        this.step.explain(destination);
        destination.endElement();
    }

    public Expression getFirstStep() {
        if (this.start instanceof SlashExpression) {
            return ((SlashExpression)this.start).getFirstStep();
        }
        return this.start;
    }

    public Expression getRemainingSteps() {
        if (this.start instanceof SlashExpression) {
            SlashExpression rem = new SlashExpression(((PathExpression)this.start).getRemainingSteps(), this.step);
            ExpressionTool.copyLocationInfo(this.start, rem);
            return rem;
        }
        return this.step;
    }

    public Expression getLastStep() {
        if (this.step instanceof SlashExpression) {
            return ((SlashExpression)this.step).getLastStep();
        }
        return this.step;
    }

    public Expression getLeadingSteps() {
        if (this.step instanceof SlashExpression) {
            PathExpression rem = new PathExpression(this.start, ((PathExpression)this.step).getLeadingSteps());
            ExpressionTool.copyLocationInfo(this.start, rem);
            return rem;
        }
        return this.start;
    }
}

