/*
 * Decompiled with CFR 0.152.
 */
package net2.sf.saxon.expr;

import net2.sf.saxon.expr.BinaryExpression;
import net2.sf.saxon.expr.ComparisonExpression;
import net2.sf.saxon.expr.Expression;
import net2.sf.saxon.expr.GeneralComparison;
import net2.sf.saxon.expr.XPathContext;
import net2.sf.saxon.om.Item;
import net2.sf.saxon.sort.AtomicComparer;
import net2.sf.saxon.trace.ExpressionPresenter;
import net2.sf.saxon.trans.XPathException;
import net2.sf.saxon.type.BuiltInAtomicType;
import net2.sf.saxon.type.ItemType;
import net2.sf.saxon.type.TypeHierarchy;
import net2.sf.saxon.value.AtomicValue;
import net2.sf.saxon.value.BooleanValue;

public class SingletonComparison
extends BinaryExpression
implements ComparisonExpression {
    private AtomicComparer comparer;
    private boolean needsRuntimeCheck = true;

    public SingletonComparison(Expression p1, int operator, Expression p2, boolean checkTypes) {
        super(p1, operator, p2);
        this.needsRuntimeCheck = checkTypes;
    }

    public void setAtomicComparer(AtomicComparer comp) {
        this.comparer = comp;
    }

    @Override
    public AtomicComparer getAtomicComparer() {
        return this.comparer;
    }

    @Override
    public int getSingletonOperator() {
        return this.operator;
    }

    @Override
    public boolean convertsUntypedToOther() {
        return true;
    }

    @Override
    public int computeCardinality() {
        return 16384;
    }

    @Override
    public ItemType getItemType(TypeHierarchy th) {
        return BuiltInAtomicType.BOOLEAN;
    }

    @Override
    public Expression copy() {
        SingletonComparison sc = new SingletonComparison(this.operand0.copy(), this.operator, this.operand1.copy(), this.needsRuntimeCheck);
        sc.comparer = this.comparer;
        return sc;
    }

    public boolean needsRuntimeComparabilityCheck() {
        return this.needsRuntimeCheck;
    }

    @Override
    public Item evaluateItem(XPathContext context) throws XPathException {
        return BooleanValue.get(this.effectiveBooleanValue(context));
    }

    @Override
    public boolean effectiveBooleanValue(XPathContext context) throws XPathException {
        AtomicValue v1 = (AtomicValue)this.operand0.evaluateItem(context);
        if (v1 == null) {
            return false;
        }
        AtomicValue v2 = (AtomicValue)this.operand1.evaluateItem(context);
        if (v2 == null) {
            return false;
        }
        try {
            return GeneralComparison.compare(v1, this.operator, v2, this.comparer, this.needsRuntimeCheck, context);
        }
        catch (XPathException e) {
            e.maybeSetLocation(this);
            e.maybeSetContext(context);
            throw e;
        }
    }

    @Override
    protected void explainExtraAttributes(ExpressionPresenter out) {
        out.emitAttribute("cardinality", "singleton");
    }
}

