/*
 * Decompiled with CFR 0.152.
 */
package net2.sf.saxon.expr;

import net2.sf.saxon.expr.Expression;
import net2.sf.saxon.expr.ExpressionVisitor;
import net2.sf.saxon.expr.XPathContext;
import net2.sf.saxon.om.Item;
import net2.sf.saxon.om.NodeInfo;
import net2.sf.saxon.om.SequenceIterator;
import net2.sf.saxon.om.SingletonIterator;
import net2.sf.saxon.pattern.AnyNodeTest;
import net2.sf.saxon.trans.XPathException;
import net2.sf.saxon.type.ItemType;
import net2.sf.saxon.type.TypeHierarchy;

public abstract class SingleNodeExpression
extends Expression {
    @Override
    public Expression typeCheck(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        if (contextItemType == null) {
            XPathException err = new XPathException(String.valueOf(this.noContextMessage()) + ": the context item is undefined");
            err.setErrorCode("XPDY0002");
            err.setIsTypeError(true);
            err.setLocator(this);
            throw err;
        }
        if (contextItemType.isAtomicType()) {
            XPathException err = new XPathException(String.valueOf(this.noContextMessage()) + ": the context item is an atomic value");
            err.setErrorCode("XPTY0020");
            err.setIsTypeError(true);
            err.setLocator(this);
            throw err;
        }
        return this;
    }

    protected abstract String noContextMessage();

    @Override
    public Expression optimize(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        return this.typeCheck(visitor, contextItemType);
    }

    @Override
    public int computeCardinality() {
        return 24576;
    }

    @Override
    public ItemType getItemType(TypeHierarchy th) {
        return AnyNodeTest.getInstance();
    }

    @Override
    public int getIntrinsicDependencies() {
        return 2;
    }

    @Override
    public int computeSpecialProperties() {
        return 0xC30000;
    }

    public abstract NodeInfo getNode(XPathContext var1) throws XPathException;

    @Override
    public SequenceIterator iterate(XPathContext context) throws XPathException {
        return SingletonIterator.makeIterator(this.getNode(context));
    }

    @Override
    public Item evaluateItem(XPathContext context) throws XPathException {
        return this.getNode(context);
    }

    @Override
    public boolean effectiveBooleanValue(XPathContext context) throws XPathException {
        return this.getNode(context) != null;
    }
}

