/*
 * Decompiled with CFR 0.152.
 */
package net2.sf.saxon.expr;

import net2.sf.saxon.expr.AxisExpression;
import net2.sf.saxon.expr.ContextItemExpression;
import net2.sf.saxon.expr.Expression;
import net2.sf.saxon.expr.PathMap;
import net2.sf.saxon.expr.SingleNodeExpression;
import net2.sf.saxon.expr.XPathContext;
import net2.sf.saxon.om.DocumentInfo;
import net2.sf.saxon.om.Item;
import net2.sf.saxon.om.NodeInfo;
import net2.sf.saxon.pattern.NodeKindTest;
import net2.sf.saxon.trace.ExpressionPresenter;
import net2.sf.saxon.trans.XPathException;
import net2.sf.saxon.type.ItemType;
import net2.sf.saxon.type.TypeHierarchy;

public class RootExpression
extends SingleNodeExpression {
    @Override
    protected String noContextMessage() {
        return "Leading '/' cannot select the root node of the tree containing the context item";
    }

    public boolean equals(Object other) {
        return other instanceof RootExpression;
    }

    @Override
    public final int computeCardinality() {
        return 16384;
    }

    @Override
    public ItemType getItemType(TypeHierarchy th) {
        return NodeKindTest.DOCUMENT;
    }

    public int hashCode() {
        return "RootExpression".hashCode();
    }

    @Override
    public NodeInfo getNode(XPathContext context) throws XPathException {
        Item current = context.getContextItem();
        if (current == null) {
            this.dynamicError("Finding root of tree: the context item is undefined", "XPDY0002", context);
        }
        if (current instanceof NodeInfo) {
            DocumentInfo doc = ((NodeInfo)current).getDocumentRoot();
            if (doc == null) {
                this.dynamicError("The root of the tree containing the context item is not a document node", "XPDY0050", context);
            }
            return doc;
        }
        this.typeError("Finding root of tree: the context item is not a node", "XPTY0020", context);
        return null;
    }

    @Override
    public int getIntrinsicDependencies() {
        return 16;
    }

    @Override
    public Expression copy() {
        return new RootExpression();
    }

    @Override
    public PathMap.PathMapNodeSet addToPathMap(PathMap pathMap, PathMap.PathMapNodeSet pathMapNodeSet) {
        if (pathMapNodeSet == null) {
            ContextItemExpression cie = new ContextItemExpression();
            cie.setContainer(this.getContainer());
            pathMapNodeSet = new PathMap.PathMapNodeSet(pathMap.makeNewRoot(cie));
        }
        AxisExpression root = new AxisExpression(1, NodeKindTest.DOCUMENT);
        root.setContainer(this.getContainer());
        return root.addToPathMap(pathMap, pathMapNodeSet);
    }

    @Override
    public String toString() {
        return "(/)";
    }

    @Override
    public void explain(ExpressionPresenter destination) {
        destination.startElement("root");
        destination.endElement();
    }
}

