/*
 * Decompiled with CFR 0.152.
 */
package net2.sf.saxon.expr;

import net2.sf.saxon.expr.LastPositionFinder;
import net2.sf.saxon.expr.RangeIterator;
import net2.sf.saxon.expr.ReversibleIterator;
import net2.sf.saxon.om.Item;
import net2.sf.saxon.om.LookaheadIterator;
import net2.sf.saxon.om.SequenceIterator;
import net2.sf.saxon.trans.XPathException;
import net2.sf.saxon.value.Int64Value;

public class ReverseRangeIterator
implements SequenceIterator,
ReversibleIterator,
LastPositionFinder,
LookaheadIterator {
    long start;
    long currentValue;
    long limit;

    public ReverseRangeIterator(long start, long end) {
        this.start = start;
        this.currentValue = start + 1L;
        this.limit = end;
    }

    @Override
    public boolean hasNext() {
        return this.currentValue > this.limit;
    }

    @Override
    public Item next() {
        if (--this.currentValue < this.limit) {
            return null;
        }
        return Int64Value.makeIntegerValue(this.currentValue);
    }

    @Override
    public Item current() {
        if (this.currentValue < this.limit) {
            return null;
        }
        return Int64Value.makeIntegerValue(this.currentValue);
    }

    @Override
    public int position() {
        if (this.currentValue < this.limit) {
            return -1;
        }
        return (int)(this.start - this.currentValue + 1L);
    }

    @Override
    public void close() {
    }

    @Override
    public int getLastPosition() {
        return (int)(this.start - this.limit + 1L);
    }

    @Override
    public SequenceIterator getAnother() throws XPathException {
        return new ReverseRangeIterator(this.start, this.limit);
    }

    @Override
    public int getProperties() {
        return 6;
    }

    @Override
    public SequenceIterator getReverseIterator() {
        return new RangeIterator(this.limit, this.start);
    }
}

