/*
 * Decompiled with CFR 0.152.
 */
package net2.sf.saxon.expr;

import java.io.Serializable;
import net2.sf.saxon.expr.BinaryExpression;
import net2.sf.saxon.expr.Expression;
import net2.sf.saxon.expr.ExpressionTool;
import net2.sf.saxon.expr.ExpressionVisitor;
import net2.sf.saxon.expr.Literal;
import net2.sf.saxon.expr.RangeIterator;
import net2.sf.saxon.expr.RoleLocator;
import net2.sf.saxon.expr.TypeChecker;
import net2.sf.saxon.expr.XPathContext;
import net2.sf.saxon.om.EmptyIterator;
import net2.sf.saxon.om.SequenceIterator;
import net2.sf.saxon.trans.XPathException;
import net2.sf.saxon.type.BuiltInAtomicType;
import net2.sf.saxon.type.ItemType;
import net2.sf.saxon.type.TypeHierarchy;
import net2.sf.saxon.value.AtomicValue;
import net2.sf.saxon.value.Int64Value;
import net2.sf.saxon.value.IntegerRange;
import net2.sf.saxon.value.NumericValue;
import net2.sf.saxon.value.SequenceType;
import net2.sf.saxon.value.Value;

public class RangeExpression
extends BinaryExpression {
    public RangeExpression(Expression start, int op, Expression end) {
        super(start, op, end);
    }

    @Override
    public Expression typeCheck(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        this.operand0 = visitor.typeCheck(this.operand0, contextItemType);
        this.operand1 = visitor.typeCheck(this.operand1, contextItemType);
        boolean backCompat = visitor.getStaticContext().isInBackwardsCompatibleMode();
        RoleLocator role0 = new RoleLocator(1, (Serializable)((Object)"to"), 0);
        this.operand0 = TypeChecker.staticTypeCheck(this.operand0, SequenceType.OPTIONAL_INTEGER, backCompat, role0, visitor);
        RoleLocator role1 = new RoleLocator(1, (Serializable)((Object)"to"), 1);
        this.operand1 = TypeChecker.staticTypeCheck(this.operand1, SequenceType.OPTIONAL_INTEGER, backCompat, role1, visitor);
        return this.makeConstantRange();
    }

    @Override
    public Expression optimize(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        this.operand0 = visitor.optimize(this.operand0, contextItemType);
        this.operand1 = visitor.optimize(this.operand1, contextItemType);
        return this.makeConstantRange();
    }

    private Expression makeConstantRange() {
        if (this.operand0 instanceof Literal && this.operand1 instanceof Literal) {
            Value v0 = ((Literal)this.operand0).getValue();
            Value v1 = ((Literal)this.operand1).getValue();
            if (v0 instanceof Int64Value && v1 instanceof Int64Value) {
                long i1;
                long i0 = ((Int64Value)v0).longValue();
                Literal result = i0 > (i1 = ((Int64Value)v1).longValue()) ? Literal.makeEmptySequence() : (i0 == i1 ? Literal.makeLiteral(Int64Value.makeIntegerValue(i0)) : Literal.makeLiteral(new IntegerRange(i0, i1)));
                ExpressionTool.copyLocationInfo(this, result);
                return result;
            }
        }
        return this;
    }

    @Override
    public ItemType getItemType(TypeHierarchy th) {
        return BuiltInAtomicType.INTEGER;
    }

    @Override
    public int computeCardinality() {
        return 57344;
    }

    @Override
    public Expression copy() {
        return new RangeExpression(this.operand0.copy(), this.operator, this.operand1.copy());
    }

    @Override
    public SequenceIterator iterate(XPathContext context) throws XPathException {
        AtomicValue av1 = (AtomicValue)this.operand0.evaluateItem(context);
        if (av1 == null) {
            return EmptyIterator.getInstance();
        }
        NumericValue v1 = (NumericValue)av1;
        AtomicValue av2 = (AtomicValue)this.operand1.evaluateItem(context);
        if (av2 == null) {
            return EmptyIterator.getInstance();
        }
        NumericValue v2 = (NumericValue)av2;
        if (v1.compareTo(v2) > 0) {
            return EmptyIterator.getInstance();
        }
        return new RangeIterator(v1.longValue(), v2.longValue());
    }
}

