/*
 * Decompiled with CFR 0.152.
 */
package net2.sf.saxon.expr;

import net2.sf.saxon.expr.Assignation;
import net2.sf.saxon.expr.Binding;
import net2.sf.saxon.expr.Expression;
import net2.sf.saxon.expr.ExpressionTool;
import net2.sf.saxon.expr.ExpressionVisitor;
import net2.sf.saxon.expr.LetExpression;
import net2.sf.saxon.expr.Literal;
import net2.sf.saxon.expr.Optimizer;
import net2.sf.saxon.expr.PromotionOffer;
import net2.sf.saxon.expr.RoleLocator;
import net2.sf.saxon.expr.Token;
import net2.sf.saxon.expr.TypeChecker;
import net2.sf.saxon.expr.XPathContext;
import net2.sf.saxon.functions.BooleanFn;
import net2.sf.saxon.om.Item;
import net2.sf.saxon.om.SequenceIterator;
import net2.sf.saxon.trace.ExpressionPresenter;
import net2.sf.saxon.trans.XPathException;
import net2.sf.saxon.type.BuiltInAtomicType;
import net2.sf.saxon.type.ItemType;
import net2.sf.saxon.type.TypeHierarchy;
import net2.sf.saxon.value.BooleanValue;
import net2.sf.saxon.value.SequenceType;

public class QuantifiedExpression
extends Assignation {
    private int operator;

    public void setOperator(int operator) {
        this.operator = operator;
    }

    public int getOperator() {
        return this.operator;
    }

    @Override
    public int computeCardinality() {
        return 16384;
    }

    @Override
    public Expression typeCheck(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        TypeHierarchy th = visitor.getConfiguration().getTypeHierarchy();
        this.sequence = visitor.typeCheck(this.sequence, contextItemType);
        if (Literal.isEmptySequence(this.sequence)) {
            return Literal.makeLiteral(BooleanValue.get(this.operator != 31));
        }
        Optimizer opt = visitor.getConfiguration().getOptimizer();
        this.sequence = ExpressionTool.unsorted(opt, this.sequence, false);
        SequenceType decl = this.getRequiredType();
        SequenceType sequenceType = SequenceType.makeSequenceType(decl.getPrimaryType(), 57344);
        RoleLocator role = new RoleLocator(3, this.getVariableQName(), 0);
        this.sequence = TypeChecker.strictTypeCheck(this.sequence, sequenceType, role, visitor.getStaticContext());
        ItemType actualItemType = this.sequence.getItemType(th);
        this.refineTypeInformation(actualItemType, 16384, null, this.sequence.getSpecialProperties(), visitor, this);
        this.action = visitor.typeCheck(this.action, contextItemType);
        XPathException err = TypeChecker.ebvError(this.action, visitor.getConfiguration().getTypeHierarchy());
        if (err != null) {
            err.setLocator(this);
            throw err;
        }
        return this;
    }

    @Override
    public Expression optimize(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        Optimizer opt = visitor.getConfiguration().getOptimizer();
        this.sequence = visitor.optimize(this.sequence, contextItemType);
        this.action = visitor.optimize(this.action, contextItemType);
        Expression ebv = BooleanFn.rewriteEffectiveBooleanValue(this.action, visitor, contextItemType);
        if (ebv != null) {
            this.action = ebv;
            this.adoptChildExpression(ebv);
        }
        PromotionOffer offer = new PromotionOffer(opt);
        offer.containingExpression = this;
        offer.action = 11;
        offer.bindingList = new Binding[]{this};
        this.action = this.doPromotion(this, this.action, offer);
        if (offer.containingExpression instanceof LetExpression) {
            offer.containingExpression = visitor.optimize(visitor.typeCheck(offer.containingExpression, contextItemType), contextItemType);
        }
        return offer.containingExpression;
    }

    @Override
    public void checkForUpdatingSubexpressions() throws XPathException {
        this.sequence.checkForUpdatingSubexpressions();
        this.action.checkForUpdatingSubexpressions();
    }

    @Override
    public boolean isUpdatingExpression() {
        return false;
    }

    @Override
    public Expression copy() {
        QuantifiedExpression qe = new QuantifiedExpression();
        qe.setOperator(this.operator);
        qe.setVariableQName(this.variableName);
        qe.setRequiredType(this.requiredType);
        qe.setSequence(this.sequence.copy());
        Expression newAction = this.action.copy();
        qe.setAction(newAction);
        qe.variableName = this.variableName;
        ExpressionTool.rebindVariableReferences(newAction, this, qe);
        return qe;
    }

    @Override
    public boolean hasLoopingSubexpression(Expression child) {
        return child == this.action;
    }

    @Override
    public int computeSpecialProperties() {
        int p = super.computeSpecialProperties();
        return p | 0x400000;
    }

    @Override
    public Item evaluateItem(XPathContext context) throws XPathException {
        return BooleanValue.get(this.effectiveBooleanValue(context));
    }

    @Override
    public boolean effectiveBooleanValue(XPathContext context) throws XPathException {
        Item it;
        SequenceIterator base = this.sequence.iterate(context);
        boolean some = this.operator == 31;
        int slot = this.getLocalSlotNumber();
        while ((it = base.next()) != null) {
            context.setLocalVariable(slot, it);
            if (some != this.action.effectiveBooleanValue(context)) continue;
            base.close();
            return some;
        }
        return !some;
    }

    @Override
    public ItemType getItemType(TypeHierarchy th) {
        return BuiltInAtomicType.BOOLEAN;
    }

    @Override
    public String toString() {
        return String.valueOf(this.operator == 31 ? "some" : "every") + " $" + this.getVariableName() + " in " + this.sequence.toString() + " satisfies " + this.action.toString();
    }

    @Override
    public void explain(ExpressionPresenter out) {
        out.startElement(Token.tokens[this.operator]);
        out.emitAttribute("variable", this.getVariableName());
        out.startSubsidiaryElement("in");
        this.sequence.explain(out);
        out.endSubsidiaryElement();
        out.startSubsidiaryElement("satisfies");
        this.action.explain(out);
        out.endSubsidiaryElement();
        out.endElement();
    }
}

