/*
 * Decompiled with CFR 0.152.
 */
package net2.sf.saxon.expr;

import net2.sf.saxon.expr.Expression;
import net2.sf.saxon.expr.NumericPromoter;
import net2.sf.saxon.expr.XPathContext;
import net2.sf.saxon.trans.XPathException;
import net2.sf.saxon.type.BuiltInAtomicType;
import net2.sf.saxon.type.ItemType;
import net2.sf.saxon.type.TypeHierarchy;
import net2.sf.saxon.value.AtomicValue;
import net2.sf.saxon.value.DoubleValue;
import net2.sf.saxon.value.NumericValue;
import net2.sf.saxon.value.UntypedAtomicValue;

public class PromoteToFloat
extends NumericPromoter {
    public PromoteToFloat(Expression exp) {
        super(exp);
    }

    @Override
    public ItemType getItemType(TypeHierarchy th) {
        return BuiltInAtomicType.FLOAT;
    }

    @Override
    public Expression copy() {
        return new PromoteToFloat(this.getBaseExpression().copy());
    }

    @Override
    protected AtomicValue promote(AtomicValue value, XPathContext context) throws XPathException {
        if (!(value instanceof NumericValue) && !(value instanceof UntypedAtomicValue)) {
            TypeHierarchy th = context.getConfiguration().getTypeHierarchy();
            XPathException err = new XPathException("Cannot promote non-numeric value to " + this.getItemType(th).toString(), "XPTY0004", context);
            err.setLocator(this);
            throw err;
        }
        if (value instanceof DoubleValue) {
            XPathException err = new XPathException("Cannot promote from xs:double to xs:float", "XPTY0004", context);
            err.setLocator(this);
            throw err;
        }
        return value.convert(BuiltInAtomicType.FLOAT, true, context).asAtomic();
    }
}

