/*
 * Decompiled with CFR 0.152.
 */
package net2.sf.saxon.expr;

import net2.sf.saxon.expr.Expression;
import net2.sf.saxon.expr.NumericPromoter;
import net2.sf.saxon.expr.XPathContext;
import net2.sf.saxon.trans.XPathException;
import net2.sf.saxon.type.BuiltInAtomicType;
import net2.sf.saxon.type.ItemType;
import net2.sf.saxon.type.TypeHierarchy;
import net2.sf.saxon.value.AtomicValue;
import net2.sf.saxon.value.NumericValue;
import net2.sf.saxon.value.UntypedAtomicValue;

public class PromoteToDouble
extends NumericPromoter {
    public PromoteToDouble(Expression exp) {
        super(exp);
    }

    @Override
    public ItemType getItemType(TypeHierarchy th) {
        return BuiltInAtomicType.DOUBLE;
    }

    @Override
    public Expression copy() {
        return new PromoteToDouble(this.getBaseExpression().copy());
    }

    @Override
    protected AtomicValue promote(AtomicValue value, XPathContext context) throws XPathException {
        if (!(value instanceof NumericValue) && !(value instanceof UntypedAtomicValue)) {
            TypeHierarchy th = context.getConfiguration().getTypeHierarchy();
            XPathException err = new XPathException("Cannot promote non-numeric value to " + this.getItemType(th).toString(), "XPTY0004", context);
            err.setLocator(this);
            throw err;
        }
        return value.convert(BuiltInAtomicType.DOUBLE, true, context).asAtomic();
    }
}

