/*
 * Decompiled with CFR 0.152.
 */
package net2.sf.saxon.expr;

import java.util.Iterator;
import net2.sf.saxon.expr.Expression;
import net2.sf.saxon.expr.ExpressionVisitor;
import net2.sf.saxon.expr.XPathContext;
import net2.sf.saxon.om.Item;
import net2.sf.saxon.om.NodeInfo;
import net2.sf.saxon.pattern.Pattern;
import net2.sf.saxon.pattern.PatternSponsor;
import net2.sf.saxon.trace.ExpressionPresenter;
import net2.sf.saxon.trans.XPathException;
import net2.sf.saxon.type.BuiltInAtomicType;
import net2.sf.saxon.type.ItemType;
import net2.sf.saxon.type.TypeHierarchy;
import net2.sf.saxon.value.BooleanValue;

public class PatternMatchExpression
extends Expression {
    private Pattern pattern;

    public PatternMatchExpression(Pattern pattern) {
        this.pattern = pattern;
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    @Override
    protected int computeCardinality() {
        return 16384;
    }

    @Override
    public Expression typeCheck(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        return this;
    }

    @Override
    public Expression optimize(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        return this;
    }

    @Override
    public ItemType getItemType(TypeHierarchy th) {
        return BuiltInAtomicType.BOOLEAN;
    }

    @Override
    public void explain(ExpressionPresenter destination) {
        destination.startElement("patternMatch");
        destination.emitAttribute("match", this.pattern.toString());
        destination.endElement();
    }

    @Override
    public int getIntrinsicDependencies() {
        return 2;
    }

    @Override
    public Expression copy() {
        throw new UnsupportedOperationException("copy");
    }

    @Override
    public Iterator<Expression> iterateSubExpressions() {
        return new PatternSponsor(this.pattern).iterateSubExpressions();
    }

    @Override
    public Item evaluateItem(XPathContext context) throws XPathException {
        return BooleanValue.get(this.effectiveBooleanValue(context));
    }

    @Override
    public boolean effectiveBooleanValue(XPathContext context) throws XPathException {
        Item contextItem = context.getContextItem();
        return contextItem instanceof NodeInfo && this.pattern.matches((NodeInfo)contextItem, context);
    }
}

