/*
 * Decompiled with CFR 0.152.
 */
package net2.sf.saxon.expr;

import java.io.Serializable;
import java.util.Stack;
import net2.sf.saxon.expr.AxisExpression;
import net2.sf.saxon.expr.ContextItemExpression;
import net2.sf.saxon.expr.ContextMappingFunction;
import net2.sf.saxon.expr.ContextMappingIterator;
import net2.sf.saxon.expr.Expression;
import net2.sf.saxon.expr.ExpressionTool;
import net2.sf.saxon.expr.ExpressionVisitor;
import net2.sf.saxon.expr.FilterExpression;
import net2.sf.saxon.expr.Literal;
import net2.sf.saxon.expr.Optimizer;
import net2.sf.saxon.expr.PathMap;
import net2.sf.saxon.expr.PromotionOffer;
import net2.sf.saxon.expr.RoleLocator;
import net2.sf.saxon.expr.RootExpression;
import net2.sf.saxon.expr.SlashExpression;
import net2.sf.saxon.expr.StaticContext;
import net2.sf.saxon.expr.TypeChecker;
import net2.sf.saxon.expr.XPathContext;
import net2.sf.saxon.expr.XPathContextMinor;
import net2.sf.saxon.functions.SystemFunction;
import net2.sf.saxon.om.Axis;
import net2.sf.saxon.om.SequenceIterator;
import net2.sf.saxon.pattern.AnyNodeTest;
import net2.sf.saxon.pattern.NodeKindTest;
import net2.sf.saxon.pattern.NodeTest;
import net2.sf.saxon.sort.DocumentSorter;
import net2.sf.saxon.trace.ExpressionPresenter;
import net2.sf.saxon.trans.XPathException;
import net2.sf.saxon.type.ItemType;
import net2.sf.saxon.type.TypeHierarchy;
import net2.sf.saxon.value.Cardinality;
import net2.sf.saxon.value.EmptySequence;
import net2.sf.saxon.value.SequenceType;

public final class PathExpression
extends SlashExpression
implements ContextMappingFunction {
    private transient int state = 0;

    public PathExpression(Expression start, Expression step) {
        super(start, step);
        PathExpression stepPath;
        if (step instanceof PathExpression && PathExpression.isFilteredAxisPath((stepPath = (PathExpression)step).getControllingExpression()) && PathExpression.isFilteredAxisPath(stepPath.getControlledExpression())) {
            this.setStartExpression(new PathExpression(start, stepPath.start));
            this.setStepExpression(stepPath.step);
        }
    }

    @Override
    public boolean isHybrid() {
        return false;
    }

    Expression addDocumentSorter() {
        int props = this.getSpecialProperties();
        if ((props & 0x20000) != 0) {
            return this;
        }
        if ((props & 0x40000) != 0) {
            return SystemFunction.makeSystemFunction("reverse", new Expression[]{this});
        }
        return new DocumentSorter(this);
    }

    /*
     * Unable to fully structure code
     */
    private static boolean isFilteredAxisPath(Expression exp) {
        if (!(exp instanceof AxisExpression)) ** GOTO lbl4
        return true;
lbl-1000:
        // 1 sources

        {
            exp = ((FilterExpression)exp).getControllingExpression();
lbl4:
            // 2 sources

            ** while (exp instanceof FilterExpression)
        }
lbl5:
        // 1 sources

        return exp instanceof AxisExpression;
    }

    @Override
    public Expression simplify(ExpressionVisitor visitor) throws XPathException {
        if (this.state > 0) {
            return this;
        }
        this.state = 1;
        Expression e2 = super.simplify(visitor);
        if (e2 != this) {
            return e2;
        }
        if (this.start instanceof ContextItemExpression) {
            return this.step;
        }
        if (this.step instanceof ContextItemExpression) {
            return this.start;
        }
        return this;
    }

    private PathExpression simplifyDescendantPath(StaticContext env) {
        Expression st = this.start;
        if (this.start instanceof AxisExpression) {
            AxisExpression stax = (AxisExpression)this.start;
            if (stax.getAxis() != 5) {
                return null;
            }
            ContextItemExpression cie = new ContextItemExpression();
            ExpressionTool.copyLocationInfo(this, cie);
            st = new PathExpression(cie, stax);
            ExpressionTool.copyLocationInfo(this, st);
        }
        if (!(st instanceof PathExpression)) {
            return null;
        }
        PathExpression startPath = (PathExpression)st;
        if (!(startPath.step instanceof AxisExpression)) {
            return null;
        }
        AxisExpression mid = (AxisExpression)startPath.step;
        if (mid.getAxis() != 5) {
            return null;
        }
        NodeTest test = mid.getNodeTest();
        if (test != null && !(test instanceof AnyNodeTest)) {
            return null;
        }
        Expression underlyingStep = this.step;
        while (underlyingStep instanceof FilterExpression) {
            if (((FilterExpression)underlyingStep).isPositional(env.getConfiguration().getTypeHierarchy())) {
                return null;
            }
            underlyingStep = ((FilterExpression)underlyingStep).getControllingExpression();
        }
        if (!(underlyingStep instanceof AxisExpression)) {
            return null;
        }
        AxisExpression underlyingAxis = (AxisExpression)underlyingStep;
        if (underlyingAxis.getAxis() == 3) {
            Expression newStep = new AxisExpression(4, ((AxisExpression)underlyingStep).getNodeTest());
            ExpressionTool.copyLocationInfo(this, newStep);
            underlyingStep = this.step;
            Stack<Expression> filters = new Stack<Expression>();
            while (underlyingStep instanceof FilterExpression) {
                filters.add(((FilterExpression)underlyingStep).getFilter());
                underlyingStep = ((FilterExpression)underlyingStep).getControllingExpression();
            }
            while (!filters.isEmpty()) {
                newStep = new FilterExpression(newStep, (Expression)filters.pop());
                ExpressionTool.copyLocationInfo(this.step, newStep);
            }
            PathExpression newPath = new PathExpression(startPath.start, newStep);
            ExpressionTool.copyLocationInfo(this, newPath);
            return newPath;
        }
        if (underlyingAxis.getAxis() == 2) {
            AxisExpression newStep = new AxisExpression(5, NodeKindTest.ELEMENT);
            ExpressionTool.copyLocationInfo(this, newStep);
            PathExpression newPath = new PathExpression(new PathExpression(startPath.start, newStep), this.step);
            ExpressionTool.copyLocationInfo(this, newPath);
            return newPath;
        }
        return null;
    }

    @Override
    public Expression typeCheck(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        TypeHierarchy th = visitor.getConfiguration().getTypeHierarchy();
        if (this.state >= 2) {
            this.setStartExpression(visitor.typeCheck(this.start, contextItemType));
            this.setStepExpression(visitor.typeCheck(this.step, this.start.getItemType(th)));
            return this;
        }
        this.state = 2;
        this.setStartExpression(visitor.typeCheck(this.start, contextItemType));
        RoleLocator role0 = new RoleLocator(1, (Serializable)((Object)"/"), 0);
        role0.setErrorCode("XPTY0019");
        this.setStartExpression(TypeChecker.staticTypeCheck(this.start, SequenceType.NODE_SEQUENCE, false, role0, visitor));
        this.setStepExpression(visitor.typeCheck(this.step, this.start.getItemType(th)));
        if ((this.step.getSpecialProperties() & 0x400000) != 0) {
            Optimizer opt = visitor.getConfiguration().getOptimizer();
            this.setStartExpression(ExpressionTool.unsorted(opt, this.start, false));
            this.setStepExpression(ExpressionTool.unsorted(opt, this.step, false));
            PathExpression p = this.simplifyDescendantPath(visitor.getStaticContext());
            if (p != null) {
                ExpressionTool.copyLocationInfo(this, p);
                return visitor.typeCheck(visitor.simplify(p), contextItemType);
            }
            this.adoptChildExpression(this.start);
            this.adoptChildExpression(this.step);
        }
        return this;
    }

    @Override
    public Expression optimize(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        Optimizer opt = visitor.getConfiguration().getOptimizer();
        TypeHierarchy th = visitor.getConfiguration().getTypeHierarchy();
        if (this.state >= 3) {
            this.setStartExpression(visitor.optimize(this.start, contextItemType));
            this.setStepExpression(this.step.optimize(visitor, this.start.getItemType(th)));
            return this;
        }
        this.state = 3;
        Expression lastStep = this.getLastStep();
        if (lastStep instanceof FilterExpression && !((FilterExpression)lastStep).isPositional(th)) {
            Expression leading = this.getLeadingSteps();
            PathExpression p2 = new PathExpression(leading, ((FilterExpression)lastStep).getControllingExpression());
            FilterExpression f2 = new FilterExpression(p2, ((FilterExpression)lastStep).getFilter());
            return ((Expression)f2).optimize(visitor, contextItemType);
        }
        Expression k = opt.convertPathExpressionToKey(this, visitor);
        if (k != null) {
            return k.typeCheck(visitor, contextItemType).optimize(visitor, contextItemType);
        }
        this.setStartExpression(visitor.optimize(this.start, contextItemType));
        this.setStepExpression(this.step.optimize(visitor, this.start.getItemType(th)));
        if (Literal.isEmptySequence(this.start) || Literal.isEmptySequence(this.step)) {
            return new Literal(EmptySequence.getInstance());
        }
        return this.promoteFocusIndependentSubexpressions(visitor, contextItemType);
    }

    @Override
    public Expression promote(PromotionOffer offer, Expression parent) throws XPathException {
        Optimizer optimizer;
        FilterExpression p2;
        PathExpression p = this;
        if (offer.action == 11 && (p2 = (optimizer = offer.getOptimizer()).convertToFilterExpression(this, optimizer.getConfiguration().getTypeHierarchy())) != null) {
            return p2.promote(offer, parent);
        }
        Expression exp = offer.accept(parent, p);
        if (exp != null) {
            return exp;
        }
        this.setStartExpression(this.doPromotion(this, this.start, offer));
        if (offer.action == 12 || offer.action == 14) {
            this.setStepExpression(this.doPromotion(this, this.step, offer));
        }
        return this;
    }

    @Override
    public Expression copy() {
        return new PathExpression(this.start.copy(), this.step.copy());
    }

    @Override
    public int computeSpecialProperties() {
        int startProperties = this.start.getSpecialProperties();
        int stepProperties = this.step.getSpecialProperties();
        int p = 0;
        if (!Cardinality.allowsMany(this.start.getCardinality())) {
            startProperties |= 0x8A0000;
        }
        if (!Cardinality.allowsMany(this.step.getCardinality())) {
            stepProperties |= 0x8A0000;
        }
        if ((startProperties & stepProperties & 0x10000) != 0) {
            p |= 0x10000;
        }
        if ((startProperties & 0x800000) != 0 && (stepProperties & 0x10000) != 0) {
            p |= 0x800000;
        }
        if ((startProperties & stepProperties & 0x80000) != 0) {
            p |= 0x80000;
        }
        if ((startProperties & stepProperties & 0x100000) != 0) {
            p |= 0x100000;
        }
        if (this.testNaturallySorted(startProperties, stepProperties)) {
            p |= 0x20000;
        }
        if (this.testNaturallyReverseSorted()) {
            p |= 0x40000;
        }
        if ((startProperties & stepProperties & 0x400000) != 0) {
            p |= 0x400000;
        }
        return p;
    }

    private boolean testNaturallySorted(int startProperties, int stepProperties) {
        if ((stepProperties & 0x20000) == 0) {
            return false;
        }
        if (Cardinality.allowsMany(this.start.getCardinality())) {
            if ((startProperties & 0x20000) == 0) {
                return false;
            }
        } else {
            return true;
        }
        if ((stepProperties & 0x200000) != 0) {
            return true;
        }
        return (startProperties & 0x80000) != 0 && (stepProperties & 0x100000) != 0;
    }

    private boolean testNaturallyReverseSorted() {
        if (!Cardinality.allowsMany(this.start.getCardinality()) && this.step instanceof AxisExpression) {
            return !Axis.isForwards[((AxisExpression)this.step).getAxis()];
        }
        return !Cardinality.allowsMany(this.step.getCardinality()) && this.start instanceof AxisExpression && !Axis.isForwards[((AxisExpression)this.start).getAxis()];
    }

    @Override
    public Expression getRemainingSteps() {
        if (this.start instanceof PathExpression) {
            PathExpression rem = new PathExpression(((PathExpression)this.start).getRemainingSteps(), this.step);
            ExpressionTool.copyLocationInfo(this.start, rem);
            return rem;
        }
        return this.step;
    }

    public boolean isAbsolute(TypeHierarchy th) {
        Expression first = this.getFirstStep();
        return first.getItemType(th).getPrimitiveType() == 9;
    }

    public PathExpression tryToMakeAbsolute(TypeHierarchy th) {
        Expression first = this.getFirstStep();
        if (first.getItemType(th).getPrimitiveType() == 9) {
            return this;
        }
        if (first instanceof AxisExpression && ((AxisExpression)first).getContextItemType().getPrimitiveType() == 9) {
            RootExpression root = new RootExpression();
            ExpressionTool.copyLocationInfo(this, root);
            PathExpression path = new PathExpression(root, this);
            ExpressionTool.copyLocationInfo(this, path);
            return path;
        }
        return null;
    }

    @Override
    public PathMap.PathMapNodeSet addToPathMap(PathMap pathMap, PathMap.PathMapNodeSet pathMapNodeSet) {
        PathMap.PathMapNodeSet target = this.start.addToPathMap(pathMap, pathMapNodeSet);
        return this.step.addToPathMap(pathMap, target);
    }

    @Override
    public SequenceIterator iterate(XPathContext context) throws XPathException {
        SequenceIterator master = this.start.iterate(context);
        XPathContextMinor context2 = context.newMinorContext();
        context2.setCurrentIterator(master);
        context2.setOrigin(this);
        return new ContextMappingIterator(this, context2);
    }

    @Override
    public String toString() {
        return "(" + this.start.toString() + "/" + this.step.toString() + ")";
    }

    @Override
    public void explain(ExpressionPresenter destination) {
        destination.startElement("path");
        this.start.explain(destination);
        this.step.explain(destination);
        destination.endElement();
    }
}

