/*
 * Decompiled with CFR 0.152.
 */
package net2.sf.saxon.expr;

import net2.sf.saxon.expr.AxisExpression;
import net2.sf.saxon.expr.Expression;
import net2.sf.saxon.expr.PathMap;
import net2.sf.saxon.expr.SingleNodeExpression;
import net2.sf.saxon.expr.XPathContext;
import net2.sf.saxon.om.Item;
import net2.sf.saxon.om.NodeInfo;
import net2.sf.saxon.pattern.AnyNodeTest;
import net2.sf.saxon.trace.ExpressionPresenter;
import net2.sf.saxon.trans.XPathException;

public class ParentNodeExpression
extends SingleNodeExpression {
    @Override
    protected String noContextMessage() {
        return "Cannot select the parent of the context node";
    }

    @Override
    public NodeInfo getNode(XPathContext context) throws XPathException {
        Item item = context.getContextItem();
        if (item == null) {
            this.dynamicError("The context item is not set", "XPDY0002", context);
        }
        if (item instanceof NodeInfo) {
            return ((NodeInfo)item).getParent();
        }
        this.dynamicError("The context item for the parent axis (..) is not a node", "XPTY0020", context);
        return null;
    }

    @Override
    public Expression copy() {
        return new ParentNodeExpression();
    }

    @Override
    public PathMap.PathMapNodeSet addToPathMap(PathMap pathMap, PathMap.PathMapNodeSet pathMapNodeSet) {
        AxisExpression parent = new AxisExpression(9, AnyNodeTest.getInstance());
        parent.setContainer(this.getContainer());
        return parent.addToPathMap(pathMap, pathMapNodeSet);
    }

    public boolean equals(Object other) {
        return other instanceof ParentNodeExpression;
    }

    public int hashCode() {
        return "ParentNodeExpression".hashCode();
    }

    @Override
    public String toString() {
        return "..";
    }

    @Override
    public void explain(ExpressionPresenter destination) {
        destination.startElement("parent");
        destination.endElement();
    }
}

