/*
 * Decompiled with CFR 0.152.
 */
package net2.sf.saxon.expr;

import java.io.Serializable;
import java.util.Iterator;
import net2.sf.saxon.Configuration;
import net2.sf.saxon.expr.BinaryExpression;
import net2.sf.saxon.expr.Binding;
import net2.sf.saxon.expr.ContextSwitchingExpression;
import net2.sf.saxon.expr.Expression;
import net2.sf.saxon.expr.ExpressionTool;
import net2.sf.saxon.expr.ExpressionVisitor;
import net2.sf.saxon.expr.FilterExpression;
import net2.sf.saxon.expr.GeneralComparison;
import net2.sf.saxon.expr.GeneralComparison10;
import net2.sf.saxon.expr.PathExpression;
import net2.sf.saxon.expr.StaticContext;
import net2.sf.saxon.expr.UserFunctionCall;
import net2.sf.saxon.expr.XPathContext;
import net2.sf.saxon.instruct.ApplyTemplates;
import net2.sf.saxon.instruct.Choose;
import net2.sf.saxon.instruct.Template;
import net2.sf.saxon.om.SequenceIterator;
import net2.sf.saxon.om.ValueRepresentation;
import net2.sf.saxon.pattern.NodeTest;
import net2.sf.saxon.sort.DocumentSorter;
import net2.sf.saxon.trans.RuleTarget;
import net2.sf.saxon.trans.XPathException;
import net2.sf.saxon.type.ItemType;
import net2.sf.saxon.type.TypeHierarchy;
import net2.sf.saxon.value.Closure;
import net2.sf.saxon.value.MemoClosure;
import net2.sf.saxon.value.SequenceExtent;
import net2.sf.saxon.value.Value;

public class Optimizer
implements Serializable {
    public static final int NO_OPTIMIZATION = 0;
    public static final int FULL_OPTIMIZATION = 10;
    protected Configuration config;
    private int optimizationLevel = 10;

    public Optimizer(Configuration config) {
        this.config = config;
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    public void setOptimizationLevel(int level) {
        if (level < 0 || level > 10) {
            throw new IllegalArgumentException("Optimization level");
        }
        this.optimizationLevel = level;
    }

    public int getOptimizationLevel() {
        return this.optimizationLevel;
    }

    public BinaryExpression makeGeneralComparison(Expression p0, int op, Expression p1, boolean backwardsCompatible) {
        if (backwardsCompatible) {
            return new GeneralComparison10(p0, op, p1);
        }
        return new GeneralComparison(p0, op, p1);
    }

    public Expression optimizeCopy(Expression select) throws XPathException {
        TypeHierarchy th = this.config.getTypeHierarchy();
        if (select.getItemType(th).isAtomicType()) {
            return select;
        }
        return null;
    }

    public Value makeClosure(Expression expression, int ref, XPathContext context) throws XPathException {
        if (ref == 1) {
            return new Closure();
        }
        return new MemoClosure();
    }

    public ValueRepresentation makeSequenceExtent(Expression expression, int ref, XPathContext context) throws XPathException {
        return SequenceExtent.makeSequenceExtent(expression.iterate(context));
    }

    public Expression convertPathExpressionToKey(PathExpression pathExp, ExpressionVisitor visitor) throws XPathException {
        return null;
    }

    public Expression tryIndexedFilter(FilterExpression f, ExpressionVisitor visitor, boolean indexFirstOperand) {
        return f;
    }

    public FilterExpression convertToFilterExpression(PathExpression pathExp, TypeHierarchy th) throws XPathException {
        return null;
    }

    public int isIndexableFilter(Expression filter) {
        return 0;
    }

    public ValueRepresentation makeIndexedValue(SequenceIterator iter) throws XPathException {
        throw new UnsupportedOperationException("Indexing requires Saxon-EE");
    }

    public boolean isVariableReplaceableByDot(Expression exp, Binding[] binding) {
        if (exp instanceof ContextSwitchingExpression) {
            Expression start = ((ContextSwitchingExpression)((Object)exp)).getControllingExpression();
            Expression step = ((ContextSwitchingExpression)((Object)exp)).getControlledExpression();
            return this.isVariableReplaceableByDot(start, binding) && !ExpressionTool.dependsOnVariable(step, binding);
        }
        Iterator<Expression> iter = exp.iterateSubExpressions();
        while (iter.hasNext()) {
            Expression sub = iter.next();
            if (this.isVariableReplaceableByDot(sub, binding)) continue;
            return false;
        }
        return true;
    }

    public Expression makeConditionalDocumentSorter(DocumentSorter sorter, PathExpression path) {
        return sorter;
    }

    public Expression tryInlineFunctionCall(UserFunctionCall functionCall, ExpressionVisitor visitor, ItemType contextItemType) {
        return functionCall;
    }

    public Expression promoteExpressionsToGlobal(Expression body, ExpressionVisitor visitor, boolean notTopLevel) throws XPathException {
        return body;
    }

    public Expression trySwitch(Choose choose, StaticContext env) {
        return choose;
    }

    public Expression extractGlobalVariables(Expression body, ExpressionVisitor visitor) throws XPathException {
        return null;
    }

    public Expression makeStreamingApplyTemplates(ApplyTemplates inst) throws XPathException {
        return inst;
    }

    public RuleTarget makeInversion(Template template, NodeTest nodeTest) throws XPathException {
        return null;
    }

    public void trace(String message, Expression exp) {
        if (this.getConfiguration().isOptimizerTracing()) {
            System.err.println("OPT ======================================");
            System.err.println("OPT : At line " + exp.getLineNumber() + " of " + exp.getSystemId());
            System.err.println("OPT : " + message);
            System.err.println("OPT ====== Expression after rewrite ======");
            exp.explain(System.err);
            System.err.println("\nOPT ======================================");
        }
    }

    public void trace(String message) {
        if (this.getConfiguration().isOptimizerTracing()) {
            System.err.println("OPT ======================================");
            System.err.println("OPT : " + message);
            System.err.println("OPT ======================================");
        }
    }
}

