/*
 * Decompiled with CFR 0.152.
 */
package net2.sf.saxon.expr;

import java.io.Serializable;
import net2.sf.saxon.Configuration;
import net2.sf.saxon.expr.Expression;
import net2.sf.saxon.expr.ExpressionVisitor;
import net2.sf.saxon.expr.RoleLocator;
import net2.sf.saxon.expr.TypeChecker;
import net2.sf.saxon.expr.UnaryExpression;
import net2.sf.saxon.expr.XPathContext;
import net2.sf.saxon.om.Item;
import net2.sf.saxon.trans.XPathException;
import net2.sf.saxon.type.ItemType;
import net2.sf.saxon.type.TypeHierarchy;
import net2.sf.saxon.value.DoubleValue;
import net2.sf.saxon.value.NumericValue;
import net2.sf.saxon.value.SequenceType;

public class NegateExpression
extends UnaryExpression {
    private boolean backwardsCompatible;

    public NegateExpression(Expression base) {
        super(base);
    }

    public void setBackwardsCompatible(boolean compatible) {
        this.backwardsCompatible = compatible;
    }

    @Override
    public Expression typeCheck(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        Expression oldop = this.operand;
        RoleLocator role = new RoleLocator(9, (Serializable)((Object)"-"), 0);
        this.operand = TypeChecker.staticTypeCheck(this.operand, SequenceType.OPTIONAL_NUMERIC, this.backwardsCompatible, role, visitor);
        this.operand = visitor.typeCheck(this.operand, contextItemType);
        if (this.operand != oldop) {
            this.adoptChildExpression(this.operand);
        }
        return this;
    }

    @Override
    public ItemType getItemType(TypeHierarchy th) {
        return this.operand.getItemType(th);
    }

    @Override
    public Item evaluateItem(XPathContext context) throws XPathException {
        NumericValue v1 = (NumericValue)this.operand.evaluateItem(context);
        if (v1 == null) {
            return this.backwardsCompatible ? DoubleValue.NaN : null;
        }
        return v1.negate();
    }

    @Override
    public Expression copy() {
        return new NegateExpression(this.getBaseExpression().copy());
    }

    @Override
    protected String displayOperator(Configuration config) {
        return "-";
    }
}

