/*
 * Decompiled with CFR 0.152.
 */
package net2.sf.saxon.expr;

import net2.sf.saxon.expr.MappingFunction;
import net2.sf.saxon.expr.StatefulMappingFunction;
import net2.sf.saxon.om.Item;
import net2.sf.saxon.om.SequenceIterator;
import net2.sf.saxon.trans.XPathException;

public final class MappingIterator
implements SequenceIterator {
    private SequenceIterator base;
    private MappingFunction action;
    private SequenceIterator results = null;
    private Item current = null;
    private int position = 0;

    public MappingIterator(SequenceIterator base, MappingFunction action) {
        this.base = base;
        this.action = action;
    }

    @Override
    public Item next() throws XPathException {
        Item nextItem;
        block3: {
            while (true) {
                Item nextSource;
                if (this.results != null) {
                    nextItem = this.results.next();
                    if (nextItem != null) break block3;
                    this.results = null;
                }
                if ((nextSource = this.base.next()) == null) break;
                SequenceIterator obj = this.action.map(nextSource);
                if (obj == null) continue;
                this.results = obj;
                nextItem = this.results.next();
                if (nextItem == null) {
                    this.results = null;
                    continue;
                }
                break block3;
                break;
            }
            this.results = null;
            this.current = null;
            this.position = -1;
            return null;
        }
        this.current = nextItem;
        ++this.position;
        return nextItem;
    }

    @Override
    public Item current() {
        return this.current;
    }

    @Override
    public int position() {
        return this.position;
    }

    @Override
    public void close() {
        if (this.results != null) {
            this.results.close();
        }
        this.base.close();
    }

    @Override
    public SequenceIterator getAnother() throws XPathException {
        SequenceIterator newBase = this.base.getAnother();
        MappingFunction newAction = this.action instanceof StatefulMappingFunction ? ((StatefulMappingFunction)this.action).getAnother() : this.action;
        return new MappingIterator(newBase, newAction);
    }

    @Override
    public int getProperties() {
        return 0;
    }
}

