/*
 * Decompiled with CFR 0.152.
 */
package net2.sf.saxon.expr;

import net2.sf.saxon.expr.Binding;
import net2.sf.saxon.expr.Expression;
import net2.sf.saxon.expr.ExpressionTool;
import net2.sf.saxon.expr.VariableReference;
import net2.sf.saxon.expr.XPathContext;
import net2.sf.saxon.om.ValueRepresentation;
import net2.sf.saxon.trans.XPathException;

public class LocalVariableReference
extends VariableReference {
    int slotNumber = -999;

    public LocalVariableReference() {
    }

    public LocalVariableReference(Binding binding) {
        super(binding);
    }

    @Override
    public Expression copy() {
        if (this.binding == null) {
            throw new UnsupportedOperationException("Cannot copy a variable reference whose binding is unknown");
        }
        LocalVariableReference ref = new LocalVariableReference();
        ref.binding = this.binding;
        ref.staticType = this.staticType;
        ref.slotNumber = this.slotNumber;
        ref.constantValue = this.constantValue;
        ref.displayName = this.displayName;
        ExpressionTool.copyLocationInfo(this, ref);
        return ref;
    }

    public void setSlotNumber(int slotNumber) {
        this.slotNumber = slotNumber;
    }

    public int getSlotNumber() {
        return this.slotNumber;
    }

    @Override
    public ValueRepresentation evaluateVariable(XPathContext c) throws XPathException {
        try {
            return c.getStackFrame().slots[this.slotNumber];
        }
        catch (ArrayIndexOutOfBoundsException err) {
            if (this.slotNumber == -999) {
                throw new ArrayIndexOutOfBoundsException("Local variable has not been allocated a stack frame slot");
            }
            throw err;
        }
    }
}

