/*
 * Decompiled with CFR 0.152.
 */
package net2.sf.saxon.expr;

import net2.sf.saxon.expr.Expression;
import net2.sf.saxon.expr.ExpressionVisitor;
import net2.sf.saxon.expr.Literal;
import net2.sf.saxon.expr.UnaryExpression;
import net2.sf.saxon.expr.XPathContext;
import net2.sf.saxon.om.Item;
import net2.sf.saxon.om.SequenceIterator;
import net2.sf.saxon.trans.XPathException;
import net2.sf.saxon.type.ItemType;

public class LazyExpression
extends UnaryExpression {
    public LazyExpression(Expression operand) {
        super(operand);
    }

    public static Expression makeLazyExpression(Expression operand) {
        if (operand instanceof LazyExpression || operand instanceof Literal || (operand.getDependencies() & 0xC) != 0) {
            return operand;
        }
        return new LazyExpression(operand);
    }

    @Override
    public Expression typeCheck(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        this.operand = visitor.typeCheck(this.operand, contextItemType);
        return this;
    }

    @Override
    public Expression optimize(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        this.operand = visitor.optimize(this.operand, contextItemType);
        return this;
    }

    @Override
    public Item evaluateItem(XPathContext context) throws XPathException {
        return this.operand.evaluateItem(context);
    }

    @Override
    public SequenceIterator iterate(XPathContext context) throws XPathException {
        return this.operand.iterate(context);
    }

    @Override
    public void process(XPathContext context) throws XPathException {
        this.operand.process(context);
    }

    @Override
    public Expression copy() {
        return new LazyExpression(this.getBaseExpression().copy());
    }

    @Override
    protected String displayExpressionName() {
        return "lazy";
    }
}

