/*
 * Decompiled with CFR 0.152.
 */
package net2.sf.saxon.expr;

import net2.sf.saxon.expr.Expression;
import net2.sf.saxon.expr.ExpressionVisitor;
import net2.sf.saxon.expr.FirstItemExpression;
import net2.sf.saxon.expr.PromotionOffer;
import net2.sf.saxon.expr.ReversibleIterator;
import net2.sf.saxon.expr.UnaryExpression;
import net2.sf.saxon.expr.XPathContext;
import net2.sf.saxon.om.Item;
import net2.sf.saxon.om.SequenceIterator;
import net2.sf.saxon.trans.XPathException;
import net2.sf.saxon.type.ItemType;

public final class LastItemExpression
extends UnaryExpression {
    public LastItemExpression(Expression base) {
        super(base);
        this.computeStaticProperties();
    }

    @Override
    public Expression optimize(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        this.operand = visitor.optimize(this.operand, contextItemType);
        if (this.operand instanceof LastItemExpression || this.operand instanceof FirstItemExpression) {
            return this.operand;
        }
        return super.optimize(visitor, contextItemType);
    }

    @Override
    public Expression promote(PromotionOffer offer, Expression parent) throws XPathException {
        Expression exp = offer.accept(parent, this);
        if (exp != null) {
            return exp;
        }
        if (offer.action != 13) {
            this.operand = this.doPromotion(this, this.operand, offer);
        }
        return this;
    }

    @Override
    public int computeCardinality() {
        return this.operand.getCardinality() & 0xFFFF7FFF;
    }

    @Override
    public Expression copy() {
        return new LastItemExpression(this.getBaseExpression().copy());
    }

    @Override
    public Item evaluateItem(XPathContext context) throws XPathException {
        SequenceIterator forwards = this.operand.iterate(context);
        if (forwards instanceof ReversibleIterator) {
            return ((ReversibleIterator)forwards).getReverseIterator().next();
        }
        Item current = null;
        Item item;
        while ((item = forwards.next()) != null) {
            current = item;
        }
        return current;
    }

    @Override
    public String displayExpressionName() {
        return "lastItem";
    }
}

