/*
 * Decompiled with CFR 0.152.
 */
package net2.sf.saxon.expr;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import net2.sf.saxon.Configuration;
import net2.sf.saxon.Controller;
import net2.sf.saxon.event.ParseOptions;
import net2.sf.saxon.expr.CodeGeneratorService;
import net2.sf.saxon.expr.XPathContext;
import net2.sf.saxon.om.ExternalObjectModel;
import net2.sf.saxon.om.Item;
import net2.sf.saxon.om.NodeInfo;
import net2.sf.saxon.om.SequenceIterator;
import net2.sf.saxon.om.ValueRepresentation;
import net2.sf.saxon.pattern.AnyNodeTest;
import net2.sf.saxon.trans.XPathException;
import net2.sf.saxon.type.AnyItemType;
import net2.sf.saxon.type.BuiltInAtomicType;
import net2.sf.saxon.type.ExternalObjectType;
import net2.sf.saxon.type.ItemType;
import net2.sf.saxon.value.AnyURIValue;
import net2.sf.saxon.value.BooleanValue;
import net2.sf.saxon.value.Closure;
import net2.sf.saxon.value.DateTimeValue;
import net2.sf.saxon.value.DecimalValue;
import net2.sf.saxon.value.DoubleValue;
import net2.sf.saxon.value.FloatValue;
import net2.sf.saxon.value.Int64Value;
import net2.sf.saxon.value.IntegerValue;
import net2.sf.saxon.value.ObjectValue;
import net2.sf.saxon.value.QNameValue;
import net2.sf.saxon.value.SequenceExtent;
import net2.sf.saxon.value.StringValue;
import net2.sf.saxon.value.Value;

public abstract class JPConverter
implements Serializable {
    private static HashMap<Class, JPConverter> map = new HashMap();

    static {
        map.put(SequenceIterator.class, new FromSequenceIterator());
        map.put(ValueRepresentation.class, FromValueRepresentation.INSTANCE);
        map.put(String.class, FromString.INSTANCE);
        map.put(Boolean.class, FromBoolean.INSTANCE);
        map.put(Boolean.TYPE, FromBoolean.INSTANCE);
        map.put(Double.class, FromDouble.INSTANCE);
        map.put(Double.TYPE, FromDouble.INSTANCE);
        map.put(Float.class, FromFloat.INSTANCE);
        map.put(Float.TYPE, FromFloat.INSTANCE);
        map.put(BigDecimal.class, FromBigDecimal.INSTANCE);
        map.put(BigInteger.class, FromBigInteger.INSTANCE);
        map.put(Long.class, FromLong.INSTANCE);
        map.put(Long.TYPE, FromLong.INSTANCE);
        map.put(Integer.class, FromInt.INSTANCE);
        map.put(Integer.TYPE, FromInt.INSTANCE);
        map.put(Short.class, FromShort.INSTANCE);
        map.put(Short.TYPE, FromShort.INSTANCE);
        map.put(Byte.class, FromByte.INSTANCE);
        map.put(Byte.TYPE, FromByte.INSTANCE);
        map.put(Character.class, FromCharacter.INSTANCE);
        map.put(Character.TYPE, FromCharacter.INSTANCE);
        map.put(URI.class, FromURI.INSTANCE);
        map.put(URL.class, FromURI.INSTANCE);
        map.put(Date.class, FromDate.INSTANCE);
        map.put(long[].class, FromLongArray.INSTANCE);
        map.put(int[].class, FromIntArray.INSTANCE);
        map.put(short[].class, FromShortArray.INSTANCE);
        map.put(byte[].class, FromByteArray.INSTANCE);
        map.put(char[].class, FromCharArray.INSTANCE);
        map.put(double[].class, FromDoubleArray.INSTANCE);
        map.put(float[].class, FromFloatArray.INSTANCE);
        map.put(boolean[].class, FromBooleanArray.INSTANCE);
        map.put(Collection.class, FromCollection.INSTANCE);
    }

    public static JPConverter allocate(Class javaClass, Configuration config) {
        JPConverter c = map.get(javaClass);
        if (c != null) {
            return c;
        }
        if (javaClass.getName().equals("javax.xml.namespace.QName")) {
            return FromQName.INSTANCE;
        }
        if (NodeInfo.class.isAssignableFrom(javaClass)) {
            return new FromValueRepresentation(AnyNodeTest.getInstance(), 24576);
        }
        if (Source.class.isAssignableFrom(javaClass) && !DOMSource.class.isAssignableFrom(javaClass)) {
            return FromSource.INSTANCE;
        }
        for (Class k : map.keySet()) {
            if (!k.isAssignableFrom(javaClass)) continue;
            return map.get(k);
        }
        List<ExternalObjectModel> externalObjectModels = config.getExternalObjectModels();
        int m = 0;
        while (m < externalObjectModels.size()) {
            ExternalObjectModel model = externalObjectModels.get(m);
            JPConverter converter = model.getJPConverter(javaClass);
            if (converter != null) {
                return converter;
            }
            ++m;
        }
        if (javaClass.isArray()) {
            Class<?> itemClass = javaClass.getComponentType();
            return new FromObjectArray(JPConverter.allocate(itemClass, config));
        }
        return new WrapExternalObject(new ExternalObjectType(javaClass, config));
    }

    public abstract ValueRepresentation convert(Object var1, XPathContext var2) throws XPathException;

    public abstract ItemType getItemType();

    public int getCardinality() {
        return 16384;
    }

    public String compile(String var, CodeGeneratorService compiler) {
        throw new UnsupportedOperationException("Cannot compile converter " + this.getClass().getName());
    }

    public static class FromBigDecimal
    extends JPConverter {
        public static FromBigDecimal INSTANCE = new FromBigDecimal();

        @Override
        public ValueRepresentation convert(Object object, XPathContext context) throws XPathException {
            return new DecimalValue((BigDecimal)object);
        }

        @Override
        public ItemType getItemType() {
            return BuiltInAtomicType.DECIMAL;
        }

        @Override
        public String compile(String var, CodeGeneratorService compiler) {
            return "new DecimalValue(" + var + ")";
        }
    }

    public static class FromBigInteger
    extends JPConverter {
        public static FromBigInteger INSTANCE = new FromBigInteger();

        @Override
        public ValueRepresentation convert(Object object, XPathContext context) throws XPathException {
            return IntegerValue.makeIntegerValue((BigInteger)object);
        }

        @Override
        public ItemType getItemType() {
            return BuiltInAtomicType.INTEGER;
        }

        @Override
        public String compile(String var, CodeGeneratorService compiler) {
            return "IntegerValue.makeIntegerValue(" + var + ")";
        }
    }

    public static class FromBoolean
    extends JPConverter {
        public static FromBoolean INSTANCE = new FromBoolean();

        @Override
        public ValueRepresentation convert(Object object, XPathContext context) throws XPathException {
            return BooleanValue.get((Boolean)object);
        }

        @Override
        public ItemType getItemType() {
            return BuiltInAtomicType.BOOLEAN;
        }

        @Override
        public String compile(String var, CodeGeneratorService compiler) {
            return "BooleanValue.get(" + var + ")";
        }
    }

    public static class FromBooleanArray
    extends JPConverter {
        public static FromBooleanArray INSTANCE = new FromBooleanArray();

        @Override
        public ValueRepresentation convert(Object object, XPathContext context) throws XPathException {
            Item[] array = new Item[((boolean[])object).length];
            int i = 0;
            while (i < array.length) {
                array[i] = BooleanValue.get(((boolean[])object)[i]);
                ++i;
            }
            return new SequenceExtent(array);
        }

        @Override
        public ItemType getItemType() {
            return BuiltInAtomicType.BOOLEAN;
        }

        @Override
        public int getCardinality() {
            return 57344;
        }

        @Override
        public String compile(String var, CodeGeneratorService compiler) {
            return "JPConverter.FromBooleanArray.INSTANCE.convert(" + var + ", " + compiler.getContextVariableName() + ")";
        }
    }

    public static class FromByte
    extends JPConverter {
        public static FromByte INSTANCE = new FromByte();

        @Override
        public ValueRepresentation convert(Object object, XPathContext context) throws XPathException {
            return new Int64Value(((Byte)object).intValue());
        }

        @Override
        public ItemType getItemType() {
            return BuiltInAtomicType.INTEGER;
        }

        @Override
        public String compile(String var, CodeGeneratorService compiler) {
            return "new Int64Value(" + var + ")";
        }
    }

    public static class FromByteArray
    extends JPConverter {
        public static FromByteArray INSTANCE = new FromByteArray();

        @Override
        public ValueRepresentation convert(Object object, XPathContext context) throws XPathException {
            Item[] array = new Item[((byte[])object).length];
            int i = 0;
            while (i < array.length) {
                array[i] = Int64Value.makeDerived(0xFF & ((byte[])object)[i], BuiltInAtomicType.BYTE);
                ++i;
            }
            return new SequenceExtent(array);
        }

        @Override
        public ItemType getItemType() {
            return BuiltInAtomicType.BYTE;
        }

        @Override
        public int getCardinality() {
            return 57344;
        }

        @Override
        public String compile(String var, CodeGeneratorService compiler) {
            return "JPConverter.FromByteArray.INSTANCE.convert(" + var + ", " + compiler.getContextVariableName() + ")";
        }
    }

    public static class FromCharArray
    extends JPConverter {
        public static FromCharArray INSTANCE = new FromCharArray();

        @Override
        public ValueRepresentation convert(Object object, XPathContext context) throws XPathException {
            return StringValue.makeStringValue(new String((char[])object));
        }

        @Override
        public ItemType getItemType() {
            return BuiltInAtomicType.STRING;
        }

        @Override
        public String compile(String var, CodeGeneratorService compiler) {
            return "StringValue.makeStringValue(new String((char[])" + var + "))";
        }
    }

    public static class FromCharacter
    extends JPConverter {
        public static FromCharacter INSTANCE = new FromCharacter();

        @Override
        public ValueRepresentation convert(Object object, XPathContext context) throws XPathException {
            return new StringValue(object.toString());
        }

        @Override
        public ItemType getItemType() {
            return BuiltInAtomicType.STRING;
        }

        @Override
        public String compile(String var, CodeGeneratorService compiler) {
            return "new StringValue(" + var + ".toString())";
        }
    }

    public static class FromCollection
    extends JPConverter {
        public static FromCollection INSTANCE = new FromCollection();

        @Override
        public ValueRepresentation convert(Object object, XPathContext context) throws XPathException {
            Item[] array = new Item[((Collection)object).size()];
            int a = 0;
            for (Object obj : (Collection)object) {
                JPConverter itemConverter = FromCollection.allocate(obj.getClass(), context.getConfiguration());
                try {
                    Item item = Value.asItem(itemConverter.convert(obj, context));
                    if (item == null) continue;
                    array[a++] = item;
                }
                catch (XPathException e) {
                    throw new XPathException("Returned Collection contains an object that cannot be converted to an Item (" + obj.getClass() + "): " + e.getMessage(), "SXJE0051");
                }
            }
            return new SequenceExtent(array, 0, a);
        }

        @Override
        public ItemType getItemType() {
            return AnyItemType.getInstance();
        }

        @Override
        public int getCardinality() {
            return 57344;
        }

        @Override
        public String compile(String var, CodeGeneratorService compiler) {
            return "JPConverter.FromCollection.INSTANCE.convert(" + var + ", " + compiler.getContextVariableName() + ")";
        }
    }

    public static class FromDate
    extends JPConverter {
        public static FromDate INSTANCE = new FromDate();

        @Override
        public ValueRepresentation convert(Object object, XPathContext context) throws XPathException {
            return DateTimeValue.fromJavaDate((Date)object);
        }

        @Override
        public ItemType getItemType() {
            return BuiltInAtomicType.DATE_TIME;
        }

        @Override
        public String compile(String var, CodeGeneratorService compiler) {
            return "DateTimeValue.fromJavaDate(" + var + ")";
        }
    }

    public static class FromDouble
    extends JPConverter {
        public static FromDouble INSTANCE = new FromDouble();

        @Override
        public ValueRepresentation convert(Object object, XPathContext context) throws XPathException {
            return new DoubleValue((Double)object);
        }

        @Override
        public ItemType getItemType() {
            return BuiltInAtomicType.DOUBLE;
        }

        @Override
        public String compile(String var, CodeGeneratorService compiler) {
            return "new DoubleValue(" + var + ")";
        }
    }

    public static class FromDoubleArray
    extends JPConverter {
        public static FromDoubleArray INSTANCE = new FromDoubleArray();

        @Override
        public ValueRepresentation convert(Object object, XPathContext context) throws XPathException {
            Item[] array = new Item[((double[])object).length];
            int i = 0;
            while (i < array.length) {
                array[i] = new DoubleValue(((double[])object)[i]);
                ++i;
            }
            return new SequenceExtent(array);
        }

        @Override
        public ItemType getItemType() {
            return BuiltInAtomicType.DOUBLE;
        }

        @Override
        public int getCardinality() {
            return 57344;
        }

        @Override
        public String compile(String var, CodeGeneratorService compiler) {
            return "JPConverter.FromDoubleArray.INSTANCE.convert(" + var + ", " + compiler.getContextVariableName() + ")";
        }
    }

    public static class FromFloat
    extends JPConverter {
        public static FromFloat INSTANCE = new FromFloat();

        @Override
        public ValueRepresentation convert(Object object, XPathContext context) throws XPathException {
            return new FloatValue(((Float)object).floatValue());
        }

        @Override
        public ItemType getItemType() {
            return BuiltInAtomicType.FLOAT;
        }

        @Override
        public String compile(String var, CodeGeneratorService compiler) {
            return "new FloatValue(" + var + ")";
        }
    }

    public static class FromFloatArray
    extends JPConverter {
        public static FromFloatArray INSTANCE = new FromFloatArray();

        @Override
        public ValueRepresentation convert(Object object, XPathContext context) throws XPathException {
            Item[] array = new Item[((float[])object).length];
            int i = 0;
            while (i < array.length) {
                array[i] = new DoubleValue(((float[])object)[i]);
                ++i;
            }
            return new SequenceExtent(array);
        }

        @Override
        public ItemType getItemType() {
            return BuiltInAtomicType.FLOAT;
        }

        @Override
        public int getCardinality() {
            return 57344;
        }

        @Override
        public String compile(String var, CodeGeneratorService compiler) {
            return "JPConverter.FromFloatArray.INSTANCE.convert(" + var + ", " + compiler.getContextVariableName() + ")";
        }
    }

    public static class FromInt
    extends JPConverter {
        public static FromInt INSTANCE = new FromInt();

        @Override
        public ValueRepresentation convert(Object object, XPathContext context) throws XPathException {
            return new Int64Value(((Integer)object).intValue());
        }

        @Override
        public ItemType getItemType() {
            return BuiltInAtomicType.INTEGER;
        }

        @Override
        public String compile(String var, CodeGeneratorService compiler) {
            return "new Int64Value(" + var + ")";
        }
    }

    public static class FromIntArray
    extends JPConverter {
        public static FromIntArray INSTANCE = new FromIntArray();

        @Override
        public ValueRepresentation convert(Object object, XPathContext context) throws XPathException {
            Item[] array = new Item[((int[])object).length];
            int i = 0;
            while (i < array.length) {
                array[i] = Int64Value.makeDerived(((int[])object)[i], BuiltInAtomicType.INT);
                ++i;
            }
            return new SequenceExtent(array);
        }

        @Override
        public ItemType getItemType() {
            return BuiltInAtomicType.INT;
        }

        @Override
        public int getCardinality() {
            return 57344;
        }

        @Override
        public String compile(String var, CodeGeneratorService compiler) {
            return "JPConverter.FromIntArray.INSTANCE.convert(" + var + ", " + compiler.getContextVariableName() + ")";
        }
    }

    public static class FromLong
    extends JPConverter {
        public static FromLong INSTANCE = new FromLong();

        @Override
        public ValueRepresentation convert(Object object, XPathContext context) throws XPathException {
            return new Int64Value((Long)object);
        }

        @Override
        public ItemType getItemType() {
            return BuiltInAtomicType.INTEGER;
        }

        @Override
        public String compile(String var, CodeGeneratorService compiler) {
            return "new Int64Value(" + var + ")";
        }
    }

    public static class FromLongArray
    extends JPConverter {
        public static FromLongArray INSTANCE = new FromLongArray();

        @Override
        public ValueRepresentation convert(Object object, XPathContext context) throws XPathException {
            Item[] array = new Item[((long[])object).length];
            int i = 0;
            while (i < array.length) {
                array[i] = Int64Value.makeDerived(((long[])object)[i], BuiltInAtomicType.LONG);
                ++i;
            }
            return new SequenceExtent(array);
        }

        @Override
        public ItemType getItemType() {
            return BuiltInAtomicType.LONG;
        }

        @Override
        public int getCardinality() {
            return 57344;
        }

        @Override
        public String compile(String var, CodeGeneratorService compiler) {
            return "JPConverter.FromLongArray.INSTANCE.convert(" + var + ", " + compiler.getContextVariableName() + ")";
        }
    }

    public static class FromObjectArray
    extends JPConverter {
        private JPConverter itemConverter;

        public FromObjectArray(JPConverter itemConverter) {
            this.itemConverter = itemConverter;
        }

        @Override
        public ValueRepresentation convert(Object object, XPathContext context) throws XPathException {
            Object[] arrayObject = (Object[])object;
            Item[] newArray = new Item[arrayObject.length];
            int a = 0;
            int i = 0;
            while (i < arrayObject.length) {
                try {
                    Item newItem = Value.asItem(this.itemConverter.convert(arrayObject[i], context));
                    if (newItem != null) {
                        newArray[a++] = newItem;
                    }
                }
                catch (XPathException e) {
                    throw new XPathException("Returned array contains an object that cannot be converted to an Item (" + arrayObject[i].getClass() + "): " + e.getMessage(), "SXJE0051");
                }
                ++i;
            }
            return new SequenceExtent(newArray, 0, a);
        }

        @Override
        public ItemType getItemType() {
            return this.itemConverter.getItemType();
        }

        @Override
        public int getCardinality() {
            return 57344;
        }

        @Override
        public String compile(String var, CodeGeneratorService compiler) {
            return "JPConverter.FromObjectArray.INSTANCE.convert(" + var + ", " + compiler.getContextVariableName() + ")";
        }
    }

    public static class FromQName
    extends JPConverter {
        public static FromQName INSTANCE = new FromQName();

        @Override
        public ValueRepresentation convert(Object object, XPathContext context) throws XPathException {
            QName qn = (QName)object;
            return new QNameValue(qn.getPrefix(), qn.getNamespaceURI(), qn.getLocalPart());
        }

        @Override
        public ItemType getItemType() {
            return BuiltInAtomicType.QNAME;
        }

        @Override
        public String compile(String var, CodeGeneratorService compiler) {
            return "new QNameValue(" + var + ".getPrefix(), " + var + ".getNamespaceURI(), " + var + ".getLocalPart())";
        }
    }

    public static class FromSequenceIterator
    extends JPConverter {
        public static FromSequenceIterator INSTANCE = new FromSequenceIterator();

        @Override
        public ValueRepresentation convert(Object object, XPathContext context) throws XPathException {
            return SequenceExtent.makeSequenceExtent((SequenceIterator)object);
        }

        @Override
        public ItemType getItemType() {
            return AnyItemType.getInstance();
        }

        @Override
        public int getCardinality() {
            return 57344;
        }
    }

    public static class FromShort
    extends JPConverter {
        public static FromShort INSTANCE = new FromShort();

        @Override
        public ValueRepresentation convert(Object object, XPathContext context) throws XPathException {
            return new Int64Value(((Short)object).intValue());
        }

        @Override
        public ItemType getItemType() {
            return BuiltInAtomicType.INTEGER;
        }

        @Override
        public String compile(String var, CodeGeneratorService compiler) {
            return "new Int64Value(" + var + ")";
        }
    }

    public static class FromShortArray
    extends JPConverter {
        public static FromShortArray INSTANCE = new FromShortArray();

        @Override
        public ValueRepresentation convert(Object object, XPathContext context) throws XPathException {
            Item[] array = new Item[((short[])object).length];
            int i = 0;
            while (i < array.length) {
                array[i] = Int64Value.makeDerived(((short[])object)[i], BuiltInAtomicType.SHORT);
                ++i;
            }
            return new SequenceExtent(array);
        }

        @Override
        public ItemType getItemType() {
            return BuiltInAtomicType.SHORT;
        }

        @Override
        public int getCardinality() {
            return 57344;
        }

        @Override
        public String compile(String var, CodeGeneratorService compiler) {
            return "JPConverter.FromShortArray.INSTANCE.convert(" + var + ", " + compiler.getContextVariableName() + ")";
        }
    }

    public static class FromSource
    extends JPConverter {
        public static FromSource INSTANCE = new FromSource();

        @Override
        public ValueRepresentation convert(Object object, XPathContext context) throws XPathException {
            ParseOptions options = new ParseOptions();
            Controller controller = context.getController();
            if (controller != null) {
                options.setSchemaValidationMode(controller.getSchemaValidationMode());
            }
            return context.getConfiguration().buildDocument((Source)object, options);
        }

        @Override
        public ItemType getItemType() {
            return AnyNodeTest.getInstance();
        }

        @Override
        public String compile(String var, CodeGeneratorService compiler) {
            return String.valueOf(compiler.getContextVariableName()) + ".getConfiguration().buildDocument(" + var + ")";
        }
    }

    public static class FromString
    extends JPConverter {
        public static FromString INSTANCE = new FromString();

        @Override
        public ValueRepresentation convert(Object object, XPathContext context) throws XPathException {
            return new StringValue((String)object);
        }

        @Override
        public ItemType getItemType() {
            return BuiltInAtomicType.STRING;
        }

        @Override
        public String compile(String var, CodeGeneratorService compiler) {
            return "new StringValue(" + var + ")";
        }
    }

    public static class FromURI
    extends JPConverter {
        public static FromURI INSTANCE = new FromURI();

        @Override
        public ValueRepresentation convert(Object object, XPathContext context) throws XPathException {
            return new AnyURIValue(object.toString());
        }

        @Override
        public ItemType getItemType() {
            return BuiltInAtomicType.ANY_URI;
        }

        @Override
        public String compile(String var, CodeGeneratorService compiler) {
            return "new AnyURIValue(" + var + ".toString())";
        }
    }

    public static class FromValueRepresentation
    extends JPConverter {
        public static FromValueRepresentation INSTANCE = new FromValueRepresentation(AnyItemType.getInstance(), 57344);
        private ItemType resultType;
        private int cardinality;

        public FromValueRepresentation(ItemType resultType, int cardinality) {
            this.resultType = resultType;
            this.cardinality = cardinality;
        }

        @Override
        public ValueRepresentation convert(Object object, XPathContext context) throws XPathException {
            return object instanceof Closure ? Value.asValue(SequenceExtent.makeSequenceExtent(((Closure)object).iterate())) : (ValueRepresentation)object;
        }

        @Override
        public ItemType getItemType() {
            return this.resultType;
        }

        @Override
        public int getCardinality() {
            return this.cardinality;
        }

        @Override
        public String compile(String var, CodeGeneratorService compiler) {
            return var;
        }
    }

    public static class WrapExternalObject
    extends JPConverter {
        public static WrapExternalObject INSTANCE = new WrapExternalObject(BuiltInAtomicType.ANY_ATOMIC);
        private ItemType resultType;

        public WrapExternalObject(ItemType resultType) {
            this.resultType = resultType;
        }

        @Override
        public ValueRepresentation convert(Object object, XPathContext context) throws XPathException {
            return new ObjectValue(object);
        }

        @Override
        public ItemType getItemType() {
            return this.resultType;
        }

        @Override
        public String compile(String var, CodeGeneratorService compiler) {
            return "new ObjectValue(" + var + ")";
        }
    }
}

