/*
 * Decompiled with CFR 0.152.
 */
package net2.sf.saxon.expr;

import net2.sf.saxon.event.SequenceReceiver;
import net2.sf.saxon.event.TypeCheckingFilter;
import net2.sf.saxon.expr.CardinalityChecker;
import net2.sf.saxon.expr.Expression;
import net2.sf.saxon.expr.ExpressionVisitor;
import net2.sf.saxon.expr.ItemMappingFunction;
import net2.sf.saxon.expr.ItemMappingIterator;
import net2.sf.saxon.expr.MappingExpression;
import net2.sf.saxon.expr.RoleLocator;
import net2.sf.saxon.expr.UnaryExpression;
import net2.sf.saxon.expr.XPathContext;
import net2.sf.saxon.om.Item;
import net2.sf.saxon.om.NamePool;
import net2.sf.saxon.om.SequenceIterator;
import net2.sf.saxon.pattern.CombinedNodeTest;
import net2.sf.saxon.pattern.DocumentNodeTest;
import net2.sf.saxon.pattern.NodeTest;
import net2.sf.saxon.trace.ExpressionPresenter;
import net2.sf.saxon.trans.XPathException;
import net2.sf.saxon.type.AnyItemType;
import net2.sf.saxon.type.BuiltInAtomicType;
import net2.sf.saxon.type.ItemType;
import net2.sf.saxon.type.Type;
import net2.sf.saxon.type.TypeHierarchy;
import net2.sf.saxon.value.Cardinality;
import net2.sf.saxon.value.Value;

public final class ItemChecker
extends UnaryExpression
implements MappingExpression {
    private ItemType requiredItemType;
    private RoleLocator role;

    public ItemChecker(Expression sequence, ItemType itemType, RoleLocator role) {
        super(sequence);
        this.requiredItemType = itemType;
        this.role = role;
        this.adoptChildExpression(sequence);
    }

    public ItemType getRequiredType() {
        return this.requiredItemType;
    }

    public RoleLocator getRoleLocator() {
        return this.role;
    }

    @Override
    public Expression simplify(ExpressionVisitor visitor) throws XPathException {
        this.operand = visitor.simplify(this.operand);
        if (this.requiredItemType instanceof AnyItemType) {
            return this.operand;
        }
        return this;
    }

    @Override
    public Expression typeCheck(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        this.operand = visitor.typeCheck(this.operand, contextItemType);
        TypeHierarchy th = visitor.getConfiguration().getTypeHierarchy();
        int card = this.operand.getCardinality();
        if (card == 8192) {
            return this.operand;
        }
        ItemType supplied = this.operand.getItemType(th);
        int relation = th.relationship(this.requiredItemType, supplied);
        if (relation == 0 || relation == 1) {
            return this.operand;
        }
        if (relation == 4) {
            NamePool namePool = visitor.getConfiguration().getNamePool();
            if (Cardinality.allowsZero(card)) {
                String message = this.role.composeErrorMessage(this.requiredItemType, this.operand.getItemType(th), namePool);
                visitor.getStaticContext().issueWarning("The only value that can pass type-checking is an empty sequence. " + message, this);
            } else {
                if (this.requiredItemType.equals(BuiltInAtomicType.STRING) && th.isSubType(supplied, BuiltInAtomicType.ANY_URI)) {
                    return this.operand;
                }
                String message = this.role.composeErrorMessage(this.requiredItemType, this.operand.getItemType(th), namePool);
                XPathException err = new XPathException(message);
                err.setErrorCode(this.role.getErrorCode());
                err.setLocator(this);
                err.setIsTypeError(true);
                throw err;
            }
        }
        return this;
    }

    @Override
    public int getImplementationMethod() {
        int m = 6;
        if (!Cardinality.allowsMany(this.getCardinality())) {
            m |= 1;
        }
        return m;
    }

    @Override
    public SequenceIterator iterate(XPathContext context) throws XPathException {
        SequenceIterator base = this.operand.iterate(context);
        return this.getMappingIterator(base, context);
    }

    @Override
    public SequenceIterator getMappingIterator(SequenceIterator base, XPathContext context) throws XPathException {
        ItemCheckMappingFunction map = new ItemCheckMappingFunction();
        map.externalContext = context;
        return new ItemMappingIterator(base, map, true);
    }

    @Override
    public Item evaluateItem(XPathContext context) throws XPathException {
        Item item = this.operand.evaluateItem(context);
        if (item == null) {
            return null;
        }
        this.testConformance(item, context);
        return item;
    }

    @Override
    public void process(XPathContext context) throws XPathException {
        Expression next = this.operand;
        int card = 57344;
        if (next instanceof CardinalityChecker) {
            card = ((CardinalityChecker)next).getRequiredCardinality();
            next = ((CardinalityChecker)next).getBaseExpression();
        }
        if ((next.getImplementationMethod() & 4) != 0 && !(this.requiredItemType instanceof DocumentNodeTest)) {
            SequenceReceiver out = context.getReceiver();
            TypeCheckingFilter filter = new TypeCheckingFilter();
            filter.setUnderlyingReceiver(out);
            filter.setPipelineConfiguration(out.getPipelineConfiguration());
            filter.setRequiredType(this.requiredItemType, card, this.role, this);
            context.setReceiver(filter);
            next.process(context);
            filter.close();
            context.setReceiver(out);
        } else {
            super.process(context);
        }
    }

    @Override
    public Expression copy() {
        return new ItemChecker(this.getBaseExpression().copy(), this.requiredItemType, this.role);
    }

    private void testConformance(Item item, XPathContext context) throws XPathException {
        if (!this.requiredItemType.matchesItem(item, true, context == null ? null : context.getConfiguration())) {
            String message;
            if (context == null) {
                message = "Supplied value of type " + Type.displayTypeName(item) + " does not match the required type of " + this.role.getMessage();
            } else {
                NamePool pool = context.getNamePool();
                TypeHierarchy th = context.getConfiguration().getTypeHierarchy();
                message = this.role.composeErrorMessage(this.requiredItemType, Value.asValue(item).getItemType(th), pool);
            }
            String errorCode = this.role.getErrorCode();
            if ("XPDY0050".equals(errorCode)) {
                this.dynamicError(message, errorCode, context);
            } else {
                this.typeError(message, errorCode, context);
            }
        }
    }

    @Override
    public ItemType getItemType(TypeHierarchy th) {
        ItemType operandType = this.operand.getItemType(th);
        int relationship = th.relationship(this.requiredItemType, operandType);
        switch (relationship) {
            case 3: {
                if (this.requiredItemType instanceof NodeTest && operandType instanceof NodeTest) {
                    return new CombinedNodeTest((NodeTest)this.requiredItemType, 23, (NodeTest)operandType);
                }
                return this.requiredItemType;
            }
            case 0: 
            case 1: {
                return operandType;
            }
        }
        return this.requiredItemType;
    }

    @Override
    public boolean equals(Object other) {
        return super.equals(other) && this.requiredItemType == ((ItemChecker)other).requiredItemType;
    }

    @Override
    public void explain(ExpressionPresenter out) {
        out.startElement("treat");
        out.emitAttribute("as", this.requiredItemType.toString(out.getConfiguration().getNamePool()));
        this.operand.explain(out);
        out.endElement();
    }

    private class ItemCheckMappingFunction
    implements ItemMappingFunction {
        public XPathContext externalContext;

        private ItemCheckMappingFunction() {
        }

        @Override
        public Item map(Item item) throws XPathException {
            ItemChecker.this.testConformance(item, this.externalContext);
            return item;
        }
    }
}

