/*
 * Decompiled with CFR 0.152.
 */
package net2.sf.saxon.expr;

import net2.sf.saxon.expr.Expression;
import net2.sf.saxon.expr.ExpressionVisitor;
import net2.sf.saxon.expr.XPathContext;
import net2.sf.saxon.om.Item;
import net2.sf.saxon.trace.ExpressionPresenter;
import net2.sf.saxon.trans.XPathException;
import net2.sf.saxon.type.BuiltInAtomicType;
import net2.sf.saxon.type.ItemType;
import net2.sf.saxon.type.TypeHierarchy;
import net2.sf.saxon.value.BooleanValue;

public final class IsLastExpression
extends Expression {
    private boolean condition;

    public IsLastExpression(boolean condition) {
        this.condition = condition;
    }

    public boolean getCondition() {
        return this.condition;
    }

    @Override
    public Expression typeCheck(ExpressionVisitor visitor, ItemType contextItemType) {
        return this;
    }

    @Override
    public Expression optimize(ExpressionVisitor visitor, ItemType contextItemType) {
        return this;
    }

    @Override
    public int computeSpecialProperties() {
        int p = super.computeSpecialProperties();
        return p | 0x400000;
    }

    @Override
    public Item evaluateItem(XPathContext c) throws XPathException {
        return BooleanValue.get(this.condition == c.isAtLast());
    }

    @Override
    public ItemType getItemType(TypeHierarchy th) {
        return BuiltInAtomicType.BOOLEAN;
    }

    @Override
    public int computeCardinality() {
        return 16384;
    }

    @Override
    public int getIntrinsicDependencies() {
        return 12;
    }

    @Override
    public Expression copy() {
        return new IsLastExpression(this.condition);
    }

    @Override
    public void explain(ExpressionPresenter destination) {
        destination.startElement("isLast");
        destination.emitAttribute("condition", this.condition ? "true" : "false");
        destination.endElement();
    }
}

