/*
 * Decompiled with CFR 0.152.
 */
package net2.sf.saxon.expr;

import net2.sf.saxon.expr.Expression;
import net2.sf.saxon.expr.ExpressionTool;
import net2.sf.saxon.expr.ExpressionVisitor;
import net2.sf.saxon.expr.Literal;
import net2.sf.saxon.expr.MappingExpression;
import net2.sf.saxon.expr.UnaryExpression;
import net2.sf.saxon.expr.XPathContext;
import net2.sf.saxon.om.Item;
import net2.sf.saxon.om.SequenceIterator;
import net2.sf.saxon.om.SingletonIterator;
import net2.sf.saxon.trace.ExpressionPresenter;
import net2.sf.saxon.trans.XPathException;
import net2.sf.saxon.type.BuiltInAtomicType;
import net2.sf.saxon.type.ItemType;
import net2.sf.saxon.type.TypeHierarchy;
import net2.sf.saxon.value.AtomicValue;
import net2.sf.saxon.value.BooleanValue;
import net2.sf.saxon.value.Cardinality;
import net2.sf.saxon.value.SequenceType;

public final class InstanceOfExpression
extends UnaryExpression
implements MappingExpression {
    ItemType targetType;
    int targetCardinality;

    public InstanceOfExpression(Expression source, SequenceType target) {
        super(source);
        this.targetType = target.getPrimaryType();
        if (this.targetType == null) {
            throw new IllegalArgumentException("Primary item type must not be null");
        }
        this.targetCardinality = target.getCardinality();
    }

    public ItemType getRequiredItemType() {
        return this.targetType;
    }

    public int getRequiredCardinality() {
        return this.targetCardinality;
    }

    @Override
    public Expression typeCheck(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        this.operand = visitor.typeCheck(this.operand, contextItemType);
        if (this.operand instanceof Literal) {
            Literal lit = Literal.makeLiteral((AtomicValue)this.evaluateItem(visitor.getStaticContext().makeEarlyEvaluationContext()));
            ExpressionTool.copyLocationInfo(this, lit);
            return lit;
        }
        if (Cardinality.subsumes(this.targetCardinality, this.operand.getCardinality())) {
            TypeHierarchy th = visitor.getConfiguration().getTypeHierarchy();
            int relation = th.relationship(this.operand.getItemType(th), this.targetType);
            if (relation == 0 || relation == 2) {
                Literal lit = Literal.makeLiteral(BooleanValue.TRUE);
                ExpressionTool.copyLocationInfo(this, lit);
                return lit;
            }
            if (!(relation != 4 || Cardinality.allowsZero(this.targetCardinality) && Cardinality.allowsZero(this.operand.getCardinality()))) {
                Literal lit = Literal.makeLiteral(BooleanValue.FALSE);
                ExpressionTool.copyLocationInfo(this, lit);
                return lit;
            }
        }
        return this;
    }

    @Override
    public Expression optimize(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        Expression e = super.optimize(visitor, contextItemType);
        if (e != this) {
            return e;
        }
        if (Cardinality.subsumes(this.targetCardinality, this.operand.getCardinality())) {
            TypeHierarchy th = visitor.getConfiguration().getTypeHierarchy();
            int relation = th.relationship(this.operand.getItemType(th), this.targetType);
            if (relation == 0 || relation == 2) {
                return Literal.makeLiteral(BooleanValue.TRUE);
            }
            if (!(relation != 4 || Cardinality.allowsZero(this.targetCardinality) && Cardinality.allowsZero(this.operand.getCardinality()))) {
                return Literal.makeLiteral(BooleanValue.FALSE);
            }
        }
        return this;
    }

    @Override
    public boolean equals(Object other) {
        return super.equals(other) && this.targetType == ((InstanceOfExpression)other).targetType && this.targetCardinality == ((InstanceOfExpression)other).targetCardinality;
    }

    @Override
    public int computeCardinality() {
        return 16384;
    }

    @Override
    public Expression copy() {
        return new InstanceOfExpression(this.getBaseExpression().copy(), SequenceType.makeSequenceType(this.targetType, this.targetCardinality));
    }

    @Override
    public ItemType getItemType(TypeHierarchy th) {
        return BuiltInAtomicType.BOOLEAN;
    }

    @Override
    public Item evaluateItem(XPathContext context) throws XPathException {
        return BooleanValue.get(this.effectiveBooleanValue(context));
    }

    @Override
    public boolean effectiveBooleanValue(XPathContext context) throws XPathException {
        SequenceIterator iter = this.operand.iterate(context);
        return this.isInstance(iter, context);
    }

    private boolean isInstance(SequenceIterator iter, XPathContext context) throws XPathException {
        Item item;
        int count = 0;
        while ((item = iter.next()) != null) {
            ++count;
            if (!this.targetType.matchesItem(item, false, context.getConfiguration())) {
                return false;
            }
            if (count != 2 || Cardinality.allowsMany(this.targetCardinality)) continue;
            return false;
        }
        return count != 0 || (this.targetCardinality & 0x2000) != 0;
    }

    @Override
    public SequenceIterator getMappingIterator(SequenceIterator base, XPathContext context) throws XPathException {
        boolean b = this.isInstance(base, context);
        return SingletonIterator.makeIterator(BooleanValue.get(b));
    }

    @Override
    public void explain(ExpressionPresenter destination) {
        destination.startElement("instance");
        destination.emitAttribute("of", this.targetType.toString(destination.getNamePool()));
        destination.emitAttribute("occurs", Cardinality.getOccurrenceIndicator(this.targetCardinality));
        this.operand.explain(destination);
        destination.endElement();
    }
}

