/*
 * Decompiled with CFR 0.152.
 */
package net2.sf.saxon.expr;

import java.io.Serializable;
import net2.sf.saxon.expr.BinaryExpression;
import net2.sf.saxon.expr.Expression;
import net2.sf.saxon.expr.ExpressionVisitor;
import net2.sf.saxon.expr.Literal;
import net2.sf.saxon.expr.RoleLocator;
import net2.sf.saxon.expr.Token;
import net2.sf.saxon.expr.TypeChecker;
import net2.sf.saxon.expr.XPathContext;
import net2.sf.saxon.om.Item;
import net2.sf.saxon.om.NodeInfo;
import net2.sf.saxon.sort.GlobalOrderComparer;
import net2.sf.saxon.trans.XPathException;
import net2.sf.saxon.type.BuiltInAtomicType;
import net2.sf.saxon.type.ItemType;
import net2.sf.saxon.type.TypeHierarchy;
import net2.sf.saxon.value.BooleanValue;
import net2.sf.saxon.value.SequenceType;

public final class IdentityComparison
extends BinaryExpression {
    private boolean generateIdEmulation = false;

    public IdentityComparison(Expression p1, int op, Expression p2) {
        super(p1, op, p2);
    }

    public void setGenerateIdEmulation(boolean flag) {
        this.generateIdEmulation = flag;
    }

    public boolean isGenerateIdEmulation() {
        return this.generateIdEmulation;
    }

    @Override
    public Expression typeCheck(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        this.operand0 = visitor.typeCheck(this.operand0, contextItemType);
        this.operand1 = visitor.typeCheck(this.operand1, contextItemType);
        if (!this.generateIdEmulation && (Literal.isEmptySequence(this.operand0) || Literal.isEmptySequence(this.operand1))) {
            return Literal.makeEmptySequence();
        }
        RoleLocator role0 = new RoleLocator(1, (Serializable)((Object)Token.tokens[this.operator]), 0);
        this.operand0 = TypeChecker.staticTypeCheck(this.operand0, SequenceType.OPTIONAL_NODE, false, role0, visitor);
        RoleLocator role1 = new RoleLocator(1, (Serializable)((Object)Token.tokens[this.operator]), 1);
        this.operand1 = TypeChecker.staticTypeCheck(this.operand1, SequenceType.OPTIONAL_NODE, false, role1, visitor);
        return this;
    }

    @Override
    public Expression optimize(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        Expression r = super.optimize(visitor, contextItemType);
        if (r != this && !this.generateIdEmulation && (Literal.isEmptySequence(this.operand0) || Literal.isEmptySequence(this.operand1))) {
            return Literal.makeEmptySequence();
        }
        return r;
    }

    @Override
    public Expression copy() {
        return new IdentityComparison(this.operand0.copy(), this.operator, this.operand1.copy());
    }

    @Override
    public Item evaluateItem(XPathContext context) throws XPathException {
        NodeInfo node1 = this.getNode(this.operand0, context);
        if (node1 == null) {
            if (this.generateIdEmulation) {
                return BooleanValue.get(this.getNode(this.operand1, context) == null);
            }
            return null;
        }
        NodeInfo node2 = this.getNode(this.operand1, context);
        if (node2 == null) {
            if (this.generateIdEmulation) {
                return BooleanValue.FALSE;
            }
            return null;
        }
        return BooleanValue.get(this.compareIdentity(node1, node2));
    }

    @Override
    public boolean effectiveBooleanValue(XPathContext context) throws XPathException {
        NodeInfo node1 = this.getNode(this.operand0, context);
        if (node1 == null) {
            return this.generateIdEmulation && this.getNode(this.operand1, context) == null;
        }
        NodeInfo node2 = this.getNode(this.operand1, context);
        return node2 != null && this.compareIdentity(node1, node2);
    }

    private boolean compareIdentity(NodeInfo node1, NodeInfo node2) {
        switch (this.operator) {
            case 20: {
                return node1.isSameNodeInfo(node2);
            }
            case 37: {
                return GlobalOrderComparer.getInstance().compare(node1, node2) < 0;
            }
            case 38: {
                return GlobalOrderComparer.getInstance().compare(node1, node2) > 0;
            }
        }
        throw new UnsupportedOperationException("Unknown node identity test");
    }

    private NodeInfo getNode(Expression exp, XPathContext c) throws XPathException {
        return (NodeInfo)exp.evaluateItem(c);
    }

    @Override
    public ItemType getItemType(TypeHierarchy th) {
        return BuiltInAtomicType.BOOLEAN;
    }
}

