/*
 * Decompiled with CFR 0.152.
 */
package net2.sf.saxon.expr;

import java.util.ArrayList;
import net2.sf.saxon.expr.Atomizer;
import net2.sf.saxon.expr.BinaryExpression;
import net2.sf.saxon.expr.Expression;
import net2.sf.saxon.expr.ExpressionTool;
import net2.sf.saxon.expr.ExpressionVisitor;
import net2.sf.saxon.expr.ItemMappingIterator;
import net2.sf.saxon.expr.Literal;
import net2.sf.saxon.expr.Optimizer;
import net2.sf.saxon.expr.StaticContext;
import net2.sf.saxon.expr.ValueComparison;
import net2.sf.saxon.expr.XPathContext;
import net2.sf.saxon.functions.NumberFn;
import net2.sf.saxon.om.Item;
import net2.sf.saxon.sort.AtomicComparer;
import net2.sf.saxon.sort.CodepointCollator;
import net2.sf.saxon.sort.GenericAtomicComparer;
import net2.sf.saxon.sort.StringCollator;
import net2.sf.saxon.trace.ExpressionPresenter;
import net2.sf.saxon.trans.XPathException;
import net2.sf.saxon.type.BuiltInAtomicType;
import net2.sf.saxon.type.ItemType;
import net2.sf.saxon.type.TypeHierarchy;
import net2.sf.saxon.value.AtomicValue;
import net2.sf.saxon.value.BooleanValue;
import net2.sf.saxon.value.DoubleValue;
import net2.sf.saxon.value.StringValue;

public class GeneralComparison10
extends BinaryExpression {
    protected int singletonOperator;
    protected AtomicComparer comparer;
    private boolean atomize0 = true;
    private boolean atomize1 = true;
    private boolean maybeBoolean0 = true;
    private boolean maybeBoolean1 = true;

    public GeneralComparison10(Expression p0, int op, Expression p1) {
        super(p0, op, p1);
        this.singletonOperator = GeneralComparison10.getSingletonOperator(op);
    }

    @Override
    public int computeCardinality() {
        return 16384;
    }

    @Override
    public Expression typeCheck(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        this.operand0 = visitor.typeCheck(this.operand0, contextItemType);
        this.operand1 = visitor.typeCheck(this.operand1, contextItemType);
        StaticContext env = visitor.getStaticContext();
        StringCollator comp = env.getCollation(env.getDefaultCollationName());
        if (comp == null) {
            comp = CodepointCollator.getInstance();
        }
        XPathContext context = env.makeEarlyEvaluationContext();
        this.comparer = new GenericAtomicComparer(comp, context);
        if (this.operand0 instanceof Literal && this.operand1 instanceof Literal) {
            return Literal.makeLiteral((AtomicValue)this.evaluateItem(context));
        }
        return this;
    }

    @Override
    public Expression optimize(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        Optimizer opt = visitor.getConfiguration().getOptimizer();
        StaticContext env = visitor.getStaticContext();
        this.operand0 = visitor.optimize(this.operand0, contextItemType);
        this.operand1 = visitor.optimize(this.operand1, contextItemType);
        this.operand0 = ExpressionTool.unsorted(opt, this.operand0, false);
        this.operand1 = ExpressionTool.unsorted(opt, this.operand1, false);
        if (this.operand0 instanceof Literal && this.operand1 instanceof Literal) {
            return Literal.makeLiteral((AtomicValue)this.evaluateItem(env.makeEarlyEvaluationContext()));
        }
        TypeHierarchy th = env.getConfiguration().getTypeHierarchy();
        ItemType type0 = this.operand0.getItemType(th);
        ItemType type1 = this.operand1.getItemType(th);
        if (type0.isAtomicType()) {
            this.atomize0 = false;
        }
        if (type1.isAtomicType()) {
            this.atomize1 = false;
        }
        if (th.relationship(type0, BuiltInAtomicType.BOOLEAN) == 4) {
            this.maybeBoolean0 = false;
        }
        if (th.relationship(type1, BuiltInAtomicType.BOOLEAN) == 4) {
            this.maybeBoolean1 = false;
        }
        if (!this.maybeBoolean0 && !this.maybeBoolean1) {
            boolean numeric1;
            int n0 = th.relationship(type0, BuiltInAtomicType.NUMERIC);
            int n1 = th.relationship(type1, BuiltInAtomicType.NUMERIC);
            boolean maybeNumeric0 = n0 != 4;
            boolean maybeNumeric1 = n1 != 4;
            boolean numeric0 = n0 == 2 || n0 == 0;
            boolean bl = numeric1 = n1 == 2 || n1 == 0;
            if (this.operator == 6 || this.operator == 22) {
                if (!maybeNumeric0 && !maybeNumeric1 || numeric0 && numeric1) {
                    BinaryExpression gc = opt.makeGeneralComparison(this.operand0, this.operator, this.operand1, false);
                    ExpressionTool.copyLocationInfo(this, gc);
                    return visitor.optimize(visitor.typeCheck(gc, contextItemType), contextItemType);
                }
            } else if (numeric0 && numeric1) {
                BinaryExpression gc = opt.makeGeneralComparison(this.operand0, this.operator, this.operand1, false);
                ExpressionTool.copyLocationInfo(this, gc);
                return visitor.optimize(visitor.typeCheck(gc, contextItemType), contextItemType);
            }
        }
        return this;
    }

    @Override
    public Item evaluateItem(XPathContext context) throws XPathException {
        return BooleanValue.get(this.effectiveBooleanValue(context));
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public boolean effectiveBooleanValue(XPathContext context) throws XPathException {
        iter0 = null;
        if (this.maybeBoolean0) {
            iter0 = this.operand0.iterate(context);
            i01 = iter0.next();
            v0 = i02 = i01 == null ? null : iter0.next();
            if (i01 instanceof BooleanValue && i02 == null) {
                b = this.operand1.effectiveBooleanValue(context);
                return GeneralComparison10.compare((BooleanValue)i01, this.singletonOperator, BooleanValue.get(b), this.comparer, context);
            }
            if (i01 == null && !this.maybeBoolean1) {
                return false;
            }
        }
        iter1 = null;
        if (this.maybeBoolean1) {
            iter1 = this.operand1.iterate(context);
            i11 = iter1.next();
            v1 = i12 = i11 == null ? null : iter1.next();
            if (i11 instanceof BooleanValue && i12 == null) {
                b = this.operand0.effectiveBooleanValue(context);
                return GeneralComparison10.compare(BooleanValue.get(b), this.singletonOperator, (BooleanValue)i11, this.comparer, context);
            }
            if (i11 == null && !this.maybeBoolean0) {
                return false;
            }
        }
        iter0 = iter0 == null ? this.operand0.iterate(context) : iter0.getAnother();
        iter1 = iter1 == null ? this.operand1.iterate(context) : iter1.getAnother();
        if (this.atomize0) {
            iter0 = Atomizer.getAtomizingIterator(iter0);
        }
        if (this.atomize1) {
            iter1 = Atomizer.getAtomizingIterator(iter1);
        }
        if (this.operator == 12 || this.operator == 14 || this.operator == 11 || this.operator == 13) {
            iter0 = new ItemMappingIterator(iter0, new NumberFn(), true);
            iter1 = new ItemMappingIterator(iter1, new NumberFn(), true);
        }
        seq1 = null;
        block3: while (true) {
            if ((item0 = (AtomicValue)iter0.next()) == null) {
                return false;
            }
            if (iter1 != null) {
                while (true) {
                    if ((item1 = (AtomicValue)iter1.next()) == null) {
                        iter1 = null;
                        if (seq1 != null) continue block3;
                        return false;
                    }
                    if (!GeneralComparison10.compare(item0, this.singletonOperator, item1, this.comparer, context)) ** break block19
                    return true;
                    break;
                }
                catch (XPathException e) {
                    e.maybeSetLocation(this);
                    e.maybeSetContext(context);
                    throw e;
                }
                {
                    if (seq1 == null) {
                        seq1 = new ArrayList<AtomicValue>(40);
                    }
                    seq1.add(item1);
                    continue;
                }
            }
            listIter1 = seq1.iterator();
            do {
                if (listIter1.hasNext()) ** break;
                continue block3;
            } while (!GeneralComparison10.compare(item0, this.singletonOperator, item1 = (AtomicValue)listIter1.next(), this.comparer, context));
            break;
        }
        return true;
    }

    @Override
    public Expression copy() {
        GeneralComparison10 gc = new GeneralComparison10(this.operand0.copy(), this.operator, this.operand1.copy());
        gc.comparer = this.comparer;
        gc.atomize0 = this.atomize0;
        gc.atomize1 = this.atomize1;
        gc.maybeBoolean0 = this.maybeBoolean0;
        gc.maybeBoolean1 = this.maybeBoolean1;
        return gc;
    }

    private static boolean compare(AtomicValue a0, int operator, AtomicValue a1, AtomicComparer comparer, XPathContext context) throws XPathException {
        comparer = comparer.provideContext(context);
        BuiltInAtomicType t0 = a0.getPrimitiveType();
        BuiltInAtomicType t1 = a1.getPrimitiveType();
        if (t0.isPrimitiveNumeric() || t1.isPrimitiveNumeric()) {
            DoubleValue v0 = NumberFn.convert(a0);
            DoubleValue v1 = NumberFn.convert(a1);
            return ValueComparison.compare(v0, operator, v1, comparer, false);
        }
        if (t0.equals(BuiltInAtomicType.STRING) || t1.equals(BuiltInAtomicType.STRING) || t0.equals(BuiltInAtomicType.UNTYPED_ATOMIC) && t1.equals(BuiltInAtomicType.UNTYPED_ATOMIC)) {
            StringValue s0 = (StringValue)a0.convert(BuiltInAtomicType.STRING, true, context).asAtomic();
            StringValue s1 = (StringValue)a1.convert(BuiltInAtomicType.STRING, true, context).asAtomic();
            return ValueComparison.compare(s0, operator, s1, comparer, false);
        }
        if (t0.equals(BuiltInAtomicType.UNTYPED_ATOMIC)) {
            a0 = a0.convert(t1, true, context).asAtomic();
        }
        if (t1.equals(BuiltInAtomicType.UNTYPED_ATOMIC)) {
            a1 = a1.convert(t0, true, context).asAtomic();
        }
        return ValueComparison.compare(a0, operator, a1, comparer, false);
    }

    @Override
    public ItemType getItemType(TypeHierarchy th) {
        return BuiltInAtomicType.BOOLEAN;
    }

    private static int getSingletonOperator(int op) {
        switch (op) {
            case 6: {
                return 50;
            }
            case 13: {
                return 54;
            }
            case 22: {
                return 51;
            }
            case 12: {
                return 53;
            }
            case 11: {
                return 52;
            }
            case 14: {
                return 55;
            }
        }
        return op;
    }

    @Override
    protected void explainExtraAttributes(ExpressionPresenter out) {
        out.emitAttribute("cardinality", "many-to-many (1.0)");
    }
}

