/*
 * Decompiled with CFR 0.152.
 */
package net2.sf.saxon.expr;

import net2.sf.saxon.expr.Expression;
import net2.sf.saxon.expr.ExpressionVisitor;
import net2.sf.saxon.expr.PromotionOffer;
import net2.sf.saxon.expr.UnaryExpression;
import net2.sf.saxon.expr.XPathContext;
import net2.sf.saxon.om.Item;
import net2.sf.saxon.om.SequenceIterator;
import net2.sf.saxon.trans.XPathException;
import net2.sf.saxon.type.ItemType;
import net2.sf.saxon.value.Cardinality;

public final class FirstItemExpression
extends UnaryExpression {
    public FirstItemExpression(Expression base) {
        super(base);
        this.computeStaticProperties();
    }

    @Override
    public Expression optimize(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        this.operand = visitor.optimize(this.operand, contextItemType);
        if (!Cardinality.allowsMany(this.operand.getCardinality())) {
            return this.operand;
        }
        return super.optimize(visitor, contextItemType);
    }

    @Override
    public Expression promote(PromotionOffer offer, Expression parent) throws XPathException {
        Expression exp = offer.accept(parent, this);
        if (exp != null) {
            return exp;
        }
        if (offer.action != 13) {
            this.operand = this.doPromotion(this, this.operand, offer);
        }
        return this;
    }

    @Override
    public int computeCardinality() {
        return this.operand.getCardinality() & 0xFFFF7FFF;
    }

    @Override
    public Expression copy() {
        return new FirstItemExpression(this.getBaseExpression().copy());
    }

    @Override
    public Item evaluateItem(XPathContext context) throws XPathException {
        SequenceIterator iter = this.operand.iterate(context);
        Item result = iter.next();
        iter.close();
        return result;
    }

    @Override
    public String displayExpressionName() {
        return "firstItem";
    }
}

