/*
 * Decompiled with CFR 0.152.
 */
package net2.sf.saxon.expr;

import java.io.Serializable;
import javax.xml.transform.SourceLocator;
import net2.sf.saxon.event.LocationProvider;
import net2.sf.saxon.event.SaxonLocator;
import net2.sf.saxon.instruct.LocationMap;
import org.xml.sax.Locator;

public class ExpressionLocation
implements SaxonLocator,
Serializable {
    private String systemId;
    private int lineNumber;
    private int columnNumber = -1;

    public ExpressionLocation() {
    }

    public ExpressionLocation(SourceLocator loc) {
        this.systemId = loc.getSystemId();
        this.lineNumber = loc.getLineNumber();
        this.columnNumber = loc.getColumnNumber();
    }

    public static ExpressionLocation makeFromSax(Locator loc) {
        return new ExpressionLocation(loc.getSystemId(), loc.getLineNumber(), loc.getColumnNumber());
    }

    public ExpressionLocation(LocationProvider provider, long locationId) {
        this.systemId = provider.getSystemId(locationId);
        this.lineNumber = provider.getLineNumber(locationId);
        this.columnNumber = provider.getColumnNumber(locationId);
    }

    public ExpressionLocation(String systemId, int lineNumber, int columnNumber) {
        this.systemId = systemId;
        this.lineNumber = lineNumber;
        this.columnNumber = columnNumber;
    }

    @Override
    public String getSystemId() {
        return this.systemId;
    }

    @Override
    public String getPublicId() {
        return null;
    }

    @Override
    public int getLineNumber() {
        return this.lineNumber;
    }

    @Override
    public int getColumnNumber() {
        return this.columnNumber;
    }

    public void setSystemId(String systemId) {
        this.systemId = systemId;
    }

    public void setLineNumber(int lineNumber) {
        this.lineNumber = lineNumber;
    }

    public void setColumnNumber(int columnNumber) {
        this.columnNumber = columnNumber;
    }

    @Override
    public String getSystemId(long locationId) {
        return this.getSystemId();
    }

    @Override
    public int getLineNumber(long locationId) {
        return this.getLineNumber();
    }

    @Override
    public int getColumnNumber(long locationId) {
        return this.getColumnNumber();
    }

    public static SaxonLocator getSourceLocator(long locationId, LocationProvider locationProvider) {
        SaxonLocator locator;
        if (locationProvider instanceof LocationMap && locationId != 0L) {
            ExpressionLocation loc = new ExpressionLocation();
            loc.setLineNumber(locationProvider.getLineNumber(locationId));
            loc.setSystemId(locationProvider.getSystemId(locationId));
            locator = loc;
        } else if (locationProvider instanceof SaxonLocator) {
            locator = (SaxonLocator)locationProvider;
        } else {
            return new ExpressionLocation();
        }
        return locator;
    }

    public static String truncateURI(String uri) {
        int i;
        String file = uri;
        if (file == null) {
            file = "";
        }
        while ((i = file.indexOf(47)) >= 0 && i < file.length() - 6) {
            file = file.substring(i + 1);
        }
        return file;
    }
}

