/*
 * Decompiled with CFR 0.152.
 */
package net2.sf.saxon.expr;

import net2.sf.saxon.expr.Expression;
import net2.sf.saxon.expr.ExpressionVisitor;
import net2.sf.saxon.expr.XPathContext;
import net2.sf.saxon.om.Item;
import net2.sf.saxon.om.SequenceIterator;
import net2.sf.saxon.trace.ExpressionPresenter;
import net2.sf.saxon.trans.XPathException;
import net2.sf.saxon.type.AnyItemType;
import net2.sf.saxon.type.ItemType;
import net2.sf.saxon.type.TypeHierarchy;

public class ErrorExpression
extends Expression {
    private XPathException exception;

    public ErrorExpression(XPathException exception) {
        this.exception = exception;
        exception.setLocator(this);
    }

    public XPathException getException() {
        return this.exception;
    }

    @Override
    public Expression typeCheck(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        return this;
    }

    @Override
    public Expression optimize(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        return this;
    }

    @Override
    public Item evaluateItem(XPathContext context) throws XPathException {
        XPathException err = new XPathException(this.exception.getMessage());
        err.setLocator(this);
        err.setErrorCodeQName(this.exception.getErrorCodeQName());
        err.setXPathContext(context);
        throw err;
    }

    @Override
    public SequenceIterator iterate(XPathContext context) throws XPathException {
        this.evaluateItem(context);
        return null;
    }

    @Override
    public ItemType getItemType(TypeHierarchy th) {
        return AnyItemType.getInstance();
    }

    @Override
    public int computeCardinality() {
        return 57344;
    }

    @Override
    public Expression copy() {
        return new ErrorExpression(this.exception);
    }

    @Override
    public void explain(ExpressionPresenter destination) {
        destination.startElement("error");
        destination.emitAttribute("message", this.exception.getMessage());
        destination.endElement();
    }
}

