/*
 * Decompiled with CFR 0.152.
 */
package net2.sf.saxon.expr;

import net2.sf.saxon.event.SequenceReceiver;
import net2.sf.saxon.event.TypeCheckingFilter;
import net2.sf.saxon.expr.Atomizer;
import net2.sf.saxon.expr.CardinalityCheckingIterator;
import net2.sf.saxon.expr.Expression;
import net2.sf.saxon.expr.ExpressionTool;
import net2.sf.saxon.expr.ExpressionVisitor;
import net2.sf.saxon.expr.ItemChecker;
import net2.sf.saxon.expr.LastPositionFinder;
import net2.sf.saxon.expr.MappingExpression;
import net2.sf.saxon.expr.RoleLocator;
import net2.sf.saxon.expr.SingletonAtomizer;
import net2.sf.saxon.expr.UnaryExpression;
import net2.sf.saxon.expr.XPathContext;
import net2.sf.saxon.om.FastStringBuffer;
import net2.sf.saxon.om.Item;
import net2.sf.saxon.om.SequenceIterator;
import net2.sf.saxon.pattern.DocumentNodeTest;
import net2.sf.saxon.trace.ExpressionPresenter;
import net2.sf.saxon.trans.Err;
import net2.sf.saxon.trans.XPathException;
import net2.sf.saxon.type.ItemType;
import net2.sf.saxon.type.Type;
import net2.sf.saxon.type.TypeHierarchy;
import net2.sf.saxon.value.Cardinality;

public final class CardinalityChecker
extends UnaryExpression
implements MappingExpression {
    private int requiredCardinality = -1;
    private RoleLocator role;

    private CardinalityChecker(Expression sequence, int cardinality, RoleLocator role) {
        super(sequence);
        this.requiredCardinality = cardinality;
        this.role = role;
        this.computeStaticProperties();
        this.adoptChildExpression(sequence);
    }

    public static Expression makeCardinalityChecker(Expression sequence, int cardinality, RoleLocator role) {
        UnaryExpression result;
        if (sequence instanceof Atomizer && !Cardinality.allowsMany(cardinality)) {
            Expression base = ((Atomizer)sequence).getBaseExpression();
            result = new SingletonAtomizer(base, role, Cardinality.allowsZero(cardinality));
        } else {
            result = new CardinalityChecker(sequence, cardinality, role);
        }
        ExpressionTool.copyLocationInfo(sequence, result);
        return result;
    }

    public int getRequiredCardinality() {
        return this.requiredCardinality;
    }

    @Override
    public Expression typeCheck(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        this.operand = visitor.typeCheck(this.operand, contextItemType);
        if (this.requiredCardinality == 57344 || Cardinality.subsumes(this.requiredCardinality, this.operand.getCardinality())) {
            return this.operand;
        }
        return this;
    }

    @Override
    public Expression optimize(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        this.operand = visitor.optimize(this.operand, contextItemType);
        if (this.requiredCardinality == 57344 || Cardinality.subsumes(this.requiredCardinality, this.operand.getCardinality())) {
            return this.operand;
        }
        return this;
    }

    public void setErrorCode(String code) {
        this.role.setErrorCode(code);
    }

    public RoleLocator getRoleLocator() {
        return this.role;
    }

    @Override
    public int getImplementationMethod() {
        int m = 6;
        if (!Cardinality.allowsMany(this.requiredCardinality)) {
            m |= 1;
        }
        return m;
    }

    @Override
    public SequenceIterator iterate(XPathContext context) throws XPathException {
        SequenceIterator base = this.operand.iterate(context);
        if ((base.getProperties() & 2) != 0) {
            int count = ((LastPositionFinder)base).getLastPosition();
            if (count == 0 && !Cardinality.allowsZero(this.requiredCardinality)) {
                this.typeError("An empty sequence is not allowed as the " + this.role.getMessage(), this.role.getErrorCode(), context);
            } else if (count == 1 && this.requiredCardinality == 8192) {
                this.typeError("The only value allowed for the " + this.role.getMessage() + " is an empty sequence", this.role.getErrorCode(), context);
            } else if (count > 1 && !Cardinality.allowsMany(this.requiredCardinality)) {
                this.typeError("A sequence of more than one item is not allowed as the " + this.role.getMessage() + CardinalityChecker.depictSequenceStart(base.getAnother(), 2), this.role.getErrorCode(), context);
            }
            return base;
        }
        return new CardinalityCheckingIterator(base, this.requiredCardinality, this.role, this);
    }

    public static String depictSequenceStart(SequenceIterator seq, int max) {
        try {
            FastStringBuffer sb = new FastStringBuffer(64);
            int count = 0;
            sb.append(" (");
            while (true) {
                Item next;
                if ((next = seq.next()) == null) {
                    sb.append(") ");
                    return sb.toString();
                }
                if (count++ > 0) {
                    sb.append(", ");
                }
                if (count > max) {
                    sb.append("...) ");
                    return sb.toString();
                }
                sb.append(Err.depict(next));
            }
        }
        catch (XPathException e) {
            return "";
        }
    }

    @Override
    public Item evaluateItem(XPathContext context) throws XPathException {
        Item nextItem;
        SequenceIterator iter = this.operand.iterate(context);
        Item item = null;
        while ((nextItem = iter.next()) != null) {
            if (this.requiredCardinality == 8192) {
                this.typeError("An empty sequence is required as the " + this.role.getMessage(), this.role.getErrorCode(), context);
                return null;
            }
            if (item != null) {
                this.typeError("A sequence of more than one item is not allowed as the " + this.role.getMessage() + CardinalityChecker.depictSequenceStart(iter.getAnother(), 2), this.role.getErrorCode(), context);
                return null;
            }
            item = nextItem;
        }
        if (item == null && !Cardinality.allowsZero(this.requiredCardinality)) {
            this.typeError("An empty sequence is not allowed as the " + this.role.getMessage(), this.role.getErrorCode(), context);
            return null;
        }
        return item;
    }

    @Override
    public void process(XPathContext context) throws XPathException {
        Expression next = this.operand;
        ItemType type = Type.ITEM_TYPE;
        if (next instanceof ItemChecker) {
            type = ((ItemChecker)next).getRequiredType();
            next = ((ItemChecker)next).getBaseExpression();
        }
        if ((next.getImplementationMethod() & 4) != 0 && !(type instanceof DocumentNodeTest)) {
            SequenceReceiver out = context.getReceiver();
            TypeCheckingFilter filter = new TypeCheckingFilter();
            filter.setUnderlyingReceiver(out);
            filter.setPipelineConfiguration(out.getPipelineConfiguration());
            filter.setRequiredType(type, this.requiredCardinality, this.role, this);
            context.setReceiver(filter);
            next.process(context);
            try {
                filter.close();
            }
            catch (XPathException e) {
                e.maybeSetLocation(this);
                throw e;
            }
            context.setReceiver(out);
        } else {
            super.process(context);
        }
    }

    @Override
    public SequenceIterator getMappingIterator(SequenceIterator base, XPathContext context) throws XPathException {
        if ((base.getProperties() & 2) != 0) {
            int count = ((LastPositionFinder)base).getLastPosition();
            if (count == 0 && !Cardinality.allowsZero(this.requiredCardinality)) {
                this.typeError("An empty sequence is not allowed as the " + this.role.getMessage(), this.role.getErrorCode(), context);
            } else if (count == 1 && this.requiredCardinality == 8192) {
                this.typeError("The only value allowed for the " + this.role.getMessage() + " is an empty sequence", this.role.getErrorCode(), context);
            } else if (count > 1 && !Cardinality.allowsMany(this.requiredCardinality)) {
                this.typeError("A sequence of more than one item is not allowed as the " + this.role.getMessage() + CardinalityChecker.depictSequenceStart(base.getAnother(), 2), this.role.getErrorCode(), context);
            }
            return base;
        }
        return new CardinalityCheckingIterator(base, this.requiredCardinality, this.role, this);
    }

    @Override
    public ItemType getItemType(TypeHierarchy th) {
        return this.operand.getItemType(th);
    }

    @Override
    public int computeCardinality() {
        return this.requiredCardinality;
    }

    @Override
    public int computeSpecialProperties() {
        return this.operand.getSpecialProperties();
    }

    @Override
    public Expression copy() {
        return new CardinalityChecker(this.getBaseExpression().copy(), this.requiredCardinality, this.role);
    }

    @Override
    public boolean equals(Object other) {
        return super.equals(other) && this.requiredCardinality == ((CardinalityChecker)other).requiredCardinality;
    }

    @Override
    public void explain(ExpressionPresenter out) {
        out.startElement("checkCardinality");
        out.emitAttribute("occurs", Cardinality.toString(this.requiredCardinality));
        this.operand.explain(out);
        out.endElement();
    }
}

