/*
 * Decompiled with CFR 0.152.
 */
package net2.sf.saxon.expr;

import java.util.Stack;
import net2.sf.saxon.event.SequenceOutputter;
import net2.sf.saxon.event.SequenceReceiver;
import net2.sf.saxon.expr.AxisAtomizingIterator;
import net2.sf.saxon.expr.Expression;
import net2.sf.saxon.expr.ExpressionVisitor;
import net2.sf.saxon.expr.LastPositionFinder;
import net2.sf.saxon.expr.Literal;
import net2.sf.saxon.expr.MappingFunction;
import net2.sf.saxon.expr.MappingIterator;
import net2.sf.saxon.expr.PathMap;
import net2.sf.saxon.expr.UnaryExpression;
import net2.sf.saxon.expr.XPathContext;
import net2.sf.saxon.instruct.DivisibleInstruction;
import net2.sf.saxon.instruct.ValueOf;
import net2.sf.saxon.om.AxisIterator;
import net2.sf.saxon.om.EmptyIterator;
import net2.sf.saxon.om.FunctionItem;
import net2.sf.saxon.om.Item;
import net2.sf.saxon.om.NodeInfo;
import net2.sf.saxon.om.SequenceIterator;
import net2.sf.saxon.om.SingletonIterator;
import net2.sf.saxon.om.UnfailingIterator;
import net2.sf.saxon.pattern.EmptySequenceTest;
import net2.sf.saxon.pattern.NodeTest;
import net2.sf.saxon.trans.XPathException;
import net2.sf.saxon.type.BuiltInAtomicType;
import net2.sf.saxon.type.ComplexType;
import net2.sf.saxon.type.FunctionItemType;
import net2.sf.saxon.type.ItemType;
import net2.sf.saxon.type.SchemaType;
import net2.sf.saxon.type.SimpleType;
import net2.sf.saxon.type.TypeHierarchy;
import net2.sf.saxon.type.Untyped;
import net2.sf.saxon.value.AtomicValue;
import net2.sf.saxon.value.Cardinality;
import net2.sf.saxon.value.SingletonItem;
import net2.sf.saxon.value.UntypedAtomicValue;
import net2.sf.saxon.value.Value;

public final class Atomizer
extends UnaryExpression
implements DivisibleInstruction {
    private boolean untyped = false;
    private boolean singleValued = false;
    private ItemType operandItemType = null;
    private static final int STRING_KINDS = 8576;
    private static final int UNTYPED_KINDS = 520;
    private static final int UNTYPED_IF_UNTYPED_KINDS = 526;

    public Atomizer(Expression sequence) {
        super(sequence);
        sequence.setFlattened(true);
    }

    @Override
    public Expression simplify(ExpressionVisitor visitor) throws XPathException {
        this.computeSingleValued(visitor.getConfiguration().getTypeHierarchy());
        this.operand = visitor.simplify(this.operand);
        if (this.operand instanceof Literal) {
            Item i;
            Value val = ((Literal)this.operand).getValue();
            if (val instanceof SingletonItem && ((SingletonItem)val).getItem() instanceof FunctionItem) {
                XPathException err = new XPathException("Cannot atomize a function item", "FOTY0013");
                err.setLocator(this);
                throw err;
            }
            if (val instanceof AtomicValue) {
                return this.operand;
            }
            SequenceIterator iter = val.iterate();
            do {
                if ((i = iter.next()) != null) continue;
                return this.operand;
            } while (!(i instanceof NodeInfo));
            return this;
        }
        if (this.operand instanceof ValueOf && (((ValueOf)this.operand).getOptions() & 1) == 0) {
            return ((ValueOf)this.operand).convertToStringJoin(visitor.getStaticContext());
        }
        return this;
    }

    @Override
    public Expression typeCheck(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        this.untyped = !visitor.getExecutable().isSchemaAware();
        this.operand = visitor.typeCheck(this.operand, contextItemType);
        TypeHierarchy th = visitor.getConfiguration().getTypeHierarchy();
        this.computeSingleValued(th);
        visitor.resetStaticProperties();
        ItemType operandType = this.operand.getItemType(th);
        if (th.isSubType(operandType, BuiltInAtomicType.ANY_ATOMIC)) {
            return this.operand;
        }
        if (!operandType.isAtomizable()) {
            XPathException err = operandType instanceof FunctionItemType ? new XPathException("Cannot atomize a function item", "FOTY0013") : new XPathException("Cannot atomize an element that is defined in the schema to have element-only content", "FOTY0012");
            err.setLocator(this);
            throw err;
        }
        this.operand.setFlattened(true);
        return this;
    }

    private void computeSingleValued(TypeHierarchy th) {
        SchemaType st;
        ItemType nodeType;
        this.singleValued = this.untyped;
        if (!this.singleValued && (nodeType = this.operand.getItemType(th)) instanceof NodeTest && ((st = ((NodeTest)nodeType).getContentType()) == Untyped.getInstance() || st.isAtomicType())) {
            this.singleValued = true;
        }
    }

    @Override
    public Expression optimize(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        Expression exp = super.optimize(visitor, contextItemType);
        if (exp == this) {
            TypeHierarchy th = visitor.getConfiguration().getTypeHierarchy();
            if (th.isSubType(this.operand.getItemType(th), BuiltInAtomicType.ANY_ATOMIC)) {
                return this.operand;
            }
            if (this.operand instanceof ValueOf && (((ValueOf)this.operand).getOptions() & 1) == 0) {
                return ((ValueOf)this.operand).convertToStringJoin(visitor.getStaticContext());
            }
        }
        return exp;
    }

    @Override
    public int computeSpecialProperties() {
        int p = super.computeSpecialProperties();
        return p | 0x400000;
    }

    @Override
    public Expression copy() {
        Atomizer copy = new Atomizer(this.getBaseExpression().copy());
        copy.untyped = this.untyped;
        copy.singleValued = this.singleValued;
        return copy;
    }

    @Override
    public SequenceIterator iterate(XPathContext context) throws XPathException {
        SequenceIterator base = this.operand.iterate(context);
        return Atomizer.getAtomizingIterator(base);
    }

    @Override
    public Item evaluateItem(XPathContext context) throws XPathException {
        Item i = this.operand.evaluateItem(context);
        if (i == null) {
            return null;
        }
        if (i instanceof NodeInfo) {
            return Value.asItem(((NodeInfo)i).atomize());
        }
        return i;
    }

    @Override
    public void process(XPathContext context) throws XPathException {
        super.process(context);
    }

    @Override
    public ItemType getItemType(TypeHierarchy th) {
        this.operandItemType = this.operand.getItemType(th);
        return Atomizer.getAtomizedItemType(this.operand, this.untyped, th);
    }

    public static ItemType getAtomizedItemType(Expression operand, boolean alwaysUntyped, TypeHierarchy th) {
        ItemType in = operand.getItemType(th);
        if (in.isAtomicType()) {
            return in;
        }
        if (in instanceof NodeTest) {
            if (in instanceof EmptySequenceTest) {
                return in;
            }
            int kinds = ((NodeTest)in).getNodeKindMask();
            if (alwaysUntyped) {
                if ((kinds | 0x2180) == 8576) {
                    return BuiltInAtomicType.STRING;
                }
                if ((kinds | 0x20E) == 526) {
                    return BuiltInAtomicType.UNTYPED_ATOMIC;
                }
            } else if ((kinds | 0x208) == 520) {
                return BuiltInAtomicType.UNTYPED_ATOMIC;
            }
            return in.getAtomizedItemType();
        }
        return BuiltInAtomicType.ANY_ATOMIC;
    }

    @Override
    public int computeCardinality() {
        SchemaType schemaType;
        if (this.untyped || this.singleValued) {
            return this.operand.getCardinality();
        }
        if (Cardinality.allowsMany(this.operand.getCardinality())) {
            return 57344;
        }
        ItemType in = this.operandItemType;
        if (in == null) {
            try {
                in = this.operand.getItemType(this.getContainer().getExecutable().getConfiguration().getTypeHierarchy());
            }
            catch (NullPointerException npe) {
                return 57344;
            }
        }
        if (in.isAtomicType()) {
            return this.operand.getCardinality();
        }
        if (in instanceof NodeTest && (schemaType = ((NodeTest)in).getContentType()).isAtomicType()) {
            return this.operand.getCardinality();
        }
        return 57344;
    }

    @Override
    public PathMap.PathMapNodeSet addToPathMap(PathMap pathMap, PathMap.PathMapNodeSet pathMapNodeSet) {
        PathMap.PathMapNodeSet result = this.operand.addToPathMap(pathMap, pathMapNodeSet);
        if (result != null) {
            result.setAtomized();
        }
        return null;
    }

    public static SequenceIterator getAtomizingIterator(SequenceIterator base) throws XPathException {
        if (base instanceof AxisIterator) {
            return new AxisAtomizingIterator((AxisIterator)base);
        }
        if ((base.getProperties() & 2) != 0) {
            int count = ((LastPositionFinder)base).getLastPosition();
            if (count == 0) {
                return EmptyIterator.getInstance();
            }
            if (count == 1) {
                Item first = base.next();
                return first.getTypedValue();
            }
        }
        return new MappingIterator(base, AtomizingFunction.getInstance());
    }

    @Override
    public void processLeft(Stack<XPathContext> contextStack, Stack state) throws XPathException {
        XPathContext context = contextStack.peek();
        SequenceReceiver out = context.getReceiver();
        state.push(out);
        SequenceOutputter out2 = new SequenceOutputter();
        out2.setPipelineConfiguration(out.getPipelineConfiguration());
        context.setReceiver(out2);
        int annotation = ((NodeInfo)context.getContextItem()).getTypeAnnotation();
        state.push(annotation);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void processRight(Stack<XPathContext> contextStack, Stack state) throws XPathException {
        XPathContext context = contextStack.peek();
        int annotation = (Integer)state.pop();
        CharSequence value = ((SequenceOutputter)context.getReceiver()).getFirstItem().getStringValueCS();
        SchemaType type = context.getConfiguration().getSchemaType(annotation);
        SequenceReceiver out = (SequenceReceiver)state.pop();
        context.setReceiver(out);
        if (type.isComplexType()) {
            if (!((ComplexType)type).isMixedContent()) throw new XPathException("Cannot atomize element with element-only content");
            UnfailingIterator iter = SingletonIterator.makeIterator(new UntypedAtomicValue(value));
            state.push(iter);
            return;
        } else {
            if (((SimpleType)type).isNamespaceSensitive()) {
                throw new XPathException("Cannot yet do streaming of content with namespace-sensitive element types");
            }
            SequenceIterator iter = ((SimpleType)type).getTypedValue(value, null, context.getConfiguration().getNameChecker());
            state.push(iter);
        }
    }

    @Override
    public String displayExpressionName() {
        return "atomize";
    }

    public static class AtomizingFunction
    implements MappingFunction {
        private static final AtomizingFunction theInstance = new AtomizingFunction();

        private AtomizingFunction() {
        }

        public static AtomizingFunction getInstance() {
            return theInstance;
        }

        @Override
        public SequenceIterator map(Item item) throws XPathException {
            if (item instanceof NodeInfo) {
                return item.getTypedValue();
            }
            return SingletonIterator.makeIterator(item);
        }
    }
}

