/*
 * Decompiled with CFR 0.152.
 */
package net2.sf.saxon.expr;

import net2.sf.saxon.expr.CastExpression;
import net2.sf.saxon.expr.Expression;
import net2.sf.saxon.expr.ExpressionTool;
import net2.sf.saxon.expr.ExpressionVisitor;
import net2.sf.saxon.expr.ItemMappingFunction;
import net2.sf.saxon.expr.ItemMappingIterator;
import net2.sf.saxon.expr.Literal;
import net2.sf.saxon.expr.MappingExpression;
import net2.sf.saxon.expr.UnaryExpression;
import net2.sf.saxon.expr.XPathContext;
import net2.sf.saxon.om.Item;
import net2.sf.saxon.om.SequenceIterator;
import net2.sf.saxon.om.ValueRepresentation;
import net2.sf.saxon.trace.ExpressionPresenter;
import net2.sf.saxon.trans.XPathException;
import net2.sf.saxon.type.AtomicType;
import net2.sf.saxon.type.BuiltInAtomicType;
import net2.sf.saxon.type.ItemType;
import net2.sf.saxon.type.TypeHierarchy;
import net2.sf.saxon.value.AtomicValue;
import net2.sf.saxon.value.Cardinality;
import net2.sf.saxon.value.SequenceExtent;
import net2.sf.saxon.value.Value;

public final class AtomicSequenceConverter
extends UnaryExpression
implements MappingExpression {
    private AtomicType requiredItemType;
    private BuiltInAtomicType requiredPrimitiveType;

    public AtomicSequenceConverter(Expression sequence, AtomicType requiredItemType) {
        super(sequence);
        this.requiredItemType = requiredItemType;
        this.requiredPrimitiveType = (BuiltInAtomicType)requiredItemType.getPrimitiveItemType();
        ExpressionTool.copyLocationInfo(sequence, this);
    }

    public AtomicType getRequiredPrimitiveType() {
        return this.requiredPrimitiveType;
    }

    @Override
    public Expression simplify(ExpressionVisitor visitor) throws XPathException {
        this.operand = visitor.simplify(this.operand);
        if (this.operand instanceof Literal) {
            ValueRepresentation val = SequenceExtent.makeSequenceExtent(this.iterate(visitor.getStaticContext().makeEarlyEvaluationContext()));
            return Literal.makeLiteral(Value.asValue(val));
        }
        return this;
    }

    @Override
    public Expression typeCheck(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        this.operand = visitor.typeCheck(this.operand, contextItemType);
        TypeHierarchy th = visitor.getConfiguration().getTypeHierarchy();
        if (th.isSubType(this.operand.getItemType(th), this.requiredItemType)) {
            return this.operand;
        }
        if (!Cardinality.allowsMany(this.operand.getCardinality())) {
            CastExpression cast = new CastExpression(this.operand, this.requiredItemType, (this.operand.getCardinality() & 0x2000) != 0);
            ExpressionTool.copyLocationInfo(this, cast);
            return cast;
        }
        return this;
    }

    @Override
    public int computeSpecialProperties() {
        int p = super.computeSpecialProperties();
        return p | 0x400000;
    }

    @Override
    public Expression copy() {
        return new AtomicSequenceConverter(this.getBaseExpression().copy(), this.requiredItemType);
    }

    @Override
    public SequenceIterator iterate(XPathContext context) throws XPathException {
        SequenceIterator base = this.operand.iterate(context);
        return this.getMappingIterator(base, context);
    }

    @Override
    public SequenceIterator getMappingIterator(SequenceIterator base, final XPathContext context) throws XPathException {
        ItemMappingFunction converter = new ItemMappingFunction(){

            @Override
            public Item map(Item item) throws XPathException {
                return ((AtomicValue)item).convert(AtomicSequenceConverter.this.requiredPrimitiveType, true, context).asAtomic();
            }
        };
        return new ItemMappingIterator(base, converter, true);
    }

    @Override
    public Item evaluateItem(XPathContext context) throws XPathException {
        Item item = this.operand.evaluateItem(context);
        if (item == null) {
            return null;
        }
        return ((AtomicValue)item).convert(this.requiredPrimitiveType, true, context).asAtomic();
    }

    @Override
    public ItemType getItemType(TypeHierarchy th) {
        return this.requiredItemType;
    }

    @Override
    public int computeCardinality() {
        return this.operand.getCardinality();
    }

    @Override
    public boolean equals(Object other) {
        return super.equals(other) && this.requiredPrimitiveType == ((AtomicSequenceConverter)other).requiredPrimitiveType;
    }

    @Override
    public void explain(ExpressionPresenter destination) {
        destination.startElement("convertItems");
        destination.emitAttribute("to", this.requiredItemType.toString(destination.getNamePool()));
        this.operand.explain(destination);
        destination.endElement();
    }
}

