/*
 * Decompiled with CFR 0.152.
 */
package net2.sf.saxon.evpull;

import java.io.File;
import javax.xml.transform.stream.StreamSource;
import net2.sf.saxon.Configuration;
import net2.sf.saxon.event.PipelineConfiguration;
import net2.sf.saxon.event.TreeReceiver;
import net2.sf.saxon.evpull.Decomposer;
import net2.sf.saxon.evpull.EndDocumentEvent;
import net2.sf.saxon.evpull.EndElementEvent;
import net2.sf.saxon.evpull.EventIterator;
import net2.sf.saxon.evpull.EventIteratorToReceiver;
import net2.sf.saxon.evpull.EventStackIterator;
import net2.sf.saxon.evpull.PullEvent;
import net2.sf.saxon.evpull.SingletonEventIterator;
import net2.sf.saxon.evpull.StartDocumentEvent;
import net2.sf.saxon.evpull.StartElementEvent;
import net2.sf.saxon.om.DocumentInfo;
import net2.sf.saxon.om.Item;
import net2.sf.saxon.om.NodeInfo;
import net2.sf.saxon.om.SequenceIterator;
import net2.sf.saxon.query.QueryResult;
import net2.sf.saxon.tinytree.TinyBuilder;
import net2.sf.saxon.trans.XPathException;

public class SequenceComposer
implements SequenceIterator {
    private EventIterator base;
    private int position = 0;
    private Item current = null;
    private PipelineConfiguration pipe;

    public SequenceComposer(EventIterator iter, PipelineConfiguration pipe) {
        this.base = EventStackIterator.flatten(iter);
        this.pipe = pipe;
    }

    @Override
    public Item next() throws XPathException {
        PullEvent pe = this.base.next();
        if (pe == null) {
            this.position = -1;
            this.current = null;
            return null;
        }
        if (pe instanceof Item) {
            this.current = (Item)pe;
            ++this.position;
            return this.current;
        }
        if (pe instanceof StartDocumentEvent || pe instanceof StartElementEvent) {
            SubtreeIterator sub = new SubtreeIterator(this.base, pe);
            TinyBuilder builder = new TinyBuilder();
            builder.setPipelineConfiguration(this.pipe);
            TreeReceiver receiver = new TreeReceiver(builder);
            builder.setPipelineConfiguration(this.pipe);
            EventIteratorToReceiver.copy(sub, receiver);
            this.current = builder.getCurrentRoot();
            ++this.position;
            return this.current;
        }
        throw new IllegalStateException(pe.getClass().getName());
    }

    @Override
    public Item current() {
        return this.current;
    }

    @Override
    public void close() {
    }

    @Override
    public SequenceIterator getAnother() throws XPathException {
        throw new UnsupportedOperationException("getAnother");
    }

    @Override
    public int getProperties() {
        return 0;
    }

    @Override
    public int position() {
        return this.position;
    }

    public static void main(String[] args) throws Exception {
        NodeInfo item;
        Configuration config = new Configuration();
        DocumentInfo doc = config.buildDocument(new StreamSource(new File("c:/MyJava/samples/data/books.xml")));
        PipelineConfiguration pipe = config.makePipelineConfiguration();
        pipe.setHostLanguage(51);
        Decomposer e = new Decomposer(new SingletonEventIterator(doc), pipe);
        SequenceComposer iter = new SequenceComposer(e, pipe);
        while ((item = (NodeInfo)iter.next()) != null) {
            System.out.println(QueryResult.serialize(item));
        }
    }

    private static class SubtreeIterator
    implements EventIterator {
        private int level = 0;
        private EventIterator base;
        private PullEvent first;

        public SubtreeIterator(EventIterator base, PullEvent first) {
            this.base = base;
            this.first = first;
        }

        @Override
        public PullEvent next() throws XPathException {
            if (this.first != null) {
                PullEvent pe = this.first;
                this.first = null;
                return pe;
            }
            if (this.level < 0) {
                return null;
            }
            PullEvent pe = this.base.next();
            if (pe instanceof StartElementEvent || pe instanceof StartDocumentEvent) {
                ++this.level;
            } else if (pe instanceof EndElementEvent || pe instanceof EndDocumentEvent) {
                --this.level;
            }
            return pe;
        }

        @Override
        public boolean isFlatSequence() {
            return this.base.isFlatSequence();
        }
    }
}

