/*
 * Decompiled with CFR 0.152.
 */
package net2.sf.saxon.evpull;

import java.io.File;
import java.io.PrintStream;
import javax.xml.transform.stream.StreamSource;
import net2.sf.saxon.Configuration;
import net2.sf.saxon.event.PipelineConfiguration;
import net2.sf.saxon.evpull.Decomposer;
import net2.sf.saxon.evpull.EndDocumentEvent;
import net2.sf.saxon.evpull.EndElementEvent;
import net2.sf.saxon.evpull.EventIterator;
import net2.sf.saxon.evpull.EventStackIterator;
import net2.sf.saxon.evpull.PullEvent;
import net2.sf.saxon.evpull.SingletonEventIterator;
import net2.sf.saxon.evpull.StartDocumentEvent;
import net2.sf.saxon.evpull.StartElementEvent;
import net2.sf.saxon.om.DocumentInfo;
import net2.sf.saxon.om.FastStringBuffer;
import net2.sf.saxon.om.NamePool;
import net2.sf.saxon.om.NodeInfo;
import net2.sf.saxon.pattern.NodeKindTest;
import net2.sf.saxon.trans.XPathException;
import net2.sf.saxon.type.Type;
import net2.sf.saxon.value.AtomicValue;

public class PullEventTracer
implements EventIterator {
    private EventIterator base;
    private String label = String.valueOf(("PET" + this.hashCode()).substring(0, 8)) + ": ";
    private PrintStream out = System.err;
    private NamePool pool;

    public PullEventTracer(EventIterator base, Configuration config) {
        this.base = base;
        this.pool = config.getNamePool();
    }

    @Override
    public PullEvent next() throws XPathException {
        PullEvent pe = this.base.next();
        if (pe == null) {
            return null;
        }
        if (pe instanceof StartDocumentEvent) {
            this.out.println(String.valueOf(this.label) + "StartDocument");
            this.label = "  " + this.label;
        } else if (pe instanceof StartElementEvent) {
            this.out.println(String.valueOf(this.label) + "StartElement " + this.pool.getDisplayName(((StartElementEvent)pe).getNameCode()));
            this.label = "  " + this.label;
        } else if (pe instanceof EndDocumentEvent) {
            this.label = this.label.substring(2);
            this.out.println(String.valueOf(this.label) + "EndDocument");
        } else if (pe instanceof EndElementEvent) {
            this.label = this.label.substring(2);
            this.out.println(String.valueOf(this.label) + "EndElement");
        } else if (pe instanceof NodeInfo) {
            FastStringBuffer fsb = new FastStringBuffer(64);
            fsb.append(this.label);
            int kind = ((NodeInfo)pe).getNodeKind();
            fsb.append(NodeKindTest.toString(kind));
            if (kind == 1 || kind == 2) {
                fsb.append(' ');
                fsb.append(((NodeInfo)pe).getDisplayName());
            }
            fsb.append(" \"");
            fsb.append(((NodeInfo)pe).getStringValueCS());
            fsb.append('\"');
            this.out.println(fsb.toString());
        } else if (pe instanceof AtomicValue) {
            this.out.println(String.valueOf(this.label) + Type.displayTypeName((AtomicValue)pe) + ' ' + pe);
        } else if (pe instanceof EventIterator) {
            this.out.println(String.valueOf(this.label) + "** NESTED ITERATOR **");
        } else {
            this.out.println(String.valueOf(this.label) + pe.getClass().getName());
        }
        return pe;
    }

    @Override
    public boolean isFlatSequence() {
        return this.base.isFlatSequence();
    }

    public static void main(String[] args) throws Exception {
        PullEvent pe;
        Configuration config = new Configuration();
        DocumentInfo doc = config.buildDocument(new StreamSource(new File("c:/MyJava/samples/data/books.xml")));
        PipelineConfiguration pipe = config.makePipelineConfiguration();
        pipe.setHostLanguage(51);
        EventIterator e = new Decomposer(new SingletonEventIterator(doc), pipe);
        e = EventStackIterator.flatten(e);
        e = new PullEventTracer(e, config);
        while ((pe = e.next()) != null) {
        }
    }
}

