/*
 * Decompiled with CFR 0.152.
 */
package net2.sf.saxon.evpull;

import java.util.ArrayList;
import java.util.Iterator;
import net2.sf.saxon.evpull.EndElementEvent;
import net2.sf.saxon.evpull.EventIterator;
import net2.sf.saxon.evpull.EventStackIterator;
import net2.sf.saxon.evpull.PullEvent;
import net2.sf.saxon.evpull.StartElementEvent;
import net2.sf.saxon.om.NamePool;
import net2.sf.saxon.om.NamespaceResolver;
import net2.sf.saxon.trans.XPathException;

public class NamespaceMaintainer
implements EventIterator,
NamespaceResolver {
    private EventIterator base;
    private NamePool namePool;
    private int[] allNamespaces = new int[50];
    private int allNamespacesSize = 0;
    private int[] namespaceCountStack = new int[50];
    private int depth = 0;

    public NamespaceMaintainer(EventIterator base, NamePool namePool) {
        this.base = EventStackIterator.flatten(base);
        this.namePool = namePool;
    }

    @Override
    public boolean isFlatSequence() {
        return true;
    }

    @Override
    public PullEvent next() throws XPathException {
        PullEvent event = this.base.next();
        if (event instanceof StartElementEvent) {
            this.startElement((StartElementEvent)event);
        } else if (event instanceof EndElementEvent) {
            this.endElement();
        }
        return event;
    }

    private void startElement(StartElementEvent event) throws XPathException {
        int[] declaredNamespaces = event.getLocalNamespaces();
        int numberOfDeclaredNamespaces = declaredNamespaces.length;
        int i = 0;
        while (i < declaredNamespaces.length) {
            if (declaredNamespaces[i] == -1) {
                numberOfDeclaredNamespaces = i;
                break;
            }
            ++i;
        }
        if (this.depth >= this.namespaceCountStack.length) {
            int[] newstack = new int[this.depth * 2];
            System.arraycopy(this.namespaceCountStack, 0, newstack, 0, this.depth);
            this.namespaceCountStack = newstack;
        }
        this.namespaceCountStack[this.depth++] = numberOfDeclaredNamespaces;
        while (this.allNamespacesSize + numberOfDeclaredNamespaces >= this.allNamespaces.length) {
            int[] newlist = new int[this.allNamespacesSize * 2];
            System.arraycopy(this.allNamespaces, 0, newlist, 0, this.allNamespacesSize);
            this.allNamespaces = newlist;
        }
        i = 0;
        while (i < declaredNamespaces.length) {
            if (declaredNamespaces[i] == -1) break;
            this.allNamespaces[this.allNamespacesSize++] = declaredNamespaces[i];
            ++i;
        }
    }

    private void endElement() {
        this.allNamespacesSize -= this.namespaceCountStack[--this.depth];
    }

    protected short getURICode(short prefixCode) {
        int i = this.allNamespacesSize - 1;
        while (i >= 0) {
            if (this.allNamespaces[i] >> 16 == prefixCode) {
                return (short)(this.allNamespaces[i] & 0xFFFF);
            }
            --i;
        }
        if (prefixCode == 0) {
            return 0;
        }
        return -1;
    }

    @Override
    public String getURIForPrefix(String prefix, boolean useDefault) {
        if (!(prefix != null && prefix.length() != 0 || useDefault)) {
            return "";
        }
        if ("xml".equals(prefix)) {
            return "http://www.w3.org/XML/1998/namespace";
        }
        short prefixCode = this.namePool.getCodeForPrefix(prefix);
        short uriCode = this.getURICode(prefixCode);
        if (uriCode == -1) {
            return null;
        }
        return this.namePool.getURIFromURICode(uriCode);
    }

    public Iterator iteratePrefixes() {
        ArrayList<String> prefixes = new ArrayList<String>(this.allNamespacesSize);
        int i = this.allNamespacesSize - 1;
        while (i >= 0) {
            String prefix = this.namePool.getPrefixFromNamespaceCode(this.allNamespaces[i]);
            if (!prefixes.contains(prefix)) {
                prefixes.add(prefix);
            }
            --i;
        }
        prefixes.add("xml");
        return prefixes.iterator();
    }
}

