/*
 * Decompiled with CFR 0.152.
 */
package net2.sf.saxon.evpull;

import java.util.Stack;
import net2.sf.saxon.evpull.EventIterator;
import net2.sf.saxon.evpull.PullEvent;
import net2.sf.saxon.trans.XPathException;

public class EventStackIterator
implements EventIterator {
    private Stack<EventIterator> eventStack = new Stack();

    public static EventIterator flatten(EventIterator base) {
        if (base.isFlatSequence()) {
            return base;
        }
        return new EventStackIterator(base);
    }

    private EventStackIterator(EventIterator base) {
        this.eventStack.push(base);
    }

    @Override
    public PullEvent next() throws XPathException {
        if (this.eventStack.isEmpty()) {
            return null;
        }
        EventIterator iter = this.eventStack.peek();
        PullEvent next = iter.next();
        if (next == null) {
            this.eventStack.pop();
            return this.next();
        }
        if (next instanceof EventIterator) {
            this.eventStack.push((EventIterator)next);
            return this.next();
        }
        return next;
    }

    @Override
    public boolean isFlatSequence() {
        return true;
    }
}

