/*
 * Decompiled with CFR 0.152.
 */
package net2.sf.saxon.evpull;

import java.util.Iterator;
import net2.sf.saxon.event.SequenceReceiver;
import net2.sf.saxon.evpull.EndDocumentEvent;
import net2.sf.saxon.evpull.EndElementEvent;
import net2.sf.saxon.evpull.EventIterator;
import net2.sf.saxon.evpull.EventStackIterator;
import net2.sf.saxon.evpull.PullEvent;
import net2.sf.saxon.evpull.StartDocumentEvent;
import net2.sf.saxon.evpull.StartElementEvent;
import net2.sf.saxon.om.AxisIterator;
import net2.sf.saxon.om.DocumentInfo;
import net2.sf.saxon.om.Item;
import net2.sf.saxon.om.NodeInfo;
import net2.sf.saxon.om.Orphan;
import net2.sf.saxon.trans.XPathException;

public class EventIteratorToReceiver {
    private EventIteratorToReceiver() {
    }

    public static void copy(EventIterator in, SequenceReceiver out) throws XPathException {
        PullEvent event;
        in = EventStackIterator.flatten(in);
        int level = 0;
        out.open();
        while ((event = in.next()) != null) {
            if (event instanceof Orphan && ((Orphan)event).getNodeKind() == 3) {
                out.characters(((Orphan)event).getStringValueCS(), 0, 0);
                continue;
            }
            if (event instanceof DocumentInfo && level > 0) {
                NodeInfo node;
                AxisIterator kids = ((DocumentInfo)event).iterateAxis((byte)3);
                while ((node = (NodeInfo)kids.next()) != null) {
                    out.append(node, 0, 0);
                }
                continue;
            }
            if (event instanceof Item) {
                out.append((Item)event, 0, 2);
                continue;
            }
            if (event instanceof StartElementEvent) {
                StartElementEvent see = (StartElementEvent)event;
                ++level;
                out.startElement(see.getNameCode(), see.getTypeCode(), 0, 64);
                int[] localNamespaces = see.getLocalNamespaces();
                int n = 0;
                while (n < localNamespaces.length) {
                    int ns = localNamespaces[n];
                    if (ns == -1) break;
                    out.namespace(ns, 0);
                    ++n;
                }
                if (see.hasAttributes()) {
                    Iterator ai = see.iterateAttributes();
                    while (ai.hasNext()) {
                        NodeInfo att = (NodeInfo)ai.next();
                        out.attribute(att.getNameCode(), att.getTypeAnnotation(), att.getStringValueCS(), 0, 0);
                    }
                }
                out.startContent();
                continue;
            }
            if (event instanceof EndElementEvent) {
                --level;
                out.endElement();
                continue;
            }
            if (event instanceof StartDocumentEvent) {
                if (level == 0) {
                    out.startDocument(0);
                } else {
                    out.characters("", 0, 0);
                }
                ++level;
                continue;
            }
            if (event instanceof EndDocumentEvent) {
                if (--level == 0) {
                    out.endDocument();
                    continue;
                }
                out.characters("", 0, 0);
                continue;
            }
            throw new AssertionError((Object)("Unknown event class " + event.getClass()));
        }
        out.close();
    }
}

