/*
 * Decompiled with CFR 0.152.
 */
package net2.sf.saxon.evpull;

import net2.sf.saxon.event.PipelineConfiguration;
import net2.sf.saxon.evpull.BracketedDocumentIterator;
import net2.sf.saxon.evpull.BracketedElementIterator;
import net2.sf.saxon.evpull.EndElementEvent;
import net2.sf.saxon.evpull.EventIterator;
import net2.sf.saxon.evpull.EventIteratorOverSequence;
import net2.sf.saxon.evpull.EventStackIterator;
import net2.sf.saxon.evpull.PullEvent;
import net2.sf.saxon.evpull.SingletonEventIterator;
import net2.sf.saxon.evpull.StartElementEvent;
import net2.sf.saxon.om.AxisIterator;
import net2.sf.saxon.om.NodeInfo;
import net2.sf.saxon.tinytree.TinyNodeImpl;
import net2.sf.saxon.tinytree.TinyTreeEventIterator;
import net2.sf.saxon.trans.XPathException;

public class Decomposer
implements EventIterator {
    private EventIterator base;
    private PipelineConfiguration pipe;

    public Decomposer(EventIterator base, PipelineConfiguration pipe) {
        this.pipe = pipe;
        this.base = EventStackIterator.flatten(base);
    }

    public Decomposer(NodeInfo node, PipelineConfiguration pipe) {
        this.pipe = pipe;
        this.base = new SingletonEventIterator(node);
    }

    @Override
    public PullEvent next() throws XPathException {
        PullEvent pe = this.base.next();
        if (pe instanceof NodeInfo) {
            NodeInfo node = (NodeInfo)pe;
            switch (node.getNodeKind()) {
                case 9: {
                    if (node instanceof TinyNodeImpl) {
                        return new TinyTreeEventIterator((TinyNodeImpl)node, this.pipe);
                    }
                    AxisIterator content = node.iterateAxis((byte)3);
                    EventIteratorOverSequence contentEvents = new EventIteratorOverSequence(content);
                    return new BracketedDocumentIterator(new Decomposer(contentEvents, this.pipe));
                }
                case 1: {
                    NodeInfo att;
                    if (node instanceof TinyNodeImpl) {
                        return new TinyTreeEventIterator((TinyNodeImpl)node, this.pipe);
                    }
                    AxisIterator content = node.iterateAxis((byte)3);
                    EventIteratorOverSequence contentEvents = new EventIteratorOverSequence(content);
                    StartElementEvent see = new StartElementEvent(this.pipe);
                    see.setNameCode(node.getNameCode());
                    see.setTypeCode(node.getTypeAnnotation());
                    see.setLocalNamespaces(node.getDeclaredNamespaces(null));
                    AxisIterator atts = node.iterateAxis((byte)2);
                    while ((att = (NodeInfo)atts.next()) != null) {
                        see.addAttribute(att);
                    }
                    return new BracketedElementIterator(see, new Decomposer(contentEvents, this.pipe), EndElementEvent.getInstance());
                }
            }
            return node;
        }
        return pe;
    }

    @Override
    public boolean isFlatSequence() {
        return false;
    }
}

