/*
 * Decompiled with CFR 0.152.
 */
package net2.sf.saxon.evpull;

import net2.sf.saxon.Configuration;
import net2.sf.saxon.evpull.EndDocumentEvent;
import net2.sf.saxon.evpull.EndElementEvent;
import net2.sf.saxon.evpull.EventIterator;
import net2.sf.saxon.evpull.EventStackIterator;
import net2.sf.saxon.evpull.PullEvent;
import net2.sf.saxon.evpull.StartDocumentEvent;
import net2.sf.saxon.evpull.StartElementEvent;
import net2.sf.saxon.om.FastStringBuffer;
import net2.sf.saxon.om.NodeInfo;
import net2.sf.saxon.om.Orphan;
import net2.sf.saxon.trans.XPathException;
import net2.sf.saxon.value.AtomicValue;

public class ComplexContentProcessor
implements EventIterator {
    private Configuration config;
    private EventIterator base;
    private PullEvent[] startEventStack;
    private int depth;
    private NodeInfo pendingTextNode;
    private boolean pendingTextNodeIsMutable;
    private boolean prevAtomic = false;
    private PullEvent pendingOutput = null;

    public ComplexContentProcessor(Configuration config, EventIterator base) {
        this.config = config;
        this.base = EventStackIterator.flatten(base);
        this.startEventStack = new PullEvent[20];
        this.depth = 0;
    }

    @Override
    public PullEvent next() throws XPathException {
        if (this.pendingOutput != null) {
            PullEvent next = this.pendingOutput;
            this.pendingOutput = null;
            return next;
        }
        return this.advance();
    }

    private PullEvent advance() throws XPathException {
        block3: while (true) {
            FastStringBuffer sb;
            Orphan o;
            FastStringBuffer sb2;
            NodeInfo next;
            PullEvent e;
            if (this.depth == 0) {
                e = this.base.next();
                if (e instanceof StartElementEvent) {
                    this.push(e);
                } else if (e instanceof StartDocumentEvent) {
                    this.push(e);
                }
                return e;
            }
            e = this.base.next();
            if (e instanceof StartElementEvent) {
                this.prevAtomic = false;
                this.push(e);
                if (this.pendingTextNode != null) {
                    this.pendingOutput = e;
                    next = this.pendingTextNode;
                    this.pendingTextNode = null;
                    return next;
                }
                return e;
            }
            if (e instanceof StartDocumentEvent) {
                this.prevAtomic = false;
                this.push(e);
                if (this.pendingTextNode == null) continue;
                this.pendingOutput = e;
                next = this.pendingTextNode;
                this.pendingTextNode = null;
                return next;
            }
            if (e instanceof EndElementEvent) {
                this.prevAtomic = false;
                this.pop();
                if (this.pendingTextNode != null) {
                    this.pendingOutput = e;
                    next = this.pendingTextNode;
                    this.pendingTextNode = null;
                    return next;
                }
                return e;
            }
            if (e instanceof EndDocumentEvent) {
                this.prevAtomic = false;
                this.pop();
                if (this.pendingTextNode != null) {
                    this.pendingOutput = e;
                    next = this.pendingTextNode;
                    this.pendingTextNode = null;
                    return next;
                }
                return e;
            }
            if (e instanceof NodeInfo) {
                this.prevAtomic = false;
                switch (((NodeInfo)e).getNodeKind()) {
                    case 3: {
                        if (this.pendingTextNode == null) {
                            this.pendingTextNode = (NodeInfo)e;
                            this.pendingTextNodeIsMutable = false;
                            continue block3;
                        }
                        if (this.pendingTextNodeIsMutable) {
                            sb2 = (FastStringBuffer)((Orphan)this.pendingTextNode).getStringValueCS();
                            sb2.append(((NodeInfo)e).getStringValueCS());
                            continue block3;
                        }
                        o = new Orphan(this.config);
                        o.setNodeKind((short)3);
                        sb = new FastStringBuffer(64);
                        sb.append(this.pendingTextNode.getStringValueCS());
                        sb.append(((NodeInfo)e).getStringValueCS());
                        o.setStringValue(sb);
                        this.pendingTextNode = o;
                        this.pendingTextNodeIsMutable = true;
                        continue block3;
                    }
                }
                if (this.pendingTextNode != null) {
                    this.pendingOutput = e;
                    next = this.pendingTextNode;
                    this.pendingTextNode = null;
                    return next;
                }
                return e;
            }
            if (!(e instanceof AtomicValue)) break;
            if (this.prevAtomic) {
                sb2 = (FastStringBuffer)((Orphan)this.pendingTextNode).getStringValueCS();
                sb2.append(' ');
                sb2.append(((AtomicValue)e).getStringValueCS());
                continue;
            }
            if (this.pendingTextNode != null) {
                this.prevAtomic = true;
                if (this.pendingTextNodeIsMutable) {
                    sb2 = (FastStringBuffer)((Orphan)this.pendingTextNode).getStringValueCS();
                    sb2.append(((AtomicValue)e).getStringValueCS());
                    continue;
                }
                o = new Orphan(this.config);
                o.setNodeKind((short)3);
                sb = new FastStringBuffer(64);
                sb.append(this.pendingTextNode.getStringValueCS());
                sb.append(((AtomicValue)e).getStringValueCS());
                o.setStringValue(sb);
                this.pendingTextNode = o;
                this.pendingTextNodeIsMutable = true;
                continue;
            }
            this.prevAtomic = true;
            o = new Orphan(this.config);
            o.setNodeKind((short)3);
            sb = new FastStringBuffer(64);
            sb.append(((AtomicValue)e).getStringValueCS());
            o.setStringValue(sb);
            this.pendingTextNode = o;
            this.pendingTextNodeIsMutable = true;
        }
        throw new AssertionError((Object)"Unknown event");
    }

    private void push(PullEvent p) {
        if (this.depth >= this.startEventStack.length - 1) {
            PullEvent[] b2 = new PullEvent[this.depth * 2];
            System.arraycopy(this.startEventStack, 0, b2, 0, this.startEventStack.length);
            this.startEventStack = b2;
        }
        if (p instanceof StartElementEvent) {
            int retained = 0;
            int[] nsp = ((StartElementEvent)p).getLocalNamespaces();
            int nspi = 0;
            while (nspi < nsp.length) {
                if (nsp[nspi] == -1) break;
                ++retained;
                int i = this.depth - 1;
                block1: while (i >= 0) {
                    PullEvent q = this.startEventStack[i];
                    if (q instanceof StartElementEvent) {
                        int[] nsq = ((StartElementEvent)q).getLocalNamespaces();
                        int nsqi = 0;
                        while (nsqi < nsq.length) {
                            if (nsp[nspi] == nsq[nsqi]) {
                                nsp[nspi] = -1;
                                --retained;
                                break block1;
                            }
                            if (nsp[nspi] >> 16 == nsq[nsqi] >> 16) break block1;
                            ++nsqi;
                        }
                    }
                    --i;
                }
                ++nspi;
            }
            if (retained < nsp.length) {
                int[] nsr = new int[retained];
                int nsri = 0;
                int nspi2 = 0;
                while (nspi2 < nsp.length) {
                    if (nsp[nspi2] != -1) {
                        nsr[nsri++] = nsp[nspi2];
                        if (nsri == retained) break;
                    }
                    ++nspi2;
                }
                ((StartElementEvent)p).setLocalNamespaces(nsr);
            }
        }
        this.startEventStack[this.depth++] = p;
        this.prevAtomic = false;
    }

    private void pop() {
        --this.depth;
        this.prevAtomic = false;
    }

    @Override
    public boolean isFlatSequence() {
        return true;
    }
}

