/*
 * Decompiled with CFR 0.152.
 */
package net2.sf.saxon.evpull;

import net2.sf.saxon.evpull.EndDocumentEvent;
import net2.sf.saxon.evpull.EventIterator;
import net2.sf.saxon.evpull.EventStackIterator;
import net2.sf.saxon.evpull.PullEvent;
import net2.sf.saxon.evpull.StartDocumentEvent;
import net2.sf.saxon.trans.XPathException;

public class BracketedDocumentIterator
implements EventIterator {
    private EventIterator content;
    private int state = 0;
    private static final int INITIAL_STATE = 0;
    private static final int PROCESSING_CHILDREN = 1;
    private static final int EXHAUSTED = 2;

    public BracketedDocumentIterator(EventIterator content) {
        this.content = EventStackIterator.flatten(content);
        this.state = 0;
    }

    @Override
    public PullEvent next() throws XPathException {
        switch (this.state) {
            case 0: {
                this.state = 1;
                return StartDocumentEvent.getInstance();
            }
            case 1: {
                PullEvent pe = this.content.next();
                if (pe == null) {
                    this.state = 2;
                    return EndDocumentEvent.getInstance();
                }
                return pe;
            }
            case 2: {
                return null;
            }
        }
        throw new AssertionError((Object)("BracketedDocumentIterator state " + this.state));
    }

    @Override
    public boolean isFlatSequence() {
        return true;
    }
}

