/*
 * Decompiled with CFR 0.152.
 */
package net2.sf.saxon.event;

import java.io.IOException;
import java.util.Properties;
import java.util.Stack;
import net2.sf.saxon.charcode.UTF16CharacterSet;
import net2.sf.saxon.charcode.UTF8CharacterSet;
import net2.sf.saxon.event.Emitter;
import net2.sf.saxon.om.FastStringBuffer;
import net2.sf.saxon.sort.IntHashMap;
import net2.sf.saxon.tinytree.CharSlice;
import net2.sf.saxon.tinytree.CompressedWhitespace;
import net2.sf.saxon.trans.XPathException;
import net2.sf.saxon.value.Whitespace;

public class XMLEmitter
extends Emitter {
    protected boolean started = false;
    protected boolean startedElement = false;
    protected boolean openStartTag = false;
    protected boolean declarationIsWritten = false;
    protected int elementCode;
    protected boolean preferHex = false;
    protected boolean undeclareNamespaces = false;
    protected Stack elementStack = new Stack();
    private IntHashMap<String> nameLookup = new IntHashMap(100);
    private boolean indenting = false;
    private int indentSpaces = 3;
    private String indentChars = "\n                                                          ";
    private int totalAttributeLength = 0;
    private boolean requireWellFormed = false;
    static boolean[] specialInText = new boolean[128];
    static boolean[] specialInAtt;
    private char[] charref = new char[10];

    static {
        int i = 0;
        while (i <= 31) {
            XMLEmitter.specialInText[i] = true;
            ++i;
        }
        i = 32;
        while (i <= 127) {
            XMLEmitter.specialInText[i] = false;
            ++i;
        }
        XMLEmitter.specialInText[10] = false;
        XMLEmitter.specialInText[9] = false;
        XMLEmitter.specialInText[13] = true;
        XMLEmitter.specialInText[60] = true;
        XMLEmitter.specialInText[62] = true;
        XMLEmitter.specialInText[38] = true;
        specialInAtt = new boolean[128];
        i = 0;
        while (i <= 31) {
            XMLEmitter.specialInAtt[i] = true;
            ++i;
        }
        i = 32;
        while (i <= 127) {
            XMLEmitter.specialInAtt[i] = false;
            ++i;
        }
        XMLEmitter.specialInAtt[0] = true;
        XMLEmitter.specialInAtt[13] = true;
        XMLEmitter.specialInAtt[10] = true;
        XMLEmitter.specialInAtt[9] = true;
        XMLEmitter.specialInAtt[60] = true;
        XMLEmitter.specialInAtt[62] = true;
        XMLEmitter.specialInAtt[38] = true;
        XMLEmitter.specialInAtt[34] = true;
    }

    @Override
    public void open() throws XPathException {
    }

    @Override
    public void startDocument(int properties) throws XPathException {
    }

    @Override
    public void endDocument() throws XPathException {
        if (!this.elementStack.isEmpty()) {
            throw new IllegalStateException("Attempt to end document in serializer when elements are unclosed");
        }
    }

    protected void openDocument() throws XPathException {
        if (this.writer == null) {
            this.makeWriter();
        }
        if (this.characterSet == null) {
            this.characterSet = UTF8CharacterSet.getInstance();
        }
        if (this.outputProperties == null) {
            this.outputProperties = new Properties();
        }
        String rep = this.outputProperties.getProperty("{http://saxon.sf.net/}character-representation");
        if ((rep = Whitespace.trim(rep)) != null) {
            this.preferHex = rep.equalsIgnoreCase("hex");
        }
        if ((rep = this.outputProperties.getProperty("undeclare-prefixes")) != null) {
            this.undeclareNamespaces = rep.equalsIgnoreCase("yes");
        }
        this.writeDeclaration();
    }

    public void writeDeclaration() throws XPathException {
        if (this.declarationIsWritten) {
            return;
        }
        this.declarationIsWritten = true;
        try {
            String version;
            String omitXMLDeclaration;
            this.indenting = "yes".equals(this.outputProperties.getProperty("indent"));
            String s = this.outputProperties.getProperty("{http://saxon.sf.net/}indent-spaces");
            if (s != null) {
                try {
                    this.indentSpaces = Integer.parseInt(Whitespace.trim(s));
                }
                catch (NumberFormatException err) {
                    this.indentSpaces = 3;
                }
            }
            String byteOrderMark = this.outputProperties.getProperty("byte-order-mark");
            String encoding = this.outputProperties.getProperty("encoding");
            if (encoding == null || encoding.equalsIgnoreCase("utf8")) {
                encoding = "UTF-8";
            }
            if ("yes".equals(byteOrderMark) && ("UTF-8".equalsIgnoreCase(encoding) || "UTF-16LE".equalsIgnoreCase(encoding) || "UTF-16BE".equalsIgnoreCase(encoding))) {
                this.writer.write(65279);
            }
            if ((omitXMLDeclaration = this.outputProperties.getProperty("omit-xml-declaration")) == null) {
                omitXMLDeclaration = "no";
            }
            if ((version = this.outputProperties.getProperty("version")) == null) {
                version = this.getConfiguration().getNameChecker().getXMLVersion();
            } else {
                if (!version.equals("1.0") && !version.equals("1.1")) {
                    XPathException err = new XPathException("XML version must be 1.0 or 1.1");
                    err.setErrorCode("SESU0006");
                    throw err;
                }
                if (!version.equals("1.0") && omitXMLDeclaration.equals("yes") && this.outputProperties.getProperty("doctype-system") != null) {
                    XPathException err = new XPathException("Values of 'version', 'omit-xml-declaration', and 'doctype-system' conflict");
                    err.setErrorCode("SEPM0009");
                    throw err;
                }
            }
            if (version.equals("1.0") && this.undeclareNamespaces) {
                XPathException err = new XPathException("Cannot undeclare namespaces with XML version 1.0");
                err.setErrorCode("SEPM0010");
                throw err;
            }
            String standalone = this.outputProperties.getProperty("standalone");
            if ("omit".equals(standalone)) {
                standalone = null;
            }
            if (standalone != null) {
                this.requireWellFormed = true;
                if (omitXMLDeclaration.equals("yes")) {
                    XPathException err = new XPathException("Values of 'standalone' and 'omit-xml-declaration' conflict");
                    err.setErrorCode("SEPM0009");
                    throw err;
                }
            }
            if (omitXMLDeclaration.equals("no")) {
                this.writer.write("<?xml version=\"" + version + "\" " + "encoding=\"" + encoding + '\"' + (standalone != null ? " standalone=\"" + standalone + '\"' : "") + "?>");
            }
        }
        catch (IOException err) {
            throw new XPathException(err);
        }
    }

    protected void writeDocType(String type, String systemId, String publicId) throws XPathException {
        try {
            if (this.declarationIsWritten && !this.indenting) {
                this.writer.write("\n");
            }
            this.writer.write("<!DOCTYPE " + type + '\n');
            String quotedSystemId = null;
            if (systemId != null) {
                quotedSystemId = systemId.contains("\"") ? "'" + systemId + "'" : String.valueOf('\"') + systemId + '\"';
            }
            if (systemId != null && publicId == null) {
                this.writer.write("  SYSTEM " + quotedSystemId + ">\n");
            } else if (systemId == null && publicId != null) {
                this.writer.write("  PUBLIC \"" + publicId + "\">\n");
            } else {
                this.writer.write("  PUBLIC \"" + publicId + "\" " + quotedSystemId + ">\n");
            }
        }
        catch (IOException err) {
            throw new XPathException(err);
        }
    }

    @Override
    public void close() throws XPathException {
        if (!this.started) {
            this.openDocument();
        }
        try {
            if (this.writer != null) {
                this.writer.flush();
            }
        }
        catch (IOException err) {
            throw new XPathException(err);
        }
    }

    @Override
    public void startElement(int nameCode, int typeCode, int locationId, int properties) throws XPathException {
        if (!this.started) {
            this.openDocument();
        } else if (this.requireWellFormed && this.elementStack.isEmpty()) {
            if (this.startedElement) {
                XPathException err = new XPathException("When 'standalone' or 'doctype-system' is specified, the document must be well-formed; but this document contains more than one top-level element");
                err.setErrorCode("SEPM0004");
                throw err;
            }
            this.startedElement = true;
        }
        String displayName = this.getCachedName(nameCode);
        if (displayName == null) {
            int badchar;
            displayName = this.namePool.getDisplayName(nameCode);
            if (!this.allCharactersEncodable && (badchar = this.testCharacters(displayName)) != 0) {
                XPathException err = new XPathException("Element name contains a character (decimal + " + badchar + ") not available in the selected encoding");
                err.setErrorCode("SERE0008");
                throw err;
            }
            this.putCachedName(nameCode, displayName);
        }
        this.elementStack.push(displayName);
        this.elementCode = nameCode;
        try {
            if (!this.started) {
                String systemId = this.outputProperties.getProperty("doctype-system");
                String publicId = this.outputProperties.getProperty("doctype-public");
                if ("".equals(systemId)) {
                    systemId = null;
                }
                if ("".equals(publicId)) {
                    publicId = null;
                }
                if (systemId != null) {
                    this.requireWellFormed = true;
                    this.writeDocType(displayName, systemId, publicId);
                }
                this.started = true;
            }
            if (this.openStartTag) {
                this.closeStartTag();
            }
            this.writer.write(60);
            this.writer.write(displayName);
            this.openStartTag = true;
            this.totalAttributeLength = 0;
        }
        catch (IOException err) {
            throw new XPathException(err);
        }
    }

    @Override
    public void namespace(int namespaceCode, int properties) throws XPathException {
        try {
            String nsprefix = this.namePool.getPrefixFromNamespaceCode(namespaceCode);
            String nsuri = this.namePool.getURIFromNamespaceCode(namespaceCode);
            int len = nsuri.length() + nsprefix.length() + 8;
            String sep = " ";
            if (this.indenting && this.totalAttributeLength + len > 80 && this.totalAttributeLength != 0) {
                sep = this.getAttributeIndentString();
            }
            this.totalAttributeLength += len;
            if (nsprefix.length() == 0) {
                this.writer.write(sep);
                this.writeAttribute(this.elementCode, "xmlns", nsuri, 0);
            } else if (!nsprefix.equals("xml")) {
                int badchar = this.testCharacters(nsprefix);
                if (badchar != 0) {
                    XPathException err = new XPathException("Namespace prefix contains a character (decimal + " + badchar + ") not available in the selected encoding");
                    err.setErrorCode("SERE0008");
                    throw err;
                }
                if (this.undeclareNamespaces || nsuri.length() != 0) {
                    this.writer.write(sep);
                    this.writeAttribute(this.elementCode, "xmlns:" + nsprefix, nsuri, 0);
                }
            }
        }
        catch (IOException err) {
            throw new XPathException(err);
        }
    }

    @Override
    public void attribute(int nameCode, int typeCode, CharSequence value, int locationId, int properties) throws XPathException {
        String displayName = this.getCachedName(nameCode);
        if (displayName == null) {
            int badchar;
            displayName = this.namePool.getDisplayName(nameCode);
            if (!this.allCharactersEncodable && (badchar = this.testCharacters(displayName)) != 0) {
                XPathException err = new XPathException("Attribute name contains a character (decimal + " + badchar + ") not available in the selected encoding");
                err.setErrorCode("SERE0008");
                throw err;
            }
            this.putCachedName(nameCode, displayName);
        }
        int len = displayName.length() + value.length() + 4;
        String sep = " ";
        if (this.indenting && this.totalAttributeLength + len > 80 && this.totalAttributeLength != 0) {
            sep = this.getAttributeIndentString();
        }
        this.totalAttributeLength += len;
        try {
            this.writer.write(sep);
            this.writeAttribute(this.elementCode, displayName, value, properties);
        }
        catch (IOException err) {
            throw new XPathException(err);
        }
    }

    private String getAttributeIndentString() {
        int indent = (this.elementStack.size() - 1) * this.indentSpaces + ((String)this.elementStack.peek()).length() + 3;
        while (indent >= this.indentChars.length()) {
            this.indentChars = String.valueOf(this.indentChars) + "                     ";
        }
        return this.indentChars.substring(0, indent);
    }

    @Override
    public void startContent() throws XPathException {
    }

    public void closeStartTag() throws XPathException {
        try {
            if (this.openStartTag) {
                this.writer.write(62);
                this.openStartTag = false;
            }
        }
        catch (IOException err) {
            throw new XPathException(err);
        }
    }

    protected String emptyElementTagCloser(String displayName, int nameCode) {
        return "/>";
    }

    protected void writeAttribute(int elCode, String attname, CharSequence value, int properties) throws XPathException {
        try {
            String val = value.toString();
            this.writer.write(attname);
            if ((properties & 4) != 0) {
                this.writer.write(61);
                this.writer.write(34);
                this.writer.write(val);
                this.writer.write(34);
            } else if ((properties & 0x100) != 0) {
                this.writer.write(61);
                int delimiter = val.indexOf(34) >= 0 && val.indexOf(39) < 0 ? 39 : 34;
                this.writer.write(delimiter);
                this.writeEscape(value, true);
                this.writer.write(delimiter);
            } else {
                this.writer.write("=\"");
                this.writeEscape(value, true);
                this.writer.write(34);
            }
        }
        catch (IOException err) {
            throw new XPathException(err);
        }
    }

    protected int testCharacters(CharSequence chars) throws XPathException {
        int i = 0;
        while (i < chars.length()) {
            char c = chars.charAt(i);
            if (c > '\u007f') {
                if (UTF16CharacterSet.isHighSurrogate(c)) {
                    int cc;
                    if (!this.characterSet.inCharset(cc = UTF16CharacterSet.combinePair(c, chars.charAt(++i)))) {
                        return cc;
                    }
                } else if (!this.characterSet.inCharset(c)) {
                    return c;
                }
            }
            ++i;
        }
        return 0;
    }

    @Override
    public void endElement() throws XPathException {
        String displayName = (String)this.elementStack.pop();
        try {
            if (this.openStartTag) {
                this.writer.write(this.emptyElementTagCloser(displayName, this.elementCode));
                this.openStartTag = false;
            } else {
                this.writer.write("</");
                this.writer.write(displayName);
                this.writer.write(62);
            }
        }
        catch (IOException err) {
            throw new XPathException(err);
        }
    }

    @Override
    public void characters(CharSequence chars, int locationId, int properties) throws XPathException {
        if (!this.started) {
            this.openDocument();
        }
        if (this.requireWellFormed && this.elementStack.isEmpty() && !Whitespace.isWhite(chars)) {
            XPathException err = new XPathException("When 'standalone' or 'doctype-system' is specified, the document must be well-formed; but this document contains a top-level text node");
            err.setErrorCode("SEPM0004");
            throw err;
        }
        try {
            if (this.openStartTag) {
                this.closeStartTag();
            }
            if ((properties & 4) != 0) {
                this.writeCharSequence(chars);
            } else if ((properties & 1) == 0) {
                this.writeEscape(chars, false);
            } else if (this.testCharacters(chars) == 0) {
                if ((properties & 0x100) == 0) {
                    this.writeCharSequence(chars);
                } else {
                    int len = chars.length();
                    int i = 0;
                    while (i < len) {
                        char c = chars.charAt(i);
                        if (c != '\u0000') {
                            this.writer.write(c);
                        }
                        ++i;
                    }
                }
            } else {
                int len = chars.length();
                int i = 0;
                while (i < len) {
                    char c = chars.charAt(i);
                    if (c != '\u0000') {
                        if (c > '\u007f' && UTF16CharacterSet.isHighSurrogate(c)) {
                            char[] pair;
                            int cc;
                            if (!this.characterSet.inCharset(cc = UTF16CharacterSet.combinePair(c, (pair = new char[]{c, chars.charAt(++i)})[1]))) {
                                this.writeEscape(new CharSlice(pair), false);
                            } else {
                                this.writeCharSequence(new CharSlice(pair));
                            }
                        } else {
                            char[] ca = new char[]{c};
                            if (!this.characterSet.inCharset(c)) {
                                this.writeEscape(new CharSlice(ca), false);
                            } else {
                                this.writeCharSequence(new CharSlice(ca));
                            }
                        }
                    }
                    ++i;
                }
            }
        }
        catch (IOException err) {
            throw new XPathException(err);
        }
    }

    public void writeCharSequence(CharSequence s) throws IOException {
        if (s instanceof String) {
            this.writer.write((String)s);
        } else if (s instanceof CharSlice) {
            ((CharSlice)s).write(this.writer);
        } else if (s instanceof FastStringBuffer) {
            ((FastStringBuffer)s).write(this.writer);
        } else if (s instanceof CompressedWhitespace) {
            ((CompressedWhitespace)s).write(this.writer);
        } else {
            this.writer.write(s.toString());
        }
    }

    @Override
    public void processingInstruction(String target, CharSequence data, int locationId, int properties) throws XPathException {
        int x;
        if (!this.started) {
            this.openDocument();
        }
        if ((x = this.testCharacters(target)) != 0) {
            XPathException err = new XPathException("Character in processing instruction name cannot be represented in the selected encoding (code " + x + ')');
            err.setErrorCode("SERE0008");
            throw err;
        }
        x = this.testCharacters(data);
        if (x != 0) {
            XPathException err = new XPathException("Character in processing instruction data cannot be represented in the selected encoding (code " + x + ')');
            err.setErrorCode("SERE0008");
            throw err;
        }
        try {
            if (this.openStartTag) {
                this.closeStartTag();
            }
            this.writer.write("<?" + target + (data.length() > 0 ? String.valueOf(' ') + data.toString() : "") + "?>");
        }
        catch (IOException err) {
            throw new XPathException(err);
        }
    }

    protected void writeEscape(CharSequence chars, boolean inAttribute) throws IOException, XPathException {
        boolean[] specialChars;
        int segstart = 0;
        boolean disabled = false;
        boolean[] blArray = specialChars = inAttribute ? specialInAtt : specialInText;
        if (chars instanceof CompressedWhitespace) {
            ((CompressedWhitespace)chars).writeEscape(specialChars, this.writer);
            return;
        }
        int clength = chars.length();
        while (segstart < clength) {
            char c;
            int i = segstart;
            while (i < clength) {
                c = chars.charAt(i);
                if (c < '\u007f') {
                    if (specialChars[c]) break;
                    ++i;
                    continue;
                }
                if (c < '\u00a0' || c == '\u2028' || UTF16CharacterSet.isHighSurrogate(c) || !this.characterSet.inCharset(c)) break;
                ++i;
            }
            if (i >= clength) {
                if (segstart == 0) {
                    this.writeCharSequence(chars);
                } else {
                    this.writeCharSequence(chars.subSequence(segstart, i));
                }
                return;
            }
            if (i > segstart) {
                this.writeCharSequence(chars.subSequence(segstart, i));
            }
            if ((c = chars.charAt(i)) == '\u0000') {
                disabled = !disabled;
            } else if (disabled) {
                if (c > '\u007f') {
                    if (UTF16CharacterSet.isHighSurrogate(c)) {
                        int cc = UTF16CharacterSet.combinePair(c, chars.charAt(i + 1));
                        if (!this.characterSet.inCharset(cc)) {
                            XPathException de = new XPathException("Character x" + Integer.toHexString(cc) + " is not available in the chosen encoding");
                            de.setErrorCode("SERE0008");
                            throw de;
                        }
                    } else if (!this.characterSet.inCharset(c)) {
                        XPathException de = new XPathException("Character " + c + " (x" + Integer.toHexString(c) + ") is not available in the chosen encoding");
                        de.setErrorCode("SERE0008");
                        throw de;
                    }
                }
                this.writer.write(c);
            } else if (c < '\u007f') {
                if (c == '<') {
                    this.writer.write("&lt;");
                } else if (c == '>') {
                    this.writer.write("&gt;");
                } else if (c == '&') {
                    this.writer.write("&amp;");
                } else if (c == '\"') {
                    this.writer.write("&#34;");
                } else if (c == '\n') {
                    this.writer.write("&#xA;");
                } else if (c == '\r') {
                    this.writer.write("&#xD;");
                } else if (c == '\t') {
                    this.writer.write("&#x9;");
                } else {
                    this.outputCharacterReference(c);
                }
            } else if (c < '\u00a0' || c == '\u2028') {
                this.outputCharacterReference(c);
            } else if (UTF16CharacterSet.isHighSurrogate(c)) {
                char d;
                int charval;
                if (this.characterSet.inCharset(charval = UTF16CharacterSet.combinePair(c, d = chars.charAt(++i)))) {
                    this.writer.write(c);
                    this.writer.write(d);
                } else {
                    this.outputCharacterReference(charval);
                }
            } else {
                this.outputCharacterReference(c);
            }
            segstart = ++i;
        }
    }

    protected void outputCharacterReference(int charval) throws IOException {
        if (this.preferHex) {
            int o = 0;
            this.charref[o++] = 38;
            this.charref[o++] = 35;
            this.charref[o++] = 120;
            String code = Integer.toHexString(charval);
            int len = code.length();
            int k = 0;
            while (k < len) {
                this.charref[o++] = code.charAt(k);
                ++k;
            }
            this.charref[o++] = 59;
            this.writer.write(this.charref, 0, o);
        } else {
            int o = 0;
            this.charref[o++] = 38;
            this.charref[o++] = 35;
            String code = Integer.toString(charval);
            int len = code.length();
            int k = 0;
            while (k < len) {
                this.charref[o++] = code.charAt(k);
                ++k;
            }
            this.charref[o++] = 59;
            this.writer.write(this.charref, 0, o);
        }
    }

    @Override
    public void comment(CharSequence chars, int locationId, int properties) throws XPathException {
        int x;
        if (!this.started) {
            this.openDocument();
        }
        if ((x = this.testCharacters(chars)) != 0) {
            XPathException err = new XPathException("Character in comment cannot be represented in the selected encoding (code " + x + ')');
            err.setErrorCode("SERE0008");
            throw err;
        }
        try {
            if (this.openStartTag) {
                this.closeStartTag();
            }
            this.writer.write("<!--");
            this.writer.write(chars.toString());
            this.writer.write("-->");
        }
        catch (IOException err) {
            throw new XPathException(err);
        }
    }

    @Override
    public boolean usesTypeAnnotations() {
        return false;
    }

    protected String getCachedName(int nameCode) {
        return this.nameLookup.get(nameCode);
    }

    protected void putCachedName(int nameCode, String displayName) {
        this.nameLookup.put(nameCode, displayName);
    }
}

