/*
 * Decompiled with CFR 0.152.
 */
package net2.sf.saxon.event;

import net2.sf.saxon.charcode.UTF16CharacterSet;
import net2.sf.saxon.charcode.XMLCharacterData;
import net2.sf.saxon.event.PipelineConfiguration;
import net2.sf.saxon.event.ProxyReceiver;
import net2.sf.saxon.expr.ExpressionLocation;
import net2.sf.saxon.om.Name10Checker;
import net2.sf.saxon.om.NameChecker;
import net2.sf.saxon.om.NamePool;
import net2.sf.saxon.sort.IntHashSet;
import net2.sf.saxon.trans.Err;
import net2.sf.saxon.trans.XPathException;

public class XML10ContentChecker
extends ProxyReceiver {
    private NameChecker checker = Name10Checker.getInstance();
    private NamePool pool;
    private IntHashSet cache = new IntHashSet(100);

    @Override
    public void setPipelineConfiguration(PipelineConfiguration pipe) {
        this.pool = pipe.getConfiguration().getNamePool();
        super.setPipelineConfiguration(pipe);
    }

    @Override
    public void startElement(int nameCode, int typeCode, int locationId, int properties) throws XPathException {
        if (!this.cache.contains(nameCode)) {
            if (!this.checker.isValidNCName(this.pool.getLocalName(nameCode))) {
                XPathException err = new XPathException("Invalid XML 1.0 element name " + Err.wrap(this.pool.getLocalName(nameCode), 1));
                err.setErrorCode("SERE0005");
                err.setLocator(new ExpressionLocation(this.getPipelineConfiguration().getLocationProvider(), locationId));
                throw err;
            }
            this.cache.add(nameCode);
        }
        this.nextReceiver.startElement(nameCode, typeCode, locationId, properties);
    }

    @Override
    public void attribute(int nameCode, int typeCode, CharSequence value, int locationId, int properties) throws XPathException {
        if (!this.cache.contains(nameCode)) {
            if (!this.checker.isValidNCName(this.pool.getLocalName(nameCode))) {
                XPathException err = new XPathException("Invalid XML 1.0 attribute name " + Err.wrap(this.pool.getLocalName(nameCode), 2));
                err.setErrorCode("SERE0005");
                err.setLocator(new ExpressionLocation(this.getPipelineConfiguration().getLocationProvider(), locationId));
                throw err;
            }
            this.cache.add(nameCode);
        }
        this.checkString(value, locationId);
        this.nextReceiver.attribute(nameCode, typeCode, value, locationId, properties);
    }

    @Override
    public void characters(CharSequence chars, int locationId, int properties) throws XPathException {
        this.checkString(chars, locationId);
        this.nextReceiver.characters(chars, locationId, properties);
    }

    @Override
    public void comment(CharSequence chars, int locationId, int properties) throws XPathException {
        this.checkString(chars, locationId);
        this.nextReceiver.comment(chars, locationId, properties);
    }

    @Override
    public void processingInstruction(String target, CharSequence data, int locationId, int properties) throws XPathException {
        if (!this.checker.isValidNCName(target)) {
            XPathException err = new XPathException("Invalid XML 1.0 processing instruction name " + Err.wrap(target));
            err.setErrorCode("SERE0005");
            err.setLocator(new ExpressionLocation(this.getPipelineConfiguration().getLocationProvider(), locationId));
            throw err;
        }
        this.checkString(data, locationId);
        this.nextReceiver.processingInstruction(target, data, locationId, properties);
    }

    private void checkString(CharSequence in, long locationId) throws XPathException {
        int len = in.length();
        int c = 0;
        while (c < len) {
            int ch32 = in.charAt(c);
            if (UTF16CharacterSet.isHighSurrogate(ch32)) {
                char low = in.charAt(++c);
                ch32 = UTF16CharacterSet.combinePair((char)ch32, low);
            }
            if (!XMLCharacterData.isValid10(ch32)) {
                XPathException err = new XPathException("The result tree contains a character not allowed by XML 1.0 (hex " + Integer.toHexString(ch32) + ')');
                err.setErrorCode("SERE0006");
                err.setLocator(new ExpressionLocation(this.getPipelineConfiguration().getLocationProvider(), locationId));
                throw err;
            }
            ++c;
        }
    }
}

