/*
 * Decompiled with CFR 0.152.
 */
package net2.sf.saxon.event;

import net2.sf.saxon.codenorm.Normalizer;
import net2.sf.saxon.event.ProxyReceiver;
import net2.sf.saxon.trans.XPathException;
import net2.sf.saxon.value.Whitespace;

public class UnicodeNormalizer
extends ProxyReceiver {
    private Normalizer normalizer;

    public UnicodeNormalizer(String form) throws XPathException {
        int fb;
        if (form.equals("NFC")) {
            fb = 2;
        } else if (form.equals("NFD")) {
            fb = 0;
        } else if (form.equals("NFKC")) {
            fb = 3;
        } else if (form.equals("NFKD")) {
            fb = 1;
        } else {
            XPathException err = new XPathException("Unknown normalization form " + form);
            err.setErrorCode("SESU0011");
            throw err;
        }
        this.normalizer = new Normalizer((byte)fb);
    }

    @Override
    public void attribute(int nameCode, int typeCode, CharSequence value, int locationId, int properties) throws XPathException {
        this.nextReceiver.attribute(nameCode, typeCode, this.normalizer.normalize(value), locationId, properties);
    }

    @Override
    public void characters(CharSequence chars, int locationId, int properties) throws XPathException {
        if (Whitespace.isWhite(chars)) {
            this.nextReceiver.characters(chars, locationId, properties);
        } else {
            this.nextReceiver.characters(this.normalizer.normalize(chars), locationId, properties);
        }
    }
}

