/*
 * Decompiled with CFR 0.152.
 */
package net2.sf.saxon.event;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.xml.transform.Result;
import net2.sf.saxon.event.ProxyReceiver;
import net2.sf.saxon.event.Receiver;
import net2.sf.saxon.event.SerializerFactory;
import net2.sf.saxon.event.Sink;
import net2.sf.saxon.om.NamePool;
import net2.sf.saxon.trans.XPathException;
import net2.sf.saxon.value.Whitespace;

public class UncommittedSerializer
extends ProxyReceiver {
    boolean committed = false;
    List pending = null;
    Result finalResult;
    Properties outputProperties;

    public UncommittedSerializer(Result finalResult, Properties outputProperties) {
        this.finalResult = finalResult;
        this.outputProperties = outputProperties;
        this.setUnderlyingReceiver(new Sink());
    }

    @Override
    public void open() throws XPathException {
        this.committed = false;
    }

    @Override
    public void close() throws XPathException {
        if (!this.committed) {
            this.switchToMethod("xml");
        }
        this.getUnderlyingReceiver().close();
    }

    @Override
    public void characters(CharSequence chars, int locationId, int properties) throws XPathException {
        if (this.committed) {
            this.getUnderlyingReceiver().characters(chars, locationId, properties);
        } else {
            if (this.pending == null) {
                this.pending = new ArrayList(10);
            }
            PendingNode node = new PendingNode();
            node.kind = 3;
            node.name = null;
            node.content = chars.toString();
            node.locationId = locationId;
            node.properties = properties;
            this.pending.add(node);
            if (!Whitespace.isWhite(chars)) {
                this.switchToMethod("xml");
            }
        }
    }

    @Override
    public void processingInstruction(String target, CharSequence data, int locationId, int properties) throws XPathException {
        if (this.committed) {
            this.getUnderlyingReceiver().processingInstruction(target, data, locationId, properties);
        } else {
            if (this.pending == null) {
                this.pending = new ArrayList(10);
            }
            PendingNode node = new PendingNode();
            node.kind = 7;
            node.name = target;
            node.content = data;
            node.locationId = locationId;
            node.properties = properties;
            this.pending.add(node);
        }
    }

    @Override
    public void comment(CharSequence chars, int locationId, int properties) throws XPathException {
        if (this.committed) {
            this.getUnderlyingReceiver().comment(chars, locationId, properties);
        } else {
            if (this.pending == null) {
                this.pending = new ArrayList(10);
            }
            PendingNode node = new PendingNode();
            node.kind = 8;
            node.name = null;
            node.content = chars;
            node.locationId = locationId;
            node.properties = properties;
            this.pending.add(node);
        }
    }

    @Override
    public void startElement(int nameCode, int typeCode, int locationId, int properties) throws XPathException {
        if (!this.committed) {
            NamePool namePool = this.getNamePool();
            String name = namePool.getLocalName(nameCode);
            short uriCode = namePool.getURICode(nameCode);
            if (name.equalsIgnoreCase("html") && uriCode == 0) {
                this.switchToMethod("html");
            } else if (name.equals("html") && namePool.getURIFromURICode(uriCode).equals("http://www.w3.org/1999/xhtml")) {
                String version = this.outputProperties.getProperty("{http://saxon.sf.net/}stylesheet-version");
                if ("1".equals(version)) {
                    this.switchToMethod("xml");
                } else {
                    this.switchToMethod("xhtml");
                }
            } else {
                this.switchToMethod("xml");
            }
        }
        this.getUnderlyingReceiver().startElement(nameCode, typeCode, locationId, properties);
    }

    private void switchToMethod(String method) throws XPathException {
        Properties newProperties = new Properties(this.outputProperties);
        newProperties.setProperty("method", method);
        SerializerFactory sf = this.getConfiguration().getSerializerFactory();
        Receiver target = sf.getReceiver(this.finalResult, this.getPipelineConfiguration(), newProperties);
        this.committed = true;
        target.open();
        target.startDocument(0);
        if (this.pending != null) {
            int i = 0;
            while (i < this.pending.size()) {
                PendingNode node = (PendingNode)this.pending.get(i);
                switch (node.kind) {
                    case 8: {
                        target.comment(node.content, node.locationId, node.properties);
                        break;
                    }
                    case 7: {
                        target.processingInstruction(node.name, node.content, node.locationId, node.properties);
                        break;
                    }
                    case 3: {
                        target.characters(node.content, node.locationId, node.properties);
                    }
                }
                ++i;
            }
            this.pending = null;
        }
        this.setUnderlyingReceiver(target);
    }

    private static final class PendingNode {
        int kind;
        String name;
        CharSequence content;
        int properties;
        int locationId;

        private PendingNode() {
        }
    }
}

