/*
 * Decompiled with CFR 0.152.
 */
package net2.sf.saxon.event;

import javax.xml.transform.Result;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import net2.sf.saxon.Controller;
import net2.sf.saxon.event.Builder;
import net2.sf.saxon.event.ProxyReceiver;
import net2.sf.saxon.event.Receiver;
import net2.sf.saxon.om.DocumentInfo;
import net2.sf.saxon.trans.XPathException;

public class TransformerReceiver
extends ProxyReceiver {
    Controller controller;
    Builder builder;
    Result result;

    public TransformerReceiver(Controller controller) {
        this.controller = controller;
    }

    @Override
    public void open() throws XPathException {
        this.builder = this.controller.makeBuilder();
        this.setPipelineConfiguration(this.builder.getPipelineConfiguration());
        this.builder.setSystemId(this.systemId);
        Receiver stripper = this.controller.makeStripper(this.builder);
        if (this.controller.getExecutable().stripsInputTypeAnnotations()) {
            stripper = this.controller.getConfiguration().getAnnotationStripper(stripper);
        }
        this.setUnderlyingReceiver(stripper);
        this.nextReceiver.open();
    }

    public Transformer getTransformer() {
        return this.controller;
    }

    @Override
    public void setSystemId(String systemId) {
        super.setSystemId(systemId);
        this.controller.setBaseOutputURI(systemId);
    }

    @Override
    public void startElement(int nameCode, int typeCode, int locationId, int properties) throws XPathException {
        this.nextReceiver.startElement(nameCode, typeCode, locationId, properties);
    }

    public void setResult(Result result) {
        if (result == null) {
            throw new IllegalArgumentException("Result must not be null");
        }
        this.result = result;
    }

    public Result getResult() {
        return this.result;
    }

    @Override
    public void close() throws XPathException {
        this.nextReceiver.close();
        DocumentInfo doc = (DocumentInfo)this.builder.getCurrentRoot();
        this.builder.reset();
        if (doc == null) {
            throw new XPathException("No source document has been built");
        }
        try {
            this.controller.transformDocument(doc, this.result);
        }
        catch (TransformerException e) {
            throw XPathException.makeXPathException(e);
        }
    }
}

