/*
 * Decompiled with CFR 0.152.
 */
package net2.sf.saxon.event;

import java.io.Serializable;
import java.util.List;
import java.util.Properties;
import javax.xml.transform.Result;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamResult;
import net2.sf.saxon.Controller;
import net2.sf.saxon.event.CDATAFilter;
import net2.sf.saxon.event.CharacterMapExpander;
import net2.sf.saxon.event.ContentHandlerProxy;
import net2.sf.saxon.event.Emitter;
import net2.sf.saxon.event.HTMLEmitter;
import net2.sf.saxon.event.HTMLIndenter;
import net2.sf.saxon.event.HTMLURIEscaper;
import net2.sf.saxon.event.MetaTagAdjuster;
import net2.sf.saxon.event.PipelineConfiguration;
import net2.sf.saxon.event.ProxyReceiver;
import net2.sf.saxon.event.Receiver;
import net2.sf.saxon.event.TEXTEmitter;
import net2.sf.saxon.event.UncommittedSerializer;
import net2.sf.saxon.event.UnicodeNormalizer;
import net2.sf.saxon.event.XHTMLEmitter;
import net2.sf.saxon.event.XHTMLIndenter;
import net2.sf.saxon.event.XML10ContentChecker;
import net2.sf.saxon.event.XMLEmitter;
import net2.sf.saxon.event.XMLIndenter;
import net2.sf.saxon.event.XQueryEmitter;
import net2.sf.saxon.om.ExternalObjectModel;
import net2.sf.saxon.trans.XPathException;

public class SerializerFactory
implements Serializable {
    public Receiver getReceiver(Result result, PipelineConfiguration pipe, Properties props) throws XPathException {
        if (result instanceof Emitter) {
            if (((Emitter)result).getOutputProperties() == null) {
                ((Emitter)result).setOutputProperties(props);
            }
            return (Emitter)result;
        }
        if (result instanceof Receiver) {
            Receiver receiver = (Receiver)result;
            receiver.setSystemId(result.getSystemId());
            receiver.setPipelineConfiguration(pipe);
            return receiver;
        }
        if (result instanceof SAXResult) {
            ContentHandlerProxy proxy = this.newContentHandlerProxy();
            proxy.setUnderlyingContentHandler(((SAXResult)result).getHandler());
            proxy.setPipelineConfiguration(pipe);
            proxy.setOutputProperties(props);
            if ("yes".equals(props.getProperty("{http://saxon.sf.net/}supply-source-locator"))) {
                if (pipe.getConfiguration().isCompileWithTracing()) {
                    pipe.getController().addTraceListener(proxy.getTraceListener());
                } else {
                    XPathException de = new XPathException("Cannot use saxon:supply-source-locator unless tracing was enabled at compile time");
                    de.setErrorCode("SXSE0002");
                    throw de;
                }
            }
            return proxy;
        }
        if (result instanceof StreamResult) {
            Receiver target;
            Emitter emitter;
            String method = props.getProperty("method");
            if (method == null) {
                UncommittedSerializer target2 = this.newUncommittedSerializer(result, props);
                target2.setPipelineConfiguration(pipe);
                return target2;
            }
            CharacterMapExpander characterMapExpander = null;
            String useMaps = props.getProperty("use-character-maps");
            if (useMaps != null) {
                Controller controller;
                Controller controller2 = controller = pipe == null ? null : pipe.getController();
                if (controller == null) {
                    XPathException de = new XPathException("Cannot use character maps in an environment with no Controller");
                    de.setErrorCode("SXSE0001");
                    throw de;
                }
                characterMapExpander = controller.makeCharacterMapExpander(useMaps, this);
                characterMapExpander.setPipelineConfiguration(pipe);
            }
            ProxyReceiver normalizer = null;
            String normForm = props.getProperty("normalization-form");
            if (normForm != null && !normForm.equals("none")) {
                normalizer = this.newUnicodeNormalizer(pipe, props);
            }
            if ("html".equals(method)) {
                emitter = this.newHTMLEmitter();
                emitter.setPipelineConfiguration(pipe);
                target = this.createHTMLSerializer(emitter, props, pipe, characterMapExpander, normalizer);
            } else if ("xml".equals(method)) {
                emitter = this.newXMLEmitter();
                emitter.setPipelineConfiguration(pipe);
                target = this.createXMLSerializer(emitter, props, pipe, characterMapExpander, normalizer);
            } else if ("xhtml".equals(method)) {
                emitter = this.newXHTMLEmitter();
                emitter.setPipelineConfiguration(pipe);
                target = this.createXHTMLSerializer(emitter, props, pipe, characterMapExpander, normalizer);
            } else if ("text".equals(method)) {
                emitter = this.newTEXTEmitter();
                emitter.setPipelineConfiguration(pipe);
                target = this.createTextSerializer(emitter, props, pipe, characterMapExpander, normalizer);
            } else if ("{http://saxon.sf.net/}xquery".equals(method)) {
                emitter = new XQueryEmitter();
                emitter.setPipelineConfiguration(pipe);
                props.setProperty("omit-xml-declaration", "yes");
                target = this.createXMLSerializer(emitter, props, pipe, characterMapExpander, normalizer);
            } else {
                Receiver userReceiver;
                if (pipe == null) {
                    throw new XPathException("Unsupported serialization method " + method);
                }
                target = userReceiver = this.createUserDefinedOutputMethod(method, props, pipe);
                if (userReceiver instanceof Emitter) {
                    emitter = (Emitter)userReceiver;
                } else {
                    return userReceiver;
                }
            }
            emitter.setOutputProperties(props);
            StreamResult sr = (StreamResult)result;
            emitter.setStreamResult(sr);
            return target;
        }
        if (pipe != null) {
            List<ExternalObjectModel> externalObjectModels = pipe.getConfiguration().getExternalObjectModels();
            int m = 0;
            while (m < externalObjectModels.size()) {
                ExternalObjectModel model = externalObjectModels.get(m);
                Receiver builder = model.getDocumentBuilder(result);
                if (builder != null) {
                    builder.setSystemId(result.getSystemId());
                    builder.setPipelineConfiguration(pipe);
                    return builder;
                }
                ++m;
            }
        }
        throw new IllegalArgumentException("Unknown type of result: " + result.getClass());
    }

    protected Receiver createHTMLSerializer(Emitter emitter, Properties props, PipelineConfiguration pipe, CharacterMapExpander characterMapExpander, ProxyReceiver normalizer) throws XPathException {
        Receiver target = emitter;
        if (!"no".equals(props.getProperty("indent"))) {
            ProxyReceiver in = this.newHTMLIndenter(pipe, props);
            in.setUnderlyingReceiver(target);
            target = in;
        }
        if (normalizer != null) {
            normalizer.setUnderlyingReceiver(target);
            target = normalizer;
        }
        if (characterMapExpander != null) {
            characterMapExpander.setUnderlyingReceiver(target);
            target = characterMapExpander;
        }
        if (!"no".equals(props.getProperty("escape-uri-attributes"))) {
            ProxyReceiver escaper = this.newHTMLURIEscaper(pipe, props);
            escaper.setUnderlyingReceiver(target);
            target = escaper;
        }
        if (!"no".equals(props.getProperty("include-content-type"))) {
            MetaTagAdjuster mta = this.newHTMLMetaTagAdjuster(pipe, props);
            mta.setUnderlyingReceiver(target);
            target = mta;
        }
        return target;
    }

    protected Receiver createTextSerializer(Emitter emitter, Properties props, PipelineConfiguration pipe, CharacterMapExpander characterMapExpander, ProxyReceiver normalizer) throws XPathException {
        Receiver target = emitter;
        if (characterMapExpander != null) {
            characterMapExpander.setUnderlyingReceiver(target);
            characterMapExpander.setUseNullMarkers(false);
            target = characterMapExpander;
        }
        if (normalizer != null) {
            normalizer.setUnderlyingReceiver(target);
            target = normalizer;
        }
        return target;
    }

    protected Receiver createXHTMLSerializer(Emitter emitter, Properties props, PipelineConfiguration pipe, CharacterMapExpander characterMapExpander, ProxyReceiver normalizer) throws XPathException {
        String cdataElements;
        pipe.getConfiguration().getNamePool().allocateCodeForURI("http://www.w3.org/1999/xhtml");
        Receiver target = emitter;
        if (!"no".equals(props.getProperty("indent"))) {
            ProxyReceiver in = this.newXHTMLIndenter(pipe, props);
            in.setUnderlyingReceiver(target);
            target = in;
        }
        if (normalizer != null) {
            normalizer.setUnderlyingReceiver(target);
            target = normalizer;
        }
        if (characterMapExpander != null) {
            characterMapExpander.setUnderlyingReceiver(target);
            characterMapExpander.setPipelineConfiguration(pipe);
            target = characterMapExpander;
        }
        if ((cdataElements = props.getProperty("cdata-section-elements")) != null && cdataElements.length() > 0) {
            ProxyReceiver filter = this.newCDATAFilter(pipe, props);
            filter.setUnderlyingReceiver(target);
            target = filter;
        }
        if (!"no".equals(props.getProperty("escape-uri-attributes"))) {
            ProxyReceiver escaper = this.newHTMLURIEscaper(pipe, props);
            escaper.setUnderlyingReceiver(target);
            target = escaper;
        }
        if (!"no".equals(props.getProperty("include-content-type"))) {
            MetaTagAdjuster mta = this.newXHTMLMetaTagAdjuster(pipe, props);
            mta.setUnderlyingReceiver(target);
            target = mta;
        }
        return target;
    }

    protected Receiver createXMLSerializer(Emitter emitter, Properties props, PipelineConfiguration pipe, CharacterMapExpander characterMapExpander, ProxyReceiver normalizer) throws XPathException {
        String cdataElements;
        ProxyReceiver in;
        Receiver target = emitter;
        if ("1.0".equals(props.getProperty("version")) && pipe.getConfiguration().getXMLVersion() == 11) {
            in = this.newXML10ContentChecker(pipe, props);
            in.setUnderlyingReceiver(target);
            target = in;
        }
        if ("yes".equals(props.getProperty("indent"))) {
            in = this.newXMLIndenter(pipe, props);
            in.setUnderlyingReceiver(target);
            target = in;
        }
        if (normalizer != null) {
            normalizer.setUnderlyingReceiver(target);
            target = normalizer;
        }
        if (characterMapExpander != null) {
            characterMapExpander.setUnderlyingReceiver(target);
            target = characterMapExpander;
        }
        if ((cdataElements = props.getProperty("cdata-section-elements")) != null && cdataElements.length() > 0) {
            ProxyReceiver filter = this.newCDATAFilter(pipe, props);
            filter.setUnderlyingReceiver(target);
            target = filter;
        }
        return target;
    }

    protected Receiver createUserDefinedOutputMethod(String method, Properties props, PipelineConfiguration pipe) throws XPathException {
        Receiver userReceiver = pipe.getConfiguration().makeEmitter(method, pipe.getController());
        userReceiver.setPipelineConfiguration(pipe);
        if (userReceiver instanceof ContentHandlerProxy && "yes".equals(props.getProperty("{http://saxon.sf.net/}supply-source-locator"))) {
            if (pipe.getConfiguration().isCompileWithTracing()) {
                pipe.getController().addTraceListener(((ContentHandlerProxy)userReceiver).getTraceListener());
            } else {
                XPathException de = new XPathException("Cannot use saxon:supply-source-locator unless tracing was enabled at compile time");
                de.setErrorCode("SXSE0002");
                throw de;
            }
        }
        return userReceiver;
    }

    protected ContentHandlerProxy newContentHandlerProxy() {
        return new ContentHandlerProxy();
    }

    protected UncommittedSerializer newUncommittedSerializer(Result result, Properties properties) {
        return new UncommittedSerializer(result, properties);
    }

    protected Emitter newXMLEmitter() {
        return new XMLEmitter();
    }

    protected Emitter newHTMLEmitter() {
        return new HTMLEmitter();
    }

    protected Emitter newXHTMLEmitter() {
        return new XHTMLEmitter();
    }

    protected Emitter newTEXTEmitter() {
        return new TEXTEmitter();
    }

    protected ProxyReceiver newXMLIndenter(PipelineConfiguration pipe, Properties outputProperties) {
        XMLIndenter r = new XMLIndenter();
        r.setPipelineConfiguration(pipe);
        r.setOutputProperties(outputProperties);
        return r;
    }

    protected ProxyReceiver newHTMLIndenter(PipelineConfiguration pipe, Properties outputProperties) {
        HTMLIndenter r = new HTMLIndenter();
        r.setPipelineConfiguration(pipe);
        r.setOutputProperties(outputProperties);
        return r;
    }

    protected ProxyReceiver newXHTMLIndenter(PipelineConfiguration pipe, Properties outputProperties) {
        XHTMLIndenter r = new XHTMLIndenter();
        r.setPipelineConfiguration(pipe);
        r.setOutputProperties(outputProperties);
        return r;
    }

    protected MetaTagAdjuster newXHTMLMetaTagAdjuster(PipelineConfiguration pipe, Properties outputProperties) {
        MetaTagAdjuster r = new MetaTagAdjuster();
        r.setPipelineConfiguration(pipe);
        r.setOutputProperties(outputProperties);
        r.setIsXHTML(true);
        return r;
    }

    protected MetaTagAdjuster newHTMLMetaTagAdjuster(PipelineConfiguration pipe, Properties outputProperties) {
        MetaTagAdjuster r = new MetaTagAdjuster();
        r.setPipelineConfiguration(pipe);
        r.setOutputProperties(outputProperties);
        r.setIsXHTML(false);
        return r;
    }

    protected ProxyReceiver newHTMLURIEscaper(PipelineConfiguration pipe, Properties outputProperties) {
        HTMLURIEscaper r = new HTMLURIEscaper();
        r.setPipelineConfiguration(pipe);
        return r;
    }

    protected ProxyReceiver newCDATAFilter(PipelineConfiguration pipe, Properties outputProperties) throws XPathException {
        CDATAFilter r = new CDATAFilter();
        r.setPipelineConfiguration(pipe);
        r.setOutputProperties(outputProperties);
        return r;
    }

    protected ProxyReceiver newXML10ContentChecker(PipelineConfiguration pipe, Properties outputProperties) {
        XML10ContentChecker r = new XML10ContentChecker();
        r.setPipelineConfiguration(pipe);
        return r;
    }

    protected ProxyReceiver newUnicodeNormalizer(PipelineConfiguration pipe, Properties outputProperties) throws XPathException {
        String normForm = outputProperties.getProperty("normalization-form");
        UnicodeNormalizer r = new UnicodeNormalizer(normForm);
        r.setPipelineConfiguration(pipe);
        return r;
    }

    public CharacterMapExpander newCharacterMapExpander() {
        return new CharacterMapExpander();
    }
}

