/*
 * Decompiled with CFR 0.152.
 */
package net2.sf.saxon.event;

import net2.sf.saxon.Configuration;
import net2.sf.saxon.event.LocationProvider;
import net2.sf.saxon.event.PipelineConfiguration;
import net2.sf.saxon.event.Receiver;
import net2.sf.saxon.event.SequenceReceiver;
import net2.sf.saxon.om.Item;
import net2.sf.saxon.om.NamePool;
import net2.sf.saxon.trans.XPathException;

public abstract class ProxyReceiver
extends SequenceReceiver {
    protected Receiver nextReceiver;

    @Override
    public void setSystemId(String systemId) {
        if (systemId != this.systemId) {
            this.systemId = systemId;
            if (this.nextReceiver != null) {
                this.nextReceiver.setSystemId(systemId);
            }
        }
    }

    public void setUnderlyingReceiver(Receiver receiver) {
        if (receiver != this.nextReceiver) {
            this.nextReceiver = receiver;
            if (this.pipelineConfiguration != null && receiver != null) {
                this.nextReceiver.setPipelineConfiguration(this.pipelineConfiguration);
            }
        }
    }

    public Receiver getUnderlyingReceiver() {
        return this.nextReceiver;
    }

    @Override
    public void setPipelineConfiguration(PipelineConfiguration pipe) {
        if (this.pipelineConfiguration != pipe) {
            this.pipelineConfiguration = pipe;
            if (this.nextReceiver != null) {
                this.nextReceiver.setPipelineConfiguration(pipe);
            }
        }
    }

    @Override
    public Configuration getConfiguration() {
        return this.pipelineConfiguration.getConfiguration();
    }

    @Override
    public NamePool getNamePool() {
        return this.pipelineConfiguration.getConfiguration().getNamePool();
    }

    @Override
    public void open() throws XPathException {
        if (this.nextReceiver == null) {
            throw new IllegalStateException("ProxyReceiver.open(): no underlying receiver provided");
        }
        this.nextReceiver.open();
    }

    @Override
    public void close() throws XPathException {
        this.nextReceiver.close();
    }

    @Override
    public void startDocument(int properties) throws XPathException {
        this.nextReceiver.startDocument(properties);
    }

    @Override
    public void endDocument() throws XPathException {
        this.nextReceiver.endDocument();
    }

    @Override
    public void startElement(int nameCode, int typeCode, int locationId, int properties) throws XPathException {
        this.nextReceiver.startElement(nameCode, typeCode, locationId, properties);
    }

    @Override
    public void namespace(int namespaceCode, int properties) throws XPathException {
        this.nextReceiver.namespace(namespaceCode, properties);
    }

    @Override
    public void attribute(int nameCode, int typeCode, CharSequence value, int locationId, int properties) throws XPathException {
        this.nextReceiver.attribute(nameCode, typeCode, value, locationId, properties);
    }

    @Override
    public void startContent() throws XPathException {
        this.nextReceiver.startContent();
    }

    @Override
    public void endElement() throws XPathException {
        this.nextReceiver.endElement();
    }

    @Override
    public void characters(CharSequence chars, int locationId, int properties) throws XPathException {
        this.nextReceiver.characters(chars, locationId, properties);
    }

    @Override
    public void processingInstruction(String target, CharSequence data, int locationId, int properties) throws XPathException {
        this.nextReceiver.processingInstruction(target, data, locationId, properties);
    }

    @Override
    public void comment(CharSequence chars, int locationId, int properties) throws XPathException {
        this.nextReceiver.comment(chars, locationId, properties);
    }

    @Override
    public void setUnparsedEntity(String name, String uri, String publicId) throws XPathException {
        this.nextReceiver.setUnparsedEntity(name, uri, publicId);
    }

    @Override
    public void append(Item item, int locationId, int copyNamespaces) throws XPathException {
        if (!(this.nextReceiver instanceof SequenceReceiver)) {
            throw new UnsupportedOperationException("append() method is not supported in this class");
        }
        ((SequenceReceiver)this.nextReceiver).append(item, locationId, copyNamespaces);
    }

    public LocationProvider getDocumentLocator() {
        return this.pipelineConfiguration.getLocationProvider();
    }

    @Override
    public boolean usesTypeAnnotations() {
        return this.nextReceiver == null || this.nextReceiver.usesTypeAnnotations();
    }
}

