/*
 * Decompiled with CFR 0.152.
 */
package net2.sf.saxon.event;

import javax.xml.transform.ErrorListener;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.URIResolver;
import net2.sf.saxon.Configuration;
import net2.sf.saxon.Controller;
import net2.sf.saxon.event.CopyInformee;
import net2.sf.saxon.event.LocationProvider;
import net2.sf.saxon.event.ParseOptions;
import net2.sf.saxon.expr.ExpressionLocation;
import net2.sf.saxon.type.SchemaURIResolver;

public class PipelineConfiguration {
    private Configuration config;
    private LocationProvider locationProvider;
    private URIResolver uriResolver;
    private SchemaURIResolver schemaURIResolver;
    private Controller controller;
    private ParseOptions parseOptions;
    private boolean isSerializing;
    private boolean recoverFromValidationErrors = false;
    private boolean shallowValidation = false;
    private int hostLanguage = 50;
    private CopyInformee copyInformee = null;

    public PipelineConfiguration() {
        this.parseOptions = new ParseOptions();
    }

    public PipelineConfiguration(PipelineConfiguration p) {
        this.config = p.config;
        this.locationProvider = p.locationProvider;
        this.uriResolver = p.uriResolver;
        this.schemaURIResolver = p.schemaURIResolver;
        this.controller = p.controller;
        this.isSerializing = p.isSerializing;
        this.parseOptions = new ParseOptions(p.parseOptions);
        this.hostLanguage = p.hostLanguage;
        this.recoverFromValidationErrors = p.recoverFromValidationErrors;
        this.copyInformee = p.copyInformee;
        this.shallowValidation = p.shallowValidation;
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    public void setConfiguration(Configuration config) {
        this.config = config;
    }

    public LocationProvider getLocationProvider() {
        return this.locationProvider;
    }

    public void setLocationProvider(LocationProvider locationProvider) {
        this.locationProvider = locationProvider;
    }

    public SourceLocator getSourceLocation(long locationId) {
        return new ExpressionLocation(this.locationProvider, locationId);
    }

    public ErrorListener getErrorListener() {
        return this.parseOptions.getErrorListener();
    }

    public void setErrorListener(ErrorListener errorListener) {
        this.parseOptions.setErrorListener(errorListener);
    }

    public URIResolver getURIResolver() {
        return this.uriResolver;
    }

    public void setURIResolver(URIResolver uriResolver) {
        this.uriResolver = uriResolver;
    }

    public SchemaURIResolver getSchemaURIResolver() {
        return this.schemaURIResolver;
    }

    public void setParseOptions(ParseOptions options) {
        this.parseOptions = options;
    }

    public ParseOptions getParseOptions() {
        return this.parseOptions;
    }

    public void setUseXsiSchemaLocation(boolean recognize) {
        this.parseOptions.setUseXsiSchemaLocation(recognize);
    }

    public void setRecoverFromValidationErrors(boolean recover) {
        this.recoverFromValidationErrors = recover;
    }

    public boolean isRecoverFromValidationErrors() {
        return this.recoverFromValidationErrors;
    }

    public void setShallowValidation(boolean shallow) {
        this.shallowValidation = shallow;
    }

    public boolean isShallowValidation() {
        return this.shallowValidation;
    }

    public void setSchemaURIResolver(SchemaURIResolver resolver) {
        this.schemaURIResolver = resolver;
    }

    public Controller getController() {
        return this.controller;
    }

    public void setController(Controller controller) {
        this.controller = controller;
    }

    public int getHostLanguage() {
        return this.hostLanguage;
    }

    public void setHostLanguage(int language) {
        this.hostLanguage = language;
    }

    public boolean isSerializing() {
        return this.isSerializing;
    }

    public void setSerializing(boolean isSerializing) {
        this.isSerializing = isSerializing;
    }

    public void setExpandAttributeDefaults(boolean expand) {
        this.parseOptions.setExpandAttributeDefaults(expand);
    }

    public boolean isExpandAttributeDefaults() {
        return this.parseOptions.isExpandAttributeDefaults();
    }

    public void setCopyInformee(CopyInformee informee) {
        this.copyInformee = informee;
    }

    public CopyInformee getCopyInformee() {
        return this.copyInformee;
    }
}

