/*
 * Decompiled with CFR 0.152.
 */
package net2.sf.saxon.event;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Properties;
import javax.xml.transform.Result;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamResult;
import net2.sf.saxon.Configuration;
import net2.sf.saxon.charcode.CharacterSet;
import net2.sf.saxon.charcode.UTF16CharacterSet;
import net2.sf.saxon.charcode.UTF8CharacterSet;
import net2.sf.saxon.event.PipelineConfiguration;
import net2.sf.saxon.event.Receiver;
import net2.sf.saxon.event.UTF8Writer;
import net2.sf.saxon.om.NamePool;
import net2.sf.saxon.trans.XPathException;

public abstract class Emitter
implements Result,
Receiver {
    protected PipelineConfiguration pipelineConfig;
    protected NamePool namePool;
    protected String systemId;
    protected StreamResult streamResult;
    protected Writer writer;
    protected OutputStream outputStream;
    protected Properties outputProperties;
    protected CharacterSet characterSet = null;
    protected boolean allCharactersEncodable = false;

    @Override
    public void setPipelineConfiguration(PipelineConfiguration pipe) {
        this.pipelineConfig = pipe;
        this.namePool = pipe.getConfiguration().getNamePool();
    }

    @Override
    public PipelineConfiguration getPipelineConfiguration() {
        return this.pipelineConfig;
    }

    public Configuration getConfiguration() {
        return this.pipelineConfig.getConfiguration();
    }

    @Override
    public void setSystemId(String systemId) {
        this.systemId = systemId;
    }

    @Override
    public String getSystemId() {
        return this.systemId;
    }

    public void setOutputProperties(Properties details) throws XPathException {
        if (this.characterSet == null) {
            this.characterSet = this.getConfiguration().getCharacterSetFactory().getCharacterSet(details);
            this.allCharactersEncodable = this.characterSet instanceof UTF8CharacterSet || this.characterSet instanceof UTF16CharacterSet;
        }
        this.outputProperties = details;
    }

    public Properties getOutputProperties() {
        return this.outputProperties;
    }

    public void setStreamResult(StreamResult result) throws XPathException {
        this.streamResult = result;
        if (this.systemId == null) {
            this.systemId = result.getSystemId();
        }
    }

    protected void makeWriter() throws XPathException {
        OutputStream os;
        if (this.writer != null) {
            return;
        }
        if (this.streamResult == null) {
            throw new IllegalStateException("Emitter must have either a Writer or a StreamResult to write to");
        }
        this.writer = this.streamResult.getWriter();
        if (this.writer == null && (os = this.streamResult.getOutputStream()) != null) {
            this.setOutputStream(os);
        }
        if (this.writer == null) {
            String uriString = this.streamResult.getSystemId();
            if (uriString == null) {
                throw new XPathException("Result has no system ID, writer, or output stream defined");
            }
            try {
                URI uri = new URI(uriString);
                if (!uri.isAbsolute()) {
                    try {
                        uri = new File(uriString).getAbsoluteFile().toURI();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                File file = new File(uri);
                try {
                    if ("file".equals(uri.getScheme()) && !file.exists()) {
                        File directory = file.getParentFile();
                        if (directory != null && !directory.exists()) {
                            directory.mkdirs();
                        }
                        file.createNewFile();
                    }
                }
                catch (IOException err) {
                    throw new XPathException("Failed to create output file " + uri, err);
                }
                this.setOutputStream(new FileOutputStream(file));
                this.streamResult.setOutputStream(this.outputStream);
            }
            catch (FileNotFoundException fnf) {
                throw new XPathException(fnf);
            }
            catch (URISyntaxException use) {
                throw new XPathException(use);
            }
            catch (IllegalArgumentException iae) {
                throw new XPathException(iae);
            }
        }
    }

    public boolean usesWriter() {
        return true;
    }

    public void setWriter(Writer writer) throws XPathException {
        this.writer = writer;
        if (writer instanceof OutputStreamWriter && this.outputProperties != null) {
            String enc = ((OutputStreamWriter)writer).getEncoding();
            this.outputProperties.setProperty("encoding", enc);
            this.characterSet = this.getConfiguration().getCharacterSetFactory().getCharacterSet(this.outputProperties);
            this.allCharactersEncodable = this.characterSet instanceof UTF8CharacterSet || this.characterSet instanceof UTF16CharacterSet;
        }
    }

    public Writer getWriter() {
        return this.writer;
    }

    public void setOutputStream(OutputStream stream) throws XPathException {
        this.outputStream = stream;
        if (this.usesWriter()) {
            String encoding;
            if (this.outputProperties == null) {
                this.outputProperties = new Properties();
            }
            if ((encoding = this.outputProperties.getProperty("encoding")) == null) {
                encoding = "UTF8";
                this.allCharactersEncodable = true;
            } else if (encoding.equalsIgnoreCase("UTF-8")) {
                encoding = "UTF8";
                this.allCharactersEncodable = true;
            } else if (encoding.equalsIgnoreCase("UTF-16")) {
                encoding = "UTF16";
            }
            String byteOrderMark = this.outputProperties.getProperty("byte-order-mark");
            if ("no".equals(byteOrderMark) && "UTF16".equals(encoding)) {
                encoding = "UTF-16BE";
            } else if (!(this.characterSet instanceof UTF8CharacterSet)) {
                encoding = this.characterSet.getCanonicalName();
            }
            while (true) {
                try {
                    String javaEncoding = encoding;
                    if (encoding.equalsIgnoreCase("iso-646") || encoding.equalsIgnoreCase("iso646")) {
                        javaEncoding = "US-ASCII";
                    }
                    if (encoding.equalsIgnoreCase("UTF8")) {
                        this.writer = new UTF8Writer(this.outputStream);
                        break;
                    }
                    this.writer = new BufferedWriter(new OutputStreamWriter(this.outputStream, javaEncoding));
                }
                catch (Exception err) {
                    if (encoding.equalsIgnoreCase("UTF8")) {
                        throw new XPathException("Failed to create a UTF8 output writer");
                    }
                    XPathException de = new XPathException("Encoding " + encoding + " is not supported: using UTF8");
                    de.setErrorCode("SESU0007");
                    try {
                        this.getPipelineConfiguration().getErrorListener().error(de);
                    }
                    catch (TransformerException e) {
                        throw XPathException.makeXPathException(e);
                    }
                    encoding = "UTF8";
                    this.characterSet = UTF8CharacterSet.getInstance();
                    this.allCharactersEncodable = true;
                    this.outputProperties.setProperty("encoding", "UTF-8");
                    continue;
                }
                break;
            }
        }
    }

    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    @Override
    public void setUnparsedEntity(String name, String uri, String publicId) throws XPathException {
    }
}

