/*
 * Decompiled with CFR 0.152.
 */
package net2.sf.saxon.event;

import java.util.List;
import net2.sf.saxon.charcode.UTF16CharacterSet;
import net2.sf.saxon.event.ProxyReceiver;
import net2.sf.saxon.om.FastStringBuffer;
import net2.sf.saxon.sort.IntHashMap;
import net2.sf.saxon.sort.IntIterator;
import net2.sf.saxon.tinytree.CompressedWhitespace;
import net2.sf.saxon.trans.XPathException;
import net2.sf.saxon.value.Whitespace;

public class CharacterMapExpander
extends ProxyReceiver {
    private IntHashMap charMap;
    private int min = Integer.MAX_VALUE;
    private int max = 0;
    private boolean mapsWhitespace = false;
    private boolean useNullMarkers = true;

    public void setCharacterMaps(List maps) {
        this.charMap = new IntHashMap(64);
        int i = 0;
        while (i < maps.size()) {
            IntHashMap hashMap = (IntHashMap)maps.get(i);
            IntIterator keys = hashMap.keyIterator();
            while (keys.hasNext()) {
                int next = keys.next();
                if (next < this.min) {
                    this.min = next;
                }
                if (next > this.max) {
                    this.max = next;
                }
                if (!this.mapsWhitespace && Whitespace.isWhitespace(next)) {
                    this.mapsWhitespace = true;
                }
                this.charMap.put(next, hashMap.get(next));
            }
            ++i;
        }
        if (this.min > 55296) {
            this.min = 55296;
        }
    }

    public void setUseNullMarkers(boolean use) {
        this.useNullMarkers = use;
    }

    @Override
    public void attribute(int nameCode, int typeCode, CharSequence value, int locationId, int properties) throws XPathException {
        if ((properties & 2) == 0) {
            CharSequence mapped = this.map(value, this.useNullMarkers);
            if (mapped == value) {
                this.nextReceiver.attribute(nameCode, typeCode, value, locationId, properties);
            } else {
                this.nextReceiver.attribute(nameCode, typeCode, mapped, locationId, (properties | 0x100) & 0xFFFFFFFB);
            }
        } else {
            this.nextReceiver.attribute(nameCode, typeCode, value, locationId, properties);
        }
    }

    @Override
    public void characters(CharSequence chars, int locationId, int properties) throws XPathException {
        if ((properties & 1) == 0) {
            CharSequence mapped = this.map(chars, this.useNullMarkers);
            if (mapped != chars) {
                properties = (properties | 0x100) & 0xFFFFFFFB;
            }
            this.nextReceiver.characters(mapped, locationId, properties);
        } else {
            this.nextReceiver.characters(chars, locationId, properties);
        }
    }

    private CharSequence map(CharSequence in, boolean insertNulls) {
        if (!this.mapsWhitespace && in instanceof CompressedWhitespace) {
            return in;
        }
        boolean move = false;
        int i = 0;
        while (i < in.length()) {
            char c;
            if ((c = in.charAt(i++)) < this.min || c > this.max) continue;
            move = true;
            break;
        }
        if (!move) {
            return in;
        }
        FastStringBuffer buffer = new FastStringBuffer(in.length() * 2);
        int i2 = 0;
        while (i2 < in.length()) {
            char c;
            if ((c = in.charAt(i2++)) >= this.min && c <= this.max) {
                if (UTF16CharacterSet.isHighSurrogate(c)) {
                    char d;
                    int s;
                    String rep;
                    if ((rep = (String)this.charMap.get(s = UTF16CharacterSet.combinePair(c, d = in.charAt(i2++)))) == null) {
                        buffer.append(c);
                        buffer.append(d);
                        continue;
                    }
                    if (insertNulls) {
                        buffer.append('\u0000');
                        buffer.append(rep);
                        buffer.append('\u0000');
                        continue;
                    }
                    buffer.append(rep);
                    continue;
                }
                String rep = (String)this.charMap.get(c);
                if (rep == null) {
                    buffer.append(c);
                    continue;
                }
                if (insertNulls) {
                    buffer.append('\u0000');
                    buffer.append(rep);
                    buffer.append('\u0000');
                    continue;
                }
                buffer.append(rep);
                continue;
            }
            buffer.append(c);
        }
        return buffer;
    }
}

