/*
 * Decompiled with CFR 0.152.
 */
package net2.sf.saxon.dom;

import net2.sf.saxon.dom.DOMExceptionImpl;
import net2.sf.saxon.dom.NodeOverNodeInfo;
import net2.sf.saxon.type.ComplexType;
import net2.sf.saxon.type.SchemaType;
import net2.sf.saxon.value.Whitespace;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMException;
import org.w3c.dom.Text;

public class TextOverNodeInfo
extends NodeOverNodeInfo
implements Text,
Comment {
    @Override
    public String getData() {
        return this.node.getStringValue();
    }

    @Override
    public void setData(String data) throws DOMException {
        TextOverNodeInfo.disallowUpdate();
    }

    @Override
    public int getLength() {
        return this.node.getStringValue().length();
    }

    @Override
    public String substringData(int offset, int count) throws DOMException {
        try {
            return this.node.getStringValue().substring(offset, offset + count);
        }
        catch (IndexOutOfBoundsException err2) {
            throw new DOMExceptionImpl(1, "substringData: index out of bounds");
        }
    }

    @Override
    public void appendData(String arg) throws DOMException {
        TextOverNodeInfo.disallowUpdate();
    }

    @Override
    public void insertData(int offset, String arg) throws DOMException {
        TextOverNodeInfo.disallowUpdate();
    }

    @Override
    public void deleteData(int offset, int count) throws DOMException {
        TextOverNodeInfo.disallowUpdate();
    }

    @Override
    public void replaceData(int offset, int count, String arg) throws DOMException {
        TextOverNodeInfo.disallowUpdate();
    }

    @Override
    public Text splitText(int offset) throws DOMException {
        TextOverNodeInfo.disallowUpdate();
        return null;
    }

    @Override
    public Text replaceWholeText(String content) throws DOMException {
        TextOverNodeInfo.disallowUpdate();
        return null;
    }

    @Override
    public boolean isElementContentWhitespace() {
        if (this.node.getNodeKind() != 3) {
            throw new UnsupportedOperationException("Method is defined only on text nodes");
        }
        int annotation = this.node.getParent().getTypeAnnotation();
        if (annotation == -1) {
            return false;
        }
        if (!Whitespace.isWhite(this.node.getStringValue())) {
            return false;
        }
        SchemaType type = this.node.getConfiguration().getSchemaType(annotation);
        if (!type.isComplexType()) {
            return false;
        }
        return !((ComplexType)type).isMixedContent();
    }

    @Override
    public String getWholeText() {
        if (this.node.getNodeKind() != 3) {
            throw new UnsupportedOperationException("Method is defined only on text nodes");
        }
        return this.node.getStringValue();
    }
}

