/*
 * Decompiled with CFR 0.152.
 */
package net2.sf.saxon.dom;

import net2.sf.saxon.Configuration;
import net2.sf.saxon.dom.DocumentOverNodeInfo;
import net2.sf.saxon.dom.NodeOverNodeInfo;
import net2.sf.saxon.dom.TypeInfoImpl;
import net2.sf.saxon.om.AxisIterator;
import net2.sf.saxon.om.NamePool;
import net2.sf.saxon.om.Navigator;
import net2.sf.saxon.om.NodeInfo;
import net2.sf.saxon.pattern.NameTest;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.TypeInfo;

public class ElementOverNodeInfo
extends NodeOverNodeInfo
implements Element {
    @Override
    public String getTagName() {
        return this.node.getDisplayName();
    }

    @Override
    public NodeList getElementsByTagName(String name) {
        return DocumentOverNodeInfo.getElementsByTagName(this.node, name);
    }

    @Override
    public NodeList getElementsByTagNameNS(String namespaceURI, String localName) throws DOMException {
        return DocumentOverNodeInfo.getElementsByTagNameNS(this.node, namespaceURI, localName);
    }

    @Override
    public String getAttribute(String name) {
        NodeInfo att;
        AxisIterator atts = this.node.iterateAxis((byte)2);
        do {
            if ((att = (NodeInfo)atts.next()) != null) continue;
            return "";
        } while (!att.getDisplayName().equals(name));
        String val = att.getStringValue();
        if (val == null) {
            return "";
        }
        return val;
    }

    @Override
    public Attr getAttributeNode(String name) {
        NodeInfo att;
        AxisIterator atts = this.node.iterateAxis((byte)2);
        do {
            if ((att = (NodeInfo)atts.next()) != null) continue;
            return null;
        } while (!att.getDisplayName().equals(name));
        return (Attr)((Object)att);
    }

    @Override
    public Attr setAttributeNode(Attr newAttr) throws DOMException {
        ElementOverNodeInfo.disallowUpdate();
        return null;
    }

    @Override
    public void removeAttribute(String oldAttr) throws DOMException {
        ElementOverNodeInfo.disallowUpdate();
    }

    @Override
    public Attr removeAttributeNode(Attr oldAttr) throws DOMException {
        ElementOverNodeInfo.disallowUpdate();
        return null;
    }

    @Override
    public String getAttributeNS(String namespaceURI, String localName) {
        String val = Navigator.getAttributeValue(this.node, namespaceURI == null ? "" : namespaceURI, localName);
        if (val == null) {
            return "";
        }
        return val;
    }

    @Override
    public void setAttribute(String name, String value) throws DOMException {
        ElementOverNodeInfo.disallowUpdate();
    }

    @Override
    public void setAttributeNS(String namespaceURI, String qualifiedName, String value) throws DOMException {
        ElementOverNodeInfo.disallowUpdate();
    }

    @Override
    public void removeAttributeNS(String namespaceURI, String localName) throws DOMException {
        ElementOverNodeInfo.disallowUpdate();
    }

    @Override
    public Attr getAttributeNodeNS(String namespaceURI, String localName) {
        NamePool pool = this.node.getNamePool();
        int fingerprint = pool.getFingerprint(namespaceURI == null ? "" : namespaceURI, localName);
        if (fingerprint == -1) {
            return null;
        }
        NameTest test = new NameTest(2, fingerprint, pool);
        AxisIterator atts = this.node.iterateAxis((byte)2, test);
        return (Attr)((Object)ElementOverNodeInfo.wrap((NodeInfo)atts.next()));
    }

    @Override
    public Attr setAttributeNodeNS(Attr newAttr) throws DOMException {
        ElementOverNodeInfo.disallowUpdate();
        return null;
    }

    @Override
    public boolean hasAttribute(String name) {
        NodeInfo att;
        AxisIterator atts = this.node.iterateAxis((byte)2);
        do {
            if ((att = (NodeInfo)atts.next()) != null) continue;
            return false;
        } while (!att.getDisplayName().equals(name));
        return true;
    }

    @Override
    public boolean hasAttributeNS(String namespaceURI, String localName) {
        return Navigator.getAttributeValue(this.node, namespaceURI == null ? "" : namespaceURI, localName) != null;
    }

    @Override
    public void setIdAttribute(String name, boolean isId) throws DOMException {
        ElementOverNodeInfo.disallowUpdate();
    }

    @Override
    public void setIdAttributeNS(String namespaceURI, String localName, boolean isId) throws DOMException {
        ElementOverNodeInfo.disallowUpdate();
    }

    @Override
    public void setIdAttributeNode(Attr idAttr, boolean isId) throws DOMException {
        ElementOverNodeInfo.disallowUpdate();
    }

    @Override
    public TypeInfo getSchemaTypeInfo() {
        int annotation = this.node.getTypeAnnotation();
        if (annotation == -1) {
            return null;
        }
        Configuration config = this.node.getConfiguration();
        return new TypeInfoImpl(config, config.getSchemaType(annotation));
    }
}

